/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.report;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import org.compiere.report.JasperReportViewer;

class ExportListener
implements ActionListener {
    private JasperReportViewer viewer;

    public ExportListener(JasperReportViewer viewer) {
        this.viewer = viewer;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setSelectedFile(new File(this.viewer.getJasperPrint().getName() + "." + this.viewer.getFormat().toLowerCase()));
        if (fileChooser.showSaveDialog((Component)((Object)this.viewer)) == 0) {
            File file = fileChooser.getSelectedFile();
            try {
                if (this.viewer.getFormat().equals("PDF")) {
                    JasperExportManager.exportReportToPdfFile((JasperPrint)this.viewer.getJasperPrint(), (String)file.getAbsolutePath());
                } else if (this.viewer.getFormat().equals("HTML")) {
                    JasperExportManager.exportReportToHtmlFile((JasperPrint)this.viewer.getJasperPrint(), (String)file.getAbsolutePath());
                } else if (this.viewer.getFormat().equals("XLS")) {
                    JRXlsExporter exporter = new JRXlsExporter();
                    exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)file.getAbsolutePath());
                    exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)this.viewer.getJasperPrint());
                    exporter.exportReport();
                }
            }
            catch (JRException e) {
                e.printStackTrace();
            }
        }
    }
}

