/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.report;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.compiere.model.MAccount;
import org.compiere.model.MAttachment;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MClientInfo;
import org.compiere.model.MImage;
import org.compiere.model.MLocation;
import org.compiere.model.MOrg;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPeriod;
import org.compiere.model.MReportCube;
import org.compiere.model.X_AD_OrgInfo;
import org.compiere.print.MPrintFormat;
import org.compiere.print.MPrintFormatItem;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.report.FinReportAbstract;
import org.compiere.report.FinReportPeriod;
import org.compiere.report.MReport;
import org.compiere.report.MReportColumn;
import org.compiere.report.MReportLine;
import org.compiere.report.MReportSource;
import org.compiere.report.MReportTree;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CLogMgt;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.CacheMgt;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;

public class FinReport
extends FinReportAbstract {
    private long start = System.currentTimeMillis();
    private MReport finReport = null;
    private FinReportPeriod[] finReportPeriods = null;
    private int reportPeriod = -1;
    private StringBuffer parameterWhere = new StringBuffer();
    private MReportColumn[] reportColumns;
    private MReportLine[] reportLines;
    private static String INSERT = "INSERT";
    private static String UPDATE = "UPDATE";

    @Override
    protected void prepare() {
        super.prepare();
        StringBuffer sb = new StringBuffer("Record_ID=").append(this.getRecord_ID());
        if (this.getOrgId() != 0) {
            this.parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.getHierarchyId(), "OO", this.getOrgId()));
        }
        if (this.getBPartnerId() != 0) {
            this.parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.getHierarchyId(), "BP", this.getBPartnerId()));
        }
        if (this.getProductId() != 0) {
            this.parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.getHierarchyId(), "PR", this.getProductId()));
        }
        if (this.getProjectId() != 0) {
            this.parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.getHierarchyId(), "PJ", this.getProjectId()));
        }
        if (this.getActivityId() != 0) {
            this.parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.getHierarchyId(), "AY", this.getActivityId()));
        }
        if (this.getCampaignId() != 0) {
            this.parameterWhere.append(" AND C_Campaign_ID=").append(this.getCampaignId());
        }
        if (this.getSalesRegionId() != 0) {
            this.parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.getHierarchyId(), "SR", this.getSalesRegionId()));
        }
        if (this.getUser1Id() != 0) {
            this.parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.getHierarchyId(), "U1", this.getUser1Id()));
        }
        if (this.getUser2Id() != 0) {
            this.parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.getHierarchyId(), "U2", this.getUser2Id()));
        }
        if (this.getUser3Id() != 0) {
            this.parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.getHierarchyId(), "U3", this.getUser3Id()));
        }
        if (this.getUser4Id() != 0) {
            this.parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.getHierarchyId(), "U4", this.getUser4Id()));
        }
        if (this.getUserElement1Id() != 0) {
            this.parameterWhere.append(" AND UserElement1_ID=").append(this.getUserElement1Id());
        }
        if (this.getUserElement2Id() != 0) {
            this.parameterWhere.append(" AND UserElement2_ID=").append(this.getUserElement1Id());
        }
        this.finReport = new MReport(this.getCtx(), this.getRecord_ID(), null);
        sb.append(" - ").append(this.finReport);
        this.setPeriods();
        sb.append(" - C_Period_ID=").append(this.getPeriodId()).append(" - ").append(this.parameterWhere);
        ProcessInfoParameter[] pi = this.getProcessInfo().getParameter();
        pi[0].setParameter(new Integer(this.getPeriodId()));
        this.getProcessInfo().setParameter(pi);
        this.log.info(sb.toString());
    }

    private String getWhereClause() {
        String whereClause = this.parameterWhere.toString();
        if (this.getReportCubeId() > 0) {
            whereClause = whereClause + " AND PA_ReportCube_ID=" + this.getReportCubeId();
        }
        return whereClause;
    }

    private String getWhereClauseForTrx() {
        return this.parameterWhere.toString();
    }

    private String getWherePostingType(boolean withAND) {
        String postingType = this.getPostingType();
        int budgetId = this.getBudgetId();
        StringBuffer whereClause = new StringBuffer();
        if (!Util.isEmpty(postingType)) {
            if (withAND) {
                whereClause.append(" AND ");
            }
            whereClause.append("PostingType='").append(postingType).append("' ");
            if (postingType.equals("B") && budgetId > 0) {
                whereClause.append(" AND GL_Budget_ID=" + budgetId);
            }
        }
        return whereClause.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPeriods() {
        this.log.info("C_Calendar_ID=" + this.finReport.getC_Calendar_ID());
        Timestamp today = TimeUtil.getDay(System.currentTimeMillis());
        ArrayList<FinReportPeriod> reportPeriods = new ArrayList<FinReportPeriod>();
        String sql = "SELECT p.C_Period_ID, p.Name, p.StartDate, p.EndDate, MIN(p1.StartDate) FROM C_Period p  INNER JOIN C_Year y ON (p.C_Year_ID=y.C_Year_ID), C_Period p1 WHERE y.C_Calendar_ID=? AND p1.C_Year_ID=y.C_Year_ID AND p1.PeriodType='S' GROUP BY p.C_Period_ID, p.Name, p.StartDate, p.EndDate ORDER BY p.StartDate";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.finReport.getC_Calendar_ID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                FinReportPeriod period = new FinReportPeriod(rs.getInt(1), rs.getString(2), rs.getTimestamp(3), rs.getTimestamp(4), rs.getTimestamp(5));
                reportPeriods.add(period);
                if (this.getPeriodId() != 0 || !period.inPeriod(today)) continue;
                this.setPeriodId(period.getC_Period_ID());
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        this.finReportPeriods = new FinReportPeriod[reportPeriods.size()];
        reportPeriods.toArray(this.finReportPeriods);
        if (this.getPeriodId() == 0) {
            this.reportPeriod = this.finReportPeriods.length - 1;
            this.setPeriodId(this.finReportPeriods[this.reportPeriod].getC_Period_ID());
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("AD_PInstance_ID=" + this.getAD_PInstance_ID());
        if (this.getReportCubeId() > 0) {
            MReportCube cube = new MReportCube(this.getCtx(), this.getReportCubeId(), this.get_TrxName());
            String result = cube.update(false, false);
            this.log.log(Level.FINE, result);
        }
        int reportLineSetId = this.finReport.getLineSet().getPA_ReportLineSet_ID();
        StringBuffer sql = new StringBuffer("INSERT INTO T_Report (AD_PInstance_ID, PA_ReportLine_ID, Record_ID,Fact_Acct_ID, SeqNo,LevelNo, Name,Description,TabLevel, ReportLineStyle, FixedPercentage) SELECT ").append(this.getAD_PInstance_ID()).append(", PA_ReportLine_ID, 0,0, SeqNo,0, Name,Description,TabLevel,ReportLineStyle,FixedPercentage FROM PA_ReportLine WHERE IsActive='Y' AND PA_ReportLineSet_ID=").append(reportLineSetId);
        int no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Report Lines = " + no);
        this.reportColumns = this.finReport.getColumnSet().getColumns();
        if (this.reportColumns.length == 0) {
            throw new AdempiereUserError("@No@ @PA_ReportColumn_ID@");
        }
        this.reportLines = this.finReport.getLineSet().getLines();
        if (this.reportLines.length == 0) {
            throw new AdempiereUserError("@No@ @PA_ReportLine_ID@");
        }
        for (MReportLine reportLine : this.reportLines) {
            if (!reportLine.isLineTypeSegmentValue()) continue;
            this.insertLine(reportLine);
        }
        this.insertLineDetail();
        this.doCalculations();
        this.deleteUnprintedLines();
        this.scaleResults();
        if (Ini.isClient()) {
            this.getProcessInfo().setTransientObject(this.getPrintFormat());
        } else if (this.getProcessInfo().getSerializableObject() != null) {
            MPrintFormat format = null;
            Serializable so = this.getProcessInfo().getSerializableObject();
            if (so instanceof MPrintFormat) {
                format = (MPrintFormat)so;
            }
            if (format != null) {
                this.finReport.setAD_PrintFormat_ID(format.getAD_PrintFormat_ID());
            }
        } else {
            this.getProcessInfo().setSerializableObject(this.getPrintFormat());
        }
        this.log.fine(System.currentTimeMillis() - this.start + " ms");
        return "";
    }

    private void insertLine(MReportLine reportLine) {
        String whereReport;
        this.log.info("" + reportLine);
        if (reportLine == null || reportLine.getSources().length == 0) {
            this.log.warning("No Source lines: " + reportLine);
            return;
        }
        StringBuilder whereClause = new StringBuilder();
        String whereReportLine = reportLine.getWhereClause(this.getHierarchyId(), this.getWherePostingType(false));
        if (whereReportLine != null && whereReportLine.length() > 0) {
            whereClause.append(whereReportLine);
        }
        if ((whereReport = this.finReport.getWhereClause()) != null && whereReport.length() > 0) {
            whereClause.append(" AND ").append(whereReport);
            whereClause.append(this.getWhereClause());
        }
        StringBuilder sqlStatementColumn = new StringBuilder(this.getColumnStatement(UPDATE, reportLine, whereClause.toString(), false));
        StringBuilder sqlStatementReport = new StringBuilder("UPDATE T_Report SET ");
        if (sqlStatementColumn.length() > 0) {
            sqlStatementColumn.append(" WHERE AD_PInstance_ID=").append(this.getAD_PInstance_ID()).append(" AND PA_ReportLine_ID=").append(reportLine.getPA_ReportLine_ID()).append(" AND ABS(LevelNo)<2");
            sqlStatementReport.append((CharSequence)sqlStatementColumn);
            int no = DB.executeUpdate(sqlStatementReport.toString(), this.get_TrxName());
            if (no != 1) {
                this.log.log(Level.SEVERE, "#=" + no + " for " + sqlStatementReport);
            }
            this.log.finest(sqlStatementReport.toString());
        }
    }

    private void doCalculations() {
        for (MReportLine reportLine : this.reportLines) {
            int col;
            int no;
            int col2;
            StringBuffer updateReportLine;
            if (!reportLine.isLineTypeCalculation()) continue;
            int operation_1 = reportLine.getOper_1_ID();
            int operation_2 = reportLine.getOper_2_ID();
            this.log.fine("Line " + reportLine.getSeqNo() + " = #" + operation_1 + " " + reportLine.getCalculationType() + " #" + operation_2);
            if (reportLine.isCalculationTypeAdd() || reportLine.isCalculationTypeRange()) {
                if (operation_1 > operation_2) {
                    int temp = operation_1;
                    operation_1 = operation_2;
                    operation_2 = temp;
                }
                updateReportLine = new StringBuffer("UPDATE T_Report SET (");
                for (col2 = 0; col2 < this.reportColumns.length; ++col2) {
                    if (col2 > 0) {
                        updateReportLine.append(",");
                    }
                    updateReportLine.append("Col_").append(col2);
                }
                updateReportLine.append(") = (SELECT ");
                for (col2 = 0; col2 < this.reportColumns.length; ++col2) {
                    if (col2 > 0) {
                        updateReportLine.append(",");
                    }
                    updateReportLine.append("COALESCE(SUM(r2.Col_").append(col2).append("),0)");
                }
                updateReportLine.append(" FROM T_Report r2 WHERE r2.AD_PInstance_ID=").append(this.getAD_PInstance_ID()).append(" AND r2.PA_ReportLine_ID IN (");
                if (reportLine.isCalculationTypeAdd()) {
                    updateReportLine.append(operation_1).append(",").append(operation_2);
                } else {
                    updateReportLine.append(this.getLineIds(operation_1, operation_2));
                }
                updateReportLine.append(") AND ABS(r2.LevelNo)<1) WHERE AD_PInstance_ID=").append(this.getAD_PInstance_ID()).append(" AND PA_ReportLine_ID=").append(reportLine.getPA_ReportLine_ID()).append(" AND ABS(LevelNo)<1");
                no = DB.executeUpdate(updateReportLine.toString(), this.get_TrxName());
                if (no != 1) {
                    this.log.log(Level.SEVERE, "(+) #=" + no + " for " + reportLine + " - " + updateReportLine.toString());
                    continue;
                }
                this.log.fine("(+) Line=" + reportLine.getSeqNo() + " - " + reportLine);
                this.log.finest("(+) " + updateReportLine.toString());
                continue;
            }
            updateReportLine = new StringBuffer("UPDATE T_Report SET (");
            for (col2 = 0; col2 < this.reportColumns.length; ++col2) {
                if (col2 > 0) {
                    updateReportLine.append(",");
                }
                updateReportLine.append("Col_").append(col2);
            }
            updateReportLine.append(") = (SELECT ");
            for (col2 = 0; col2 < this.reportColumns.length; ++col2) {
                if (col2 > 0) {
                    updateReportLine.append(",");
                }
                updateReportLine.append("COALESCE(r2.Col_").append(col2).append(",0)");
            }
            updateReportLine.append(" FROM T_Report r2 WHERE r2.AD_PInstance_ID=").append(this.getAD_PInstance_ID()).append(" AND r2.PA_ReportLine_ID=").append(operation_1).append(" AND r2.Record_ID=0 AND r2.Fact_Acct_ID=0) WHERE AD_PInstance_ID=").append(this.getAD_PInstance_ID()).append(" AND PA_ReportLine_ID=").append(reportLine.getPA_ReportLine_ID()).append(" AND ABS(LevelNo)<1");
            no = DB.executeUpdate(updateReportLine.toString(), this.get_TrxName());
            if (no != 1) {
                this.log.info("(x) #=" + no + " for " + reportLine + " - " + updateReportLine.toString());
                continue;
            }
            updateReportLine = new StringBuffer("UPDATE T_Report r1 SET (");
            StringBuffer updateFixPorcentage = new StringBuffer(" UPDATE T_Report SET ");
            Boolean fixPercentage = false;
            for (col = 0; col < this.reportColumns.length; ++col) {
                if (col > 0) {
                    updateReportLine.append(",");
                }
                updateReportLine.append("Col_").append(col);
            }
            updateReportLine.append(") = (SELECT ");
            for (col = 0; col < this.reportColumns.length; ++col) {
                if (col > 0) {
                    updateReportLine.append(",");
                }
                updateReportLine.append("COALESCE(r1.Col_").append(col).append(",0)");
                if (reportLine.isCalculationTypeSubtract()) {
                    updateReportLine.append("-");
                    updateReportLine.append("COALESCE(r2.Col_").append(col).append(",0)");
                } else {
                    updateReportLine.append("/");
                    updateReportLine.append("DECODE (r2.Col_").append(col).append(", 0, NULL, r2.Col_").append(col).append(")");
                }
                if (!reportLine.isCalculationTypePercent()) continue;
                updateReportLine.append(" *100");
                Float fixedPercentage = this.getFixedPercentage(this.get_TrxName(), this.getAD_PInstance_ID(), reportLine.getPA_ReportLine_ID(), "Col_" + col);
                if (fixedPercentage.floatValue() > 0.0f) {
                    fixPercentage = true;
                }
                if (col > 0) {
                    updateFixPorcentage.append(",");
                }
                updateFixPorcentage.append("Col_" + col + " = " + fixedPercentage);
            }
            updateReportLine.append(" FROM T_Report r2 WHERE r2.AD_PInstance_ID=").append(this.getAD_PInstance_ID()).append(" AND r2.PA_ReportLine_ID=").append(operation_2).append(" AND r2.Record_ID=0 AND r2.Fact_Acct_ID=0) WHERE AD_PInstance_ID=").append(this.getAD_PInstance_ID()).append(" AND PA_ReportLine_ID=").append(reportLine.getPA_ReportLine_ID()).append(" AND ABS(LevelNo)<1");
            updateFixPorcentage.append(" WHERE AD_PInstance_ID = " + this.getAD_PInstance_ID()).append(" AND PA_ReportLine_ID= " + reportLine.getPA_ReportLine_ID()).append(" AND ABS(LevelNo) < 1   ");
            if (fixPercentage.booleanValue()) {
                try {
                    no = DB.executeUpdate(updateFixPorcentage.toString(), this.get_TrxName());
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, updateFixPorcentage.toString(), e);
                }
                if (no != 1) {
                    this.log.severe("(x) #=" + no + " for " + reportLine + " - " + updateReportLine.toString());
                    continue;
                }
                this.log.fine("(x) Line=" + reportLine.getSeqNo() + " - " + reportLine);
                this.log.finest(updateReportLine.toString());
                continue;
            }
            no = DB.executeUpdate(updateReportLine.toString(), this.get_TrxName());
            if (no != 1) {
                this.log.severe("(x) #=" + no + " for " + reportLine + " - " + updateReportLine.toString());
                continue;
            }
            this.log.fine("(x) Line=" + reportLine.getSeqNo() + " - " + reportLine);
            this.log.finest(updateReportLine.toString());
        }
        for (int col = 0; col < this.reportColumns.length; ++col) {
            if (!this.reportColumns[col].isColumnTypeCalculation()) continue;
            StringBuffer updateCalculationColumn = new StringBuffer("UPDATE T_Report SET ");
            updateCalculationColumn.append("Col_").append(col).append("=");
            int firstOperator_1 = this.getColumnIndex(this.reportColumns[col].getOper_1_ID());
            if (firstOperator_1 < 0) {
                this.log.log(Level.SEVERE, "Column Index for Operator 1 not found - " + this.reportColumns[col]);
                continue;
            }
            int secondOperator_2 = this.getColumnIndex(this.reportColumns[col].getOper_2_ID());
            if (secondOperator_2 < 0) {
                this.log.log(Level.SEVERE, "Column Index for Operator 2 not found - " + this.reportColumns[col]);
                continue;
            }
            this.log.fine("Column " + col + " = #" + firstOperator_1 + " " + this.reportColumns[col].getCalculationType() + " #" + secondOperator_2);
            if (firstOperator_1 > secondOperator_2 && this.reportColumns[col].isCalculationTypeRange()) {
                this.log.fine("Swap operands from " + firstOperator_1 + " op " + secondOperator_2);
                int temp = firstOperator_1;
                firstOperator_1 = secondOperator_2;
                secondOperator_2 = temp;
            }
            if (this.reportColumns[col].isCalculationTypeAdd()) {
                updateCalculationColumn.append("COALESCE(Col_").append(firstOperator_1).append(",0)").append("+").append("COALESCE(Col_").append(secondOperator_2).append(",0)");
            } else if (this.reportColumns[col].isCalculationTypeSubtract()) {
                updateCalculationColumn.append("COALESCE(Col_").append(firstOperator_1).append(",0)").append("-").append("COALESCE(Col_").append(secondOperator_2).append(",0)");
            }
            if (this.reportColumns[col].isCalculationTypePercent()) {
                updateCalculationColumn.append("CASE WHEN COALESCE(Col_").append(secondOperator_2).append(",0)=0 THEN NULL ELSE ").append("COALESCE(Col_").append(firstOperator_1).append(",0)").append("/").append("Col_").append(secondOperator_2).append("*100 END");
            } else if (this.reportColumns[col].isCalculationTypeRange()) {
                updateCalculationColumn.append("COALESCE(Col_").append(firstOperator_1).append(",0)");
                for (int ii = firstOperator_1 + 1; ii <= secondOperator_2; ++ii) {
                    updateCalculationColumn.append("+COALESCE(Col_").append(ii).append(",0)");
                }
            }
            updateCalculationColumn.append(" WHERE AD_PInstance_ID=").append(this.getAD_PInstance_ID()).append(" AND ABS(LevelNo)<2");
            int no = DB.executeUpdate(updateCalculationColumn.toString(), this.get_TrxName());
            if (no < 1) {
                this.log.severe("#=" + no + " for " + this.reportColumns[col] + " - " + updateCalculationColumn.toString());
                continue;
            }
            this.log.fine("Col=" + col + " - " + this.reportColumns[col]);
            this.log.finest(updateCalculationColumn.toString());
        }
        boolean hasOpposites = false;
        StringBuffer updateReportLineForOppsiteSing = new StringBuffer("UPDATE T_Report SET ");
        for (int col = 0; col < this.reportColumns.length; ++col) {
            if (!this.reportColumns[col].isAllowOppositeSign()) continue;
            if (hasOpposites) {
                updateReportLineForOppsiteSing.append(", ");
            } else {
                hasOpposites = true;
            }
            updateReportLineForOppsiteSing.append("Col_").append(col).append("=");
            updateReportLineForOppsiteSing.append("(CASE WHEN (SELECT IsShowOppositeSign FROM PA_ReportLine l WHERE l.PA_ReportLine_ID=T_Report.PA_ReportLine_ID) = 'Y' THEN -1 ELSE 1 END) * Col_").append(col);
        }
        if (hasOpposites) {
            updateReportLineForOppsiteSing.append(" WHERE AD_PInstance_ID=").append(this.getAD_PInstance_ID()).append(" AND ABS(LevelNo)<2");
            int no = DB.executeUpdate(updateReportLineForOppsiteSing.toString(), this.get_TrxName());
            if (no < 1) {
                this.log.severe("#=" + no + " for setting opposite sign - " + updateReportLineForOppsiteSing.toString());
            } else {
                this.log.fine("Set opposite sign: " + no);
                this.log.finest(updateReportLineForOppsiteSing.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Float getFixedPercentage(String trxName, Integer processInstanceId, Integer reportLineId, String columnName) {
        Float percentage;
        Float col;
        ResultSet rs;
        CPreparedStatement pstmt;
        block5: {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT FixedPercentage, " + columnName + " FROM T_Report WHERE AD_PInstance_ID= " + processInstanceId + " ");
            sql.append("AND PA_ReportLine_ID= " + reportLineId + " ");
            pstmt = null;
            rs = null;
            Float percent = new Float(0.0f);
            col = new Float(0.0f);
            percentage = new Float(0.0f);
            try {
                pstmt = DB.prepareStatement(sql.toString(), trxName);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block5;
                percent = Float.valueOf(rs.getFloat("FixedPercentage"));
                col = Float.valueOf(rs.getFloat(columnName));
                percentage = Float.valueOf(percent.floatValue() / 100.0f);
            }
            catch (Exception e) {
                try {
                    this.log.log(Level.SEVERE, sql.toString(), e);
                }
                catch (Throwable throwable) {
                    DB.close(pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(pstmt);
                rs = null;
                pstmt = null;
            }
        }
        DB.close(pstmt);
        rs = null;
        pstmt = null;
        if (col.floatValue() > 0.0f) {
            BigDecimal bd = new BigDecimal(Float.toString(col.floatValue() * percentage.floatValue()));
            bd = bd.setScale(2, 4);
            return Float.valueOf(bd.floatValue());
        }
        return new Float(0.0f);
    }

    private String getLineIds(int fromId, int toId) {
        this.log.finest("From=" + fromId + " To=" + toId);
        int firstReportLineId = 0;
        int lastReportLineId = 0;
        for (int line = 0; line < this.reportLines.length; ++line) {
            int reportLineId = this.reportLines[line].getPA_ReportLine_ID();
            if (reportLineId != fromId && reportLineId != toId) continue;
            if (firstReportLineId == 0) {
                firstReportLineId = reportLineId;
                continue;
            }
            lastReportLineId = reportLineId;
            break;
        }
        StringBuffer reportLineIdsList = new StringBuffer();
        reportLineIdsList.append(firstReportLineId);
        boolean addToList = false;
        for (int line = 0; line < this.reportLines.length; ++line) {
            int reportLineId = this.reportLines[line].getPA_ReportLine_ID();
            this.log.finest("Add=" + addToList + " ID=" + reportLineId + " - " + this.reportLines[line]);
            if (addToList) {
                reportLineIdsList.append(",").append(reportLineId);
                if (reportLineId != lastReportLineId) continue;
                break;
            }
            if (reportLineId != firstReportLineId) continue;
            addToList = true;
        }
        return reportLineIdsList.toString();
    }

    private int getColumnIndex(int reportColumnId) {
        for (int i2 = 0; i2 < this.reportColumns.length; ++i2) {
            if (this.reportColumns[i2].getPA_ReportColumn_ID() != reportColumnId) continue;
            return i2;
        }
        return -1;
    }

    private FinReportPeriod getPeriod(BigDecimal relativeOffset) {
        if (relativeOffset == null) {
            return this.getPeriod(0);
        }
        return this.getPeriod(relativeOffset.intValue());
    }

    private FinReportPeriod getPeriod(int relativeOffset) {
        if (this.reportPeriod < 0) {
            for (int i2 = 0; i2 < this.finReportPeriods.length; ++i2) {
                if (this.getPeriodId() != this.finReportPeriods[i2].getC_Period_ID()) continue;
                this.reportPeriod = i2;
                break;
            }
        }
        if (this.reportPeriod < 0 || this.reportPeriod >= this.finReportPeriods.length) {
            throw new UnsupportedOperationException("Period index not found - ReportPeriod=" + this.reportPeriod + ", C_Period_ID=" + this.getPeriodId());
        }
        int index = this.reportPeriod + relativeOffset;
        if (index < 0) {
            this.log.log(Level.SEVERE, "Relative Offset(" + relativeOffset + ") not valid for selected Period(" + this.reportPeriod + ")");
            index = 0;
        } else if (index >= this.finReportPeriods.length) {
            this.log.log(Level.SEVERE, "Relative Offset(" + relativeOffset + ") not valid for selected Period(" + this.reportPeriod + ")");
            index = this.finReportPeriods.length - 1;
        }
        return this.finReportPeriods[index];
    }

    private void insertLineDetail() {
        this.log.info("");
        StringBuilder deleteReportLines = new StringBuilder("DELETE FROM T_Report WHERE ABS(LevelNo) <> 0").append(" AND Col_0 IS NULL AND Col_1 IS NULL AND Col_2 IS NULL AND Col_3 IS NULL AND Col_4 IS NULL AND Col_5 IS NULL AND Col_6 IS NULL AND Col_7 IS NULL AND Col_8 IS NULL AND Col_9 IS NULL").append(" AND Col_10 IS NULL AND Col_11 IS NULL AND Col_12 IS NULL AND Col_13 IS NULL AND Col_14 IS NULL AND Col_15 IS NULL AND Col_16 IS NULL AND Col_17 IS NULL AND Col_18 IS NULL AND Col_19 IS NULL AND Col_20 IS NULL");
        int no = DB.executeUpdate(deleteReportLines.toString(), this.get_TrxName());
        this.log.fine("Deleted empty #=" + no);
        for (MReportLine reportLine : this.reportLines) {
            if (!reportLine.isLineTypeSegmentValue()) continue;
            this.insertLineSource(reportLine);
        }
        StringBuilder updateReportLineSeqNo = new StringBuilder("UPDATE T_Report r1 SET SeqNo = (SELECT SeqNo FROM T_Report r2 WHERE r1.AD_PInstance_ID=r2.AD_PInstance_ID AND r1.PA_ReportLine_ID=r2.PA_ReportLine_ID AND r2.Record_ID=0 AND r2.Fact_Acct_ID=0)WHERE SeqNo IS NULL");
        no = DB.executeUpdate(updateReportLineSeqNo.toString(), this.get_TrxName());
        this.log.fine("SeqNo #=" + no);
        String selectForNameAndDesc = "SELECT e.Name, fa.Description FROM Fact_Acct fa INNER JOIN AD_Table t ON (fa.AD_Table_ID=t.AD_Table_ID) INNER JOIN AD_Element e ON (t.TableName||'_ID'=e.ColumnName) WHERE r.Fact_Acct_ID=fa.Fact_Acct_ID";
        updateReportLineSeqNo = new StringBuilder("UPDATE T_Report r SET (Name,Description)=(").append(selectForNameAndDesc).append(") WHERE Fact_Acct_ID <> 0 AND AD_PInstance_ID=").append(this.getAD_PInstance_ID());
        no = DB.executeUpdate(updateReportLineSeqNo.toString(), this.get_TrxName());
        if (CLogMgt.isLevelFinest()) {
            this.log.fine("Trx Name #=" + no + " - " + updateReportLineSeqNo.toString());
        }
    }

    private void insertLineSource(MReportLine reportLine) {
        if (reportLine == null || reportLine.getSources().length == 0) {
            return;
        }
        this.log.info("Line=" + reportLine.getSeqNo() + " - " + reportLine);
        String variable = reportLine.getSourceColumnName();
        if (variable == null) {
            return;
        }
        this.log.fine("Variable=" + variable);
        for (MReportSource source : reportLine.getSources()) {
            if (!Util.isEmpty(this.getListSources()) && this.getListSources().equals("N") || Util.isEmpty(this.getListSources()) && (!Util.isEmpty(this.finReport.getListSources()) && this.finReport.getListSources().equals("N") || Util.isEmpty(this.finReport.getListSources()) && !source.isListSources())) continue;
            boolean isCombination = source.getElementType().equals("CO");
            StringBuffer insertLineSource = new StringBuffer("INSERT INTO T_Report (AD_PInstance_ID, PA_ReportLine_ID, Record_ID,Fact_Acct_ID,LevelNo ");
            if (isCombination) {
                insertLineSource.append(", C_ValidCombination_ID ");
            }
            for (int col = 0; col < this.reportColumns.length; ++col) {
                insertLineSource.append(",Col_").append(col);
            }
            insertLineSource.append(") SELECT ").append(this.getAD_PInstance_ID()).append(",").append(reportLine.getPA_ReportLine_ID()).append(",");
            if (isCombination) {
                insertLineSource.append("Account_ID");
            } else {
                insertLineSource.append(variable);
            }
            insertLineSource.append(",0,");
            if (this.isDetailsSourceFirst()) {
                insertLineSource.append("-1 ");
            } else {
                insertLineSource.append("1 ");
            }
            int combinationId = 0;
            if (isCombination) {
                combinationId = MAccount.get(this.getCtx(), this.getAD_Client_ID(), source.getAD_Org_ID(), Env.getContextAsInt(this.getCtx(), "$C_AcctSchema_ID"), source.getC_ElementValue_ID(), 0, source.getM_Product_ID(), source.getC_BPartner_ID(), source.getAD_OrgTrx_ID(), source.getC_Location_ID(), 0, source.getC_SalesRegion_ID(), source.getC_Project_ID(), source.getC_Campaign_ID(), source.getC_Activity_ID(), source.getUser1_ID(), source.getUser2_ID(), source.getUser3_ID(), source.getUser4_ID(), source.getUserElement1_ID(), source.getUserElement2_ID(), this.get_TrxName()).getC_ValidCombination_ID();
                insertLineSource.append("," + combinationId + " ");
            }
            StringBuffer whereReportLine = new StringBuffer("");
            if (isCombination) {
                whereReportLine.append(source.getWhereClause(this.getHierarchyId()));
                whereReportLine.append(this.getWherePostingType(true));
            } else {
                whereReportLine.append(reportLine.getWhereClause(this.getHierarchyId(), this.getWherePostingType(false)));
            }
            String whereReport = this.finReport.getWhereClause();
            if (whereReport != null && whereReport.length() > 0) {
                if (whereReportLine.length() > 0) {
                    whereReportLine.append(" AND ");
                }
                whereReportLine.append(whereReport);
            }
            if (whereReportLine.length() > 0 && !isCombination) {
                whereReportLine.append(" AND ");
            }
            if (!isCombination) {
                whereReportLine.append(variable).append(" IS NOT NULL");
            }
            StringBuilder whereLink = new StringBuilder();
            if (isCombination) {
                whereLink.append(reportLine.getSelectClauseCombination());
            } else {
                whereLink.append(" AND fb.").append(variable).append("=x.").append(variable);
            }
            insertLineSource.append(",").append(this.getColumnStatement(INSERT, reportLine, whereReportLine + this.getWhereClause() + whereLink, false));
            if (this.getReportCubeId() > 0) {
                insertLineSource.append(" FROM Fact_Acct_Summary x WHERE ").append(whereReportLine + this.getWhereClause());
            } else {
                insertLineSource.append(" FROM Fact_Acct x WHERE ").append(whereReportLine + this.getWhereClause());
            }
            insertLineSource.append(" GROUP BY ");
            if (isCombination) {
                List<String> colNames = reportLine.getCombinationGroupByColumns();
                StringBuffer groupBy = new StringBuffer("");
                for (int j = 0; j < colNames.size(); ++j) {
                    groupBy.append(", " + colNames.get(j));
                }
                insertLineSource.append(groupBy.toString().replaceFirst(", ", ""));
            } else {
                insertLineSource.append(variable);
            }
            int no = DB.executeUpdate(insertLineSource.toString(), this.get_TrxName());
            if (CLogMgt.isLevelFinest()) {
                this.log.fine("Source #=" + no + " - " + insertLineSource);
            }
            if (no == 0) {
                return;
            }
            StringBuffer updateNameAndDesc = new StringBuffer("UPDATE T_Report SET (Name,Description)=(").append(reportLine.getSourceValueQuery());
            if (isCombination) {
                updateNameAndDesc.append(combinationId);
            } else {
                updateNameAndDesc.append("T_Report.Record_ID");
            }
            updateNameAndDesc.append(") WHERE Record_ID <> 0 AND AD_PInstance_ID=").append(this.getAD_PInstance_ID()).append(" AND PA_ReportLine_ID=").append(reportLine.getPA_ReportLine_ID()).append(" AND Fact_Acct_ID=0");
            if (isCombination) {
                updateNameAndDesc.append(" AND C_ValidCombination_ID=" + combinationId);
            }
            no = DB.executeUpdate(updateNameAndDesc.toString(), this.get_TrxName());
            if (CLogMgt.isLevelFinest()) {
                this.log.fine("Name #=" + no + " - " + updateNameAndDesc.toString());
            }
            if (!Util.isEmpty(this.getListTrx()) && this.getListTrx().equals("Y")) {
                this.insertLineTrx(reportLine, variable, combinationId, whereReportLine + this.getWhereClauseForTrx());
            } else if (Util.isEmpty(this.getListTrx()) && !Util.isEmpty(this.finReport.getListTrx()) && this.finReport.getListTrx().equals("Y")) {
                this.insertLineTrx(reportLine, variable, combinationId, whereReportLine + this.getWhereClauseForTrx());
            } else if (Util.isEmpty(this.getListTrx()) && Util.isEmpty(this.finReport.getListTrx()) && source.isListTrx()) {
                this.insertLineTrx(reportLine, variable, combinationId, whereReportLine + this.getWhereClauseForTrx());
            }
            if (!isCombination) break;
        }
    }

    private void insertLineTrx(MReportLine reportLine, String variable, int combinationId, String whereReportLine) {
        boolean isCombination;
        this.log.info("Line=" + reportLine.getSeqNo() + " - Variable=" + variable);
        StringBuffer insertLineTrx = new StringBuffer("INSERT INTO T_Report (AD_PInstance_ID, PA_ReportLine_ID, Record_ID,Fact_Acct_ID,LevelNo ");
        boolean bl = isCombination = combinationId > 0 && whereReportLine != null;
        if (isCombination) {
            insertLineTrx.append(",C_ValidCombination_ID ");
        }
        for (int col = 0; col < this.reportColumns.length; ++col) {
            insertLineTrx.append(",Col_").append(col);
        }
        insertLineTrx.append(") SELECT ").append(this.getAD_PInstance_ID()).append(",").append(reportLine.getPA_ReportLine_ID()).append(",");
        if (isCombination) {
            insertLineTrx.append(combinationId);
        } else {
            insertLineTrx.append(variable);
        }
        insertLineTrx.append(",Fact_Acct_ID, ");
        if (this.isDetailsSourceFirst()) {
            insertLineTrx.append("-2 ");
        } else {
            insertLineTrx.append("2 ");
        }
        if (isCombination) {
            insertLineTrx.append("," + variable + " ");
        }
        StringBuilder whereLink = new StringBuilder();
        if (isCombination) {
            whereLink.append(reportLine.getSelectClauseCombination());
        } else {
            whereLink.append(" AND fb.").append(variable).append("=x.").append(variable);
        }
        StringBuilder whereLineTrx = new StringBuilder(" AND fb.Fact_Acct_ID=x.Fact_Acct_ID ");
        insertLineTrx.append(",").append(this.getColumnStatement(INSERT, reportLine, whereReportLine + whereLink + whereLineTrx, true));
        insertLineTrx.append(" FROM Fact_Acct x WHERE ");
        insertLineTrx.append(whereReportLine);
        int no = DB.executeUpdate(insertLineTrx.toString(), this.get_TrxName());
        this.log.finest("Trx #=" + no + " - " + insertLineTrx);
        if (no == 0) {
            return;
        }
    }

    private String getColumnStatement(String action, MReportLine reportLine, String whereClause, boolean isTrx) {
        StringBuffer sqlStatement = new StringBuffer();
        for (int col = 0; col < this.reportColumns.length; ++col) {
            StringBuffer whereColumn = new StringBuffer("");
            StringBuffer info = new StringBuffer();
            if (this.reportColumns[col].isColumnTypeCalculation() || reportLine.getPAAmountType() == null && this.reportColumns[col].getPAAmountType() == null) {
                if (INSERT.equals(action)) {
                    sqlStatement.append(",NULL");
                }
                this.log.warning("No Amount Type in line: " + reportLine + " or column: " + this.reportColumns[col]);
                continue;
            }
            info.append("Line=").append(reportLine.getSeqNo()).append(",Col=").append(col);
            StringBuffer select = new StringBuffer("SELECT ");
            if (reportLine.getPAAmountType() != null) {
                select.append(reportLine.getSelectClause(true));
                info.append(": LineAmtType=").append(reportLine.getPAAmountType());
            } else if (this.reportColumns[col].getPAAmountType() != null) {
                select.append(this.reportColumns[col].getSelectClause(true));
                info.append(": ColumnAmtType=").append(this.reportColumns[col].getPAAmountType());
            }
            if (this.getReportCubeId() > 0 && !isTrx) {
                select.append(" FROM Fact_Acct_Summary fb ");
            } else {
                select.append(" FROM Fact_Acct fb ");
            }
            whereColumn.append(" WHERE TRUNC(DateAcct) ");
            BigDecimal relativeOffset = null;
            BigDecimal relativeOffsetTo = null;
            if (this.reportColumns[col].isColumnTypeRelativePeriod()) {
                relativeOffset = this.reportColumns[col].getRelativePeriod();
                relativeOffsetTo = (BigDecimal)this.reportColumns[col].get_Value("RelativePeriodTo");
            }
            FinReportPeriod finReportPeriod = this.getPeriod(relativeOffset);
            if (reportLine.getPAPeriodType() != null) {
                info.append(" - LineDateAcct=");
                if (reportLine.isPeriod()) {
                    info.append("Period");
                    whereColumn.append(finReportPeriod.getPeriodWhere());
                } else if (reportLine.isYear()) {
                    info.append("Year");
                    whereColumn.append(finReportPeriod.getYearWhere());
                } else if (reportLine.isTotal()) {
                    info.append("Total");
                    whereColumn.append(finReportPeriod.getTotalWhere());
                } else if (reportLine.isNatural()) {
                    info.append("Natural");
                    whereColumn.append(finReportPeriod.getNaturalWhere("fb"));
                } else {
                    this.log.log(Level.SEVERE, "No valid Line PAPeriodType");
                    whereColumn.append("=0");
                }
            } else if (this.reportColumns[col].getPAPeriodType() != null) {
                info.append(" - ColumnDateAcct=");
                FinReportPeriod finReportPeriodTo = null;
                if (relativeOffsetTo != null) {
                    finReportPeriodTo = this.getPeriod(relativeOffsetTo);
                }
                if (this.reportColumns[col].isPeriod()) {
                    if (finReportPeriodTo != null) {
                        whereColumn.append("BETWEEN " + DB.TO_DATE(finReportPeriod.getStartDate()) + " AND " + DB.TO_DATE(finReportPeriodTo.getEndDate()));
                    } else {
                        whereColumn.append(finReportPeriod.getPeriodWhere());
                    }
                    info.append("Period");
                } else if (this.reportColumns[col].isYear()) {
                    if (finReportPeriodTo != null) {
                        whereColumn.append("BETWEEN " + DB.TO_DATE(finReportPeriod.getYearStartDate()) + " AND " + DB.TO_DATE(finReportPeriodTo.getEndDate()));
                    } else {
                        whereColumn.append(finReportPeriod.getYearWhere());
                    }
                    info.append("Year");
                } else if (this.reportColumns[col].isTotal()) {
                    if (finReportPeriodTo != null) {
                        whereColumn.append("<= " + DB.TO_DATE(finReportPeriodTo.getEndDate()));
                    } else {
                        whereColumn.append(finReportPeriod.getTotalWhere());
                    }
                    info.append("Total");
                } else if (this.reportColumns[col].isNatural()) {
                    if (finReportPeriodTo != null) {
                        String yearWhere = "BETWEEN " + DB.TO_DATE(finReportPeriod.getYearStartDate()) + " AND " + DB.TO_DATE(finReportPeriodTo.getEndDate());
                        String totalWhere = "<= " + DB.TO_DATE(finReportPeriodTo.getEndDate());
                        String bs = " EXISTS (SELECT C_ElementValue_ID FROM C_ElementValue WHERE C_ElementValue_ID = fb.Account_ID AND AccountType NOT IN ('R', 'E'))";
                        String full = totalWhere + " AND ( " + bs + " OR TRUNC(fb.DateAcct) " + yearWhere + " ) ";
                        whereColumn.append(full);
                    } else {
                        whereColumn.append(finReportPeriod.getNaturalWhere("fb"));
                    }
                } else {
                    this.log.log(Level.SEVERE, "No valid Column PAPeriodType");
                    whereColumn.append("=0");
                }
            }
            String postingTypeWhereClause = this.getWherePostingType(true);
            if (Util.isEmpty(postingTypeWhereClause)) {
                String postingType = reportLine.getPostingType();
                int budgetId = reportLine.getGL_Budget_ID();
                if (Util.isEmpty(postingType)) {
                    postingType = this.reportColumns[col].getPostingType();
                    budgetId = this.reportColumns[col].getGL_Budget_ID();
                }
                if (!Util.isEmpty(postingType)) {
                    postingTypeWhereClause = " AND PostingType='" + postingType + "' ";
                    if (postingType.equals("B") && budgetId > 0) {
                        postingTypeWhereClause = postingTypeWhereClause + " AND GL_Budget_ID = " + budgetId;
                    }
                }
                if (!Util.isEmpty(postingTypeWhereClause)) {
                    whereColumn.append(postingTypeWhereClause);
                }
            } else {
                whereColumn.append(postingTypeWhereClause);
            }
            if (this.reportColumns[col].isColumnTypeSegmentValue() || this.reportColumns[col].isWithSources()) {
                whereColumn.append(this.reportColumns[col].getWhereClause(this.getHierarchyId()));
            }
            if (whereClause != null && whereClause.length() > 0) {
                whereColumn.append(" AND ").append(whereClause);
            }
            if (sqlStatement.length() > 0) {
                sqlStatement.append(", ");
            }
            if (UPDATE.equals(action)) {
                sqlStatement.append("Col_").append(col).append(" =  ");
            }
            sqlStatement.append("(").append(select).append(whereColumn).append(")");
            this.log.finest(info.toString());
        }
        return sqlStatement.toString();
    }

    private void deleteUnprintedLines() {
        String deleteNotPrintLines = "DELETE FROM T_Report WHERE AD_PInstance_ID = " + this.getAD_PInstance_ID() + " AND EXISTS(SELECT 1 \t\t\t\t\tFROM PA_ReportLine rl\t\t\t\t\tWHERE rl.PA_ReportLine_ID = T_Report.PA_ReportLine_ID\t\t\t\t\tAND rl.PA_ReportLineSet_ID = ?\t\t\t\t\tAND rl.IsPrinted = 'N')";
        int no = DB.executeUpdate(deleteNotPrintLines, this.finReport.getPA_ReportLineSet_ID(), true, this.get_TrxName());
        if (no > 0) {
            this.log.fine("Lines deleted - #" + no);
        }
    }

    private void scaleResults() {
        for (int column = 0; column < this.reportColumns.length; ++column) {
            String factor = this.reportColumns[column].getFactor();
            if (factor == null) continue;
            int divisor = 1;
            if (factor.equals("k")) {
                divisor = 1000;
            } else {
                if (!factor.equals("M")) break;
                divisor = 1000000;
            }
            String updateScaleResult = "UPDATE T_Report SET Col_" + column + "=Col_" + column + "/" + divisor + " WHERE AD_PInstance_ID=" + this.getAD_PInstance_ID();
            int no = DB.executeUpdate(updateScaleResult, this.get_TrxName());
            if (no <= 0) continue;
            this.log.fine(this.reportColumns[column].getName() + " - #" + no);
        }
    }

    private MPrintFormat getPrintFormat() {
        boolean createNew;
        int printFormatId = this.finReport.getAD_PrintFormat_ID();
        this.log.info("AD_PrintFormat_ID=" + printFormatId);
        MPrintFormat printFormat = null;
        boolean bl = createNew = printFormatId == 0;
        if (createNew) {
            int AD_Table_ID = 544;
            printFormat = MPrintFormat.createFromTable(Env.getCtx(), AD_Table_ID);
            printFormatId = printFormat.getAD_PrintFormat_ID();
            this.finReport.setAD_PrintFormat_ID(printFormatId);
            this.finReport.saveEx();
        } else {
            printFormat = MPrintFormat.get(this.getCtx(), printFormatId, false);
        }
        if (!this.finReport.getName().equals(printFormat.getName())) {
            printFormat.setName(this.finReport.getName());
        }
        if (this.finReport.getDescription() == null) {
            if (printFormat.getDescription() != null) {
                printFormat.setDescription(null);
            }
        } else if (!this.finReport.getDescription().equals(printFormat.getDescription())) {
            printFormat.setDescription(this.finReport.getDescription());
        }
        printFormat.saveEx();
        this.log.fine(printFormat + " - #" + printFormat.getItemCount());
        int count = printFormat.getItemCount();
        for (int i2 = 0; i2 < count; ++i2) {
            MPrintFormatItem printFormatItem = printFormat.getItem(i2);
            String ColumnName = printFormatItem.getColumnName();
            if (ColumnName == null) {
                this.log.log(Level.SEVERE, "No ColumnName for #" + i2 + " - " + printFormatItem);
                if (printFormatItem.isPrinted()) {
                    printFormatItem.setIsPrinted(false);
                }
                if (printFormatItem.isOrderBy()) {
                    printFormatItem.setIsOrderBy(false);
                }
                if (printFormatItem.getSortNo() != 0) {
                    printFormatItem.setSortNo(0);
                }
            } else if (ColumnName.startsWith("Col")) {
                int index = Integer.parseInt(ColumnName.substring(4));
                if (index < this.reportColumns.length) {
                    printFormatItem.setIsPrinted(this.reportColumns[index].isPrinted());
                    String s = this.reportColumns[index].getName();
                    if (this.reportColumns[index].isColumnTypeRelativePeriod()) {
                        BigDecimal relativeOffset = this.reportColumns[index].getRelativePeriod();
                        BigDecimal relativeOffsetTo = (BigDecimal)this.reportColumns[index].get_Value("RelativePeriodTo");
                        FinReportPeriod finReportPeriod = this.getPeriod(relativeOffset);
                        if (s.contains("@Period@")) {
                            if (relativeOffsetTo != null) {
                                FinReportPeriod finReportPeriodTo = this.getPeriod(relativeOffsetTo);
                                s = s.replace("@Period@", finReportPeriod.getName() + " - " + finReportPeriodTo.getName());
                            } else {
                                s = s.replace("@Period@", finReportPeriod.getName());
                            }
                        }
                    }
                    if (!printFormatItem.getName().equals(s)) {
                        printFormatItem.setName(s);
                        printFormatItem.setPrintName(s);
                    }
                    int seq = 30 + index;
                    if (printFormatItem.getSeqNo() != seq) {
                        printFormatItem.setSeqNo(seq);
                    }
                    s = this.reportColumns[index].getFormatPattern();
                    printFormatItem.setFormatPattern(s);
                    printFormatItem.setFieldAlignmentType("T");
                } else if (printFormatItem.isPrinted()) {
                    printFormatItem.setIsPrinted(false);
                }
                if (printFormatItem.isOrderBy()) {
                    printFormatItem.setIsOrderBy(false);
                }
                if (printFormatItem.getSortNo() != 0) {
                    printFormatItem.setSortNo(0);
                }
            } else if (ColumnName.equals("SeqNo")) {
                if (printFormatItem.isPrinted()) {
                    printFormatItem.setIsPrinted(false);
                }
                if (!printFormatItem.isOrderBy()) {
                    printFormatItem.setIsOrderBy(true);
                }
                if (printFormatItem.getSortNo() != 10) {
                    printFormatItem.setSortNo(10);
                }
            } else if (ColumnName.equals("LevelNo")) {
                if (printFormatItem.isPrinted()) {
                    printFormatItem.setIsPrinted(false);
                }
                if (!printFormatItem.isOrderBy()) {
                    printFormatItem.setIsOrderBy(true);
                }
                if (printFormatItem.getSortNo() != 20) {
                    printFormatItem.setSortNo(20);
                }
            } else if (ColumnName.equals("Name")) {
                if (printFormatItem.getSeqNo() != 10) {
                    printFormatItem.setSeqNo(10);
                }
                if (!printFormatItem.isPrinted()) {
                    printFormatItem.setIsPrinted(true);
                }
                if (!printFormatItem.isOrderBy()) {
                    printFormatItem.setIsOrderBy(true);
                }
                if (printFormatItem.getSortNo() != 30) {
                    printFormatItem.setSortNo(30);
                }
            } else if (ColumnName.equals("Description")) {
                if (printFormatItem.getSeqNo() != 20) {
                    printFormatItem.setSeqNo(20);
                }
                if (!printFormatItem.isPrinted()) {
                    printFormatItem.setIsPrinted(true);
                }
                if (printFormatItem.isOrderBy()) {
                    printFormatItem.setIsOrderBy(false);
                }
                if (printFormatItem.getSortNo() != 0) {
                    printFormatItem.setSortNo(0);
                }
            } else {
                if (printFormatItem.isPrinted()) {
                    printFormatItem.setIsPrinted(false);
                }
                if (printFormatItem.isOrderBy()) {
                    printFormatItem.setIsOrderBy(false);
                }
                if (printFormatItem.getSortNo() != 0) {
                    printFormatItem.setSortNo(0);
                }
            }
            printFormatItem.saveEx();
            this.log.fine(printFormatItem.toString());
        }
        printFormat.setTranslation();
        if (this.finReport.getAD_PrintFormatHeader_ID() <= 0) {
            return printFormat;
        }
        printFormat = MPrintFormat.get(this.getCtx(), printFormatId, true);
        MPrintFormat printFormatHeader = MPrintFormat.get(this.getCtx(), this.finReport.getAD_PrintFormatHeader_ID(), true);
        int orgID = this.getOrgId() != 0 ? this.getOrgId() : Env.getAD_Org_ID(Env.getCtx());
        X_AD_OrgInfo orgInfo = null;
        if (orgID != 0) {
            orgInfo = MOrgInfo.get(Env.getCtx(), orgID, null);
        }
        MLocation loc = null;
        if (orgInfo.getC_Location_ID() != 0) {
            loc = new MLocation(this.getCtx(), orgInfo.getC_Location_ID(), this.get_TrxName());
        }
        for (int j = 0; j < printFormatHeader.getItemCount(); ++j) {
            MPrintFormatItem printFormatItem = printFormatHeader.getItem(j);
            String name = printFormatItem.getName();
            if (!name.startsWith("page") || name.startsWith("@")) {
                printFormatItem.setPrintName(null);
            }
            if (name.contains("@Name@")) {
                this.adjustPrintFormatItem(printFormatItem);
                name = name.replaceFirst("@Name@", this.finReport.getName());
                printFormatItem.setPrintName(name);
            }
            if (name.contains("@Client@")) {
                this.adjustPrintFormatItem(printFormatItem);
                MClient client = new MClient(this.getCtx(), Env.getAD_Client_ID(this.getCtx()), this.get_TrxName());
                name = name.replaceFirst("@Client@", client.getName());
                printFormatItem.setPrintName(name);
            }
            if (name.equalsIgnoreCase("Report")) {
                this.adjustPrintFormatItem(printFormatItem);
                printFormatItem.setAD_PrintFormatChild_ID(printFormat.get_ID());
            }
            if (name.contains("@Organization@")) {
                if (this.getOrgId() != 0) {
                    this.adjustPrintFormatItem(printFormatItem);
                    MOrg org = new MOrg(this.getCtx(), this.getOrgId(), this.get_TrxName());
                    name = name.replaceFirst("@Organization@", org.getName());
                    printFormatItem.setPrintName(name);
                } else {
                    printFormatItem.setIsPrinted(false);
                }
            }
            if (name.contains("@Currency@")) {
                this.adjustPrintFormatItem(printFormatItem);
                name = name.replaceFirst("@Currency@", this.finReport.getC_AcctSchema().getC_Currency().getDescription());
                printFormatItem.setPrintName(name);
            }
            if (name.contains("@Period@")) {
                if (this.getPeriodId() != 0) {
                    this.adjustPrintFormatItem(printFormatItem);
                    MPeriod period = MPeriod.get(this.getCtx(), this.getPeriodId());
                    name = name.replaceFirst("@Period@", period.getName());
                    printFormatItem.setPrintName(name);
                } else {
                    printFormatItem.setIsPrinted(false);
                }
            }
            if (name.contains("@Business Partner@")) {
                if (this.getOrgId() != 0) {
                    this.adjustPrintFormatItem(printFormatItem);
                    MBPartner bpartner = MBPartner.get(this.getCtx(), this.getBPartnerId());
                    name = name.replaceFirst("@Business Partner@", bpartner.getName());
                    printFormatItem.setPrintName(name);
                } else {
                    printFormatItem.setIsPrinted(false);
                }
            }
            if (name.equalsIgnoreCase("@Logo@")) {
                MClientInfo ci;
                this.adjustPrintFormatItem(printFormatItem);
                MImage image = null;
                if (orgInfo != null && orgInfo.getLogo_ID() > 0) {
                    image = MImage.get(Env.getCtx(), orgInfo.getLogo_ID());
                }
                if (image == null && (ci = MClientInfo.get(this.getCtx(), Env.getAD_Client_ID(this.getCtx()))).getLogoReport_ID() > 0) {
                    image = MImage.get(Env.getCtx(), ci.getLogoReport_ID());
                }
                if (image != null) {
                    byte[] imageData = image.getData();
                    MAttachment attachment = printFormatItem.createAttachment();
                    attachment.setBinaryData(imageData);
                    if (attachment.getEntryCount() > 0) {
                        attachment.updateEntry(0, imageData);
                    } else {
                        attachment.addEntry(image.getName(), imageData);
                    }
                    attachment.saveEx();
                    CacheMgt.get().reset("ImageElement");
                }
            }
            if (orgInfo != null) {
                orgInfo = MOrgInfo.get(Env.getCtx(), orgID, null);
                if (name.contains("@City@") && orgInfo.getC_Location_ID() != 0) {
                    this.adjustPrintFormatItem(printFormatItem);
                    name = name.replaceFirst("@City@", loc.getCity());
                    printFormatItem.setPrintName(name);
                }
                if (name.contains("@TaxID@") && orgInfo.getTaxID() != null) {
                    this.adjustPrintFormatItem(printFormatItem);
                    name = name.replaceFirst("@TaxID@", orgInfo.getTaxID());
                    printFormatItem.setPrintName(name);
                }
                if (name.contains("@DUNS@") && orgInfo.getDUNS() != null) {
                    this.adjustPrintFormatItem(printFormatItem);
                    name = name.replaceFirst("@DUNS@", orgInfo.getDUNS());
                    printFormatItem.setPrintName(name);
                }
                if (name.contains("@Address1@") && orgInfo.getC_Location_ID() != 0 && loc.getAddress1() != null) {
                    this.adjustPrintFormatItem(printFormatItem);
                    name = name.replaceFirst("@Address1@", loc.getAddress1());
                    printFormatItem.setPrintName(name);
                }
                if (name.contains("@Address2@") && orgInfo.getC_Location_ID() != 0 && loc.getAddress2() != null) {
                    this.adjustPrintFormatItem(printFormatItem);
                    name = name.replaceFirst("@Address2@", loc.getAddress2());
                    printFormatItem.setPrintName(name);
                }
                if (name.contains("@Address3@") && orgInfo.getC_Location_ID() != 0 && loc.getAddress3() != null) {
                    this.adjustPrintFormatItem(printFormatItem);
                    name = name.replaceFirst("@Address3@", loc.getAddress3());
                    printFormatItem.setPrintName(name);
                }
                if (name.contains("@Address4@") && orgInfo.getC_Location_ID() != 0 && loc.getAddress4() != null) {
                    this.adjustPrintFormatItem(printFormatItem);
                    name = name.replaceFirst("@Address4@", loc.getAddress4());
                    printFormatItem.setPrintName(name);
                }
            }
            printFormatItem.saveEx();
            if (name.equalsIgnoreCase("Report") || name.equalsIgnoreCase("Logo") || printFormatItem.getPrintName() != null) continue;
            printFormatItem.setIsPrinted(false);
        }
        return printFormatHeader;
    }

    private void adjustPrintFormatItem(MPrintFormatItem printFormatItem) {
        if (!printFormatItem.isPrinted()) {
            printFormatItem.setIsPrinted(true);
        }
        if (printFormatItem.isOrderBy()) {
            printFormatItem.setIsOrderBy(false);
        }
        if (printFormatItem.getSortNo() != 0) {
            printFormatItem.setSortNo(0);
        }
    }
}

