/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.report;

import java.sql.Timestamp;
import java.util.GregorianCalendar;
import org.compiere.model.MElementValue;
import org.compiere.model.MPeriod;
import org.compiere.report.FinStatementAbstract;
import org.compiere.report.MReportTree;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;

public class FinStatement
extends FinStatementAbstract {
    private StringBuffer parameterWhere = new StringBuffer();
    private MElementValue m_acct = null;
    private long m_start = System.currentTimeMillis();

    @Override
    protected String doIt() {
        this.setWhereClause();
        this.createBalanceLine();
        this.createDetailLines();
        this.log.fine(System.currentTimeMillis() - this.m_start + " ms");
        return "";
    }

    private void setWhereClause() {
        this.parameterWhere.append("C_AcctSchema_ID=").append(this.getAcctSchemaId()).append(" AND PostingType='").append(this.getPostingType()).append("'");
        if (this.getAccountId() > 0) {
            this.parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.getHierarchyId(), "AC", this.getAccountId()));
        }
        if (this.getOrgId() != 0) {
            this.parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.getHierarchyId(), "OO", this.getOrgId()));
        }
        if (this.getBPartnerId() != 0) {
            this.parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.getHierarchyId(), "BP", this.getBPartnerId()));
        }
        if (this.getProductId() != 0) {
            this.parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.getHierarchyId(), "PR", this.getProductId()));
        }
        if (this.getProjectId() != 0) {
            this.parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.getHierarchyId(), "PJ", this.getProjectId()));
        }
        if (this.getActivityId() != 0) {
            this.parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.getHierarchyId(), "AY", this.getActivityId()));
        }
        if (this.getCampaignId() != 0) {
            this.parameterWhere.append(" AND C_Campaign_ID=").append(this.getCampaignId());
        }
        if (this.getSalesRegionId() != 0) {
            this.parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.getHierarchyId(), "SR", this.getSalesRegionId()));
        }
        if (this.getUser1Id() != 0) {
            this.parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.getHierarchyId(), "U1", this.getUser1Id()));
        }
        if (this.getUser2Id() != 0) {
            this.parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.getHierarchyId(), "U2", this.getUser2Id()));
        }
        if (this.getAccountType() != null) {
            this.parameterWhere.append(" AND AccountType='").append(this.getAccountType()).append("'");
        }
        this.setDateAcct();
        StringBuffer sb = new StringBuffer();
        sb.append(" - DateAcct ").append(this.getDateAcct()).append("-").append(this.getDateAcctTo());
        sb.append(" - Where=").append(this.parameterWhere);
        this.log.fine(sb.toString());
    }

    private void setDateAcct() {
        if (this.getDateAcct() != null) {
            if (this.getDateAcctTo() == null) {
                this.setDateAcctTo(new Timestamp(System.currentTimeMillis()));
            }
            return;
        }
        if (this.getPeriodId() == 0) {
            GregorianCalendar cal = new GregorianCalendar(Language.getLoginLanguage().getLocale());
            cal.setTimeInMillis(System.currentTimeMillis());
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            cal.set(5, 1);
            this.setDateAcct(new Timestamp(cal.getTimeInMillis()));
            cal.add(2, 1);
            cal.add(6, -1);
            this.setDateAcctTo(new Timestamp(cal.getTimeInMillis()));
            return;
        }
        MPeriod period = new MPeriod(this.getCtx(), this.getPeriodId(), this.get_TrxName());
        this.setDateAcct(period.getStartDate());
        this.setDateAcctTo(period.getEndDate());
    }

    private void createBalanceLine() {
        StringBuilder where = new StringBuilder();
        where.append(" WHERE Account_ID = ev.C_ElementValue_ID AND ").append(this.parameterWhere).append(" AND TRUNC(DateAcct, 'DD') < ").append(DB.TO_DATE(this.getDateAcct()));
        StringBuffer sb = new StringBuffer("INSERT INTO T_ReportStatement (AD_PInstance_ID, Fact_Acct_ID, LevelNo,DateAcct, Name, Description,AmtAcctDr, AmtAcctCr, Balance, Qty, ACCOUNT_ID, accountvalue, accountName, accountType) ");
        sb.append("SELECT ").append(this.getAD_PInstance_ID()).append(",0,0,").append(DB.TO_DATE(this.getDateAcct(), true)).append(",").append(DB.TO_STRING(Msg.getMsg(Env.getCtx(), "BeginningBalance"))).append(",NULL,").append("COALESCE((SELECT SUM(AcctBalance(Account_ID, AmtAcctDr , 0         )) FROM Fact_Acct ").append((CharSequence)where).append(" ),0), ").append("COALESCE((SELECT SUM(AcctBalance(Account_ID, 0         , AmtAcctCr )) FROM Fact_Acct ").append((CharSequence)where).append(" ),0), ").append("COALESCE((SELECT SUM(AcctBalance(Account_ID, AmtAcctDr , 0 ) - AcctBalance(Account_ID, 0 , AmtAcctCr )) FROM Fact_Acct ").append((CharSequence)where).append(" ),0), ").append("COALESCE((SELECT SUM(AcctBalance(Account_ID, Qty       , 0         )) FROM Fact_Acct ").append((CharSequence)where).append(" ),0), ").append("ev.C_ElementValue_ID , ev.value, ev.name, ev.accounttype ").append(" FROM C_ElementValue ev INNER JOIN C_Element e ON (ev.C_Element_ID=e.C_Element_ID) WHERE e.ElementType = 'A' ");
        if (this.getAccountId() > 0) {
            sb.append(" AND  ev.C_ElementValue_ID = ").append(this.getAccountId());
        }
        if (this.getAccountType() != null && !this.getAccountType().isEmpty()) {
            sb.append(" AND  ev.AccountType = '").append(this.getAccountType()).append("'");
        }
        int no = DB.executeUpdate(sb.toString(), this.get_TrxName());
        this.log.fine("#" + no + " (Account_ID=" + this.getAccountId() + ")");
        this.log.finest(sb.toString());
    }

    private void createDetailLines() {
        StringBuffer sb = new StringBuffer("INSERT INTO T_ReportStatement (AD_PInstance_ID, Fact_Acct_ID, LevelNo,DateAcct, Name, Description,AmtAcctDr, AmtAcctCr, Balance, Qty, ACCOUNT_ID , accountvalue, accountName, accounttype ) ");
        sb.append("SELECT ").append(this.getAD_PInstance_ID()).append(",fact_Acct.Fact_Acct_ID,1,").append("TRUNC(fact_Acct.DateAcct, 'DD'),NULL,NULL,AmtAcctDr, AmtAcctCr, AmtAcctDr-AmtAcctCr, Qty, fact_Acct.ACCOUNT_ID, ev.value, ev.name, accounttype FROM Fact_Acct  INNER JOIN C_Elementvalue ev on fact_Acct.account_ID = ev.c_ElementValue_ID WHERE ").append(this.parameterWhere).append(" AND TRUNC(DateAcct, 'DD') BETWEEN ").append(DB.TO_DATE(this.getDateAcct())).append(" AND ").append(DB.TO_DATE(this.getDateAcctTo()));
        int no = DB.executeUpdate(sb.toString(), this.get_TrxName());
        this.log.fine("#" + no);
        this.log.finest(sb.toString());
        Language currentLanguage = Env.getLanguage(this.getCtx());
        Boolean isBaseLanguage = currentLanguage.isBaseLanguage();
        String selectFields = " e.Name, fa.Description ";
        if (!isBaseLanguage.booleanValue()) {
            selectFields = "etrl.Name, fa.Description ";
        }
        StringBuffer sql_select = new StringBuffer("SELECT ");
        sql_select.append(selectFields).append("FROM Fact_Acct fa").append(" INNER JOIN AD_Table t ON (fa.AD_Table_ID=t.AD_Table_ID)").append(" INNER JOIN AD_Element e ON (t.TableName||'_ID'=e.ColumnName) ");
        if (!isBaseLanguage.booleanValue()) {
            sql_select.append(" INNER JOIN AD_element_trl etrl ON (e.ad_element_ID=etrl.ad_element_ID AND AD_Language = '" + currentLanguage.getAD_Language() + "')");
        }
        sql_select.append(" WHERE r.Fact_Acct_ID=fa.Fact_Acct_ID");
        StringBuffer updateSql = new StringBuffer("UPDATE T_ReportStatement r SET (Name,Description)=(").append(sql_select).append(") WHERE Fact_Acct_ID <> 0 AND AD_PInstance_ID=").append(this.getAD_PInstance_ID());
        no = DB.executeUpdate(updateSql.toString(), this.get_TrxName());
        this.log.fine("Name #" + no);
        this.log.finest("Name - " + sb);
    }
}

