/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.report;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.X_PA_ReportLineSet;
import org.compiere.report.MReportLine;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class MReportLineSet
extends X_PA_ReportLineSet {
    private static final long serialVersionUID = -2540937629148624046L;
    private MReportLine[] m_lines = null;

    public MReportLineSet(Properties ctx, int PA_ReportLineSet_ID, String trxName) {
        super(ctx, PA_ReportLineSet_ID, trxName);
        if (PA_ReportLineSet_ID != 0) {
            this.loadLines();
        }
    }

    public MReportLineSet(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLines() {
        ArrayList<MReportLine> list = new ArrayList<MReportLine>();
        String sql = "SELECT * FROM PA_ReportLine WHERE PA_ReportLineSet_ID=? AND IsActive='Y' ORDER BY SeqNo";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getPA_ReportLineSet_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MReportLine(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {}
            pstmt = null;
        }
        this.m_lines = new MReportLine[list.size()];
        list.toArray(this.m_lines);
        this.log.finest("ID=" + this.getPA_ReportLineSet_ID() + " - Size=" + list.size());
    }

    public MReportLine[] getLines() {
        return this.m_lines;
    }

    public void list() {
        System.out.println(this.toString());
        if (this.m_lines == null) {
            return;
        }
        for (int i2 = 0; i2 < this.m_lines.length; ++i2) {
            this.m_lines[i2].list();
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MReportLineSet[").append(this.get_ID()).append(" - ").append(this.getName()).append("]");
        return sb.toString();
    }
}

