/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.compiere.swing.CTable;
import org.jdesktop.swingx.VerticalLayout;
import org.jdesktop.swingx.action.AbstractActionExt;
import org.jdesktop.swingx.action.ActionContainerFactory;
import org.jdesktop.swingx.table.ColumnControlPopup;

public class CColumnControlButton
extends JButton {
    private static final long serialVersionUID = 3052540263336100861L;
    public static final String COLUMN_CONTROL_MARKER = "column.";
    protected ColumnControlPopup popup;
    private CTable table;
    private PropertyChangeListener tablePropertyChangeListener;
    TableColumnModelListener columnModelListener;
    private List<ColumnVisibilityAction> columnVisibilityActions;

    public CColumnControlButton(CTable table2, Icon icon) {
        this.init();
        this.setAction(this.createControlAction(icon));
        this.installTable(table2);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setMargin(new Insets(1, 2, 2, 1));
        this.getColumnControlPopup().updateUI();
    }

    public void togglePopup() {
        this.getColumnControlPopup().toggleVisibility((JComponent)this);
    }

    @Override
    public void applyComponentOrientation(ComponentOrientation o) {
        super.applyComponentOrientation(o);
        this.getColumnControlPopup().applyComponentOrientation(o);
    }

    protected ColumnControlPopup getColumnControlPopup() {
        if (this.popup == null) {
            this.popup = this.createColumnControlPopup();
        }
        return this.popup;
    }

    protected ColumnControlPopup createColumnControlPopup() {
        return new DefaultColumnControlPopup();
    }

    protected void updateFromColumnModelChange(TableColumnModel oldModel) {
        if (oldModel != null && this.columnModelListener != null) {
            oldModel.removeColumnModelListener(this.columnModelListener);
        }
        this.populatePopup();
        this.table.getColumnModel().addColumnModelListener(this.getColumnModelListener());
    }

    protected void updateFromTableEnabledChanged() {
        this.getAction().setEnabled(this.table.isEnabled());
    }

    protected void populatePopup() {
        this.clearAll();
        this.createVisibilityActions();
        this.addVisibilityActionItems();
        this.addAdditionalActionItems();
    }

    protected void clearAll() {
        this.clearColumnVisibilityActions();
        this.getColumnControlPopup().removeAll();
    }

    protected void clearColumnVisibilityActions() {
        if (this.columnVisibilityActions == null) {
            return;
        }
        for (ColumnVisibilityAction action : this.columnVisibilityActions) {
            action.releaseColumn();
        }
        this.columnVisibilityActions.clear();
    }

    protected void addVisibilityActionItems() {
        this.getColumnControlPopup().addVisibilityActionItems(Collections.unmodifiableList(this.getColumnVisibilityActions()));
    }

    protected void addAdditionalActionItems() {
        this.getColumnControlPopup().addAdditionalActionItems(Collections.unmodifiableList(this.getAdditionalActions()));
    }

    protected void createVisibilityActions() {
        Enumeration<TableColumn> columns = this.table.getColumnModel().getColumns();
        while (columns.hasMoreElements()) {
            ColumnVisibilityAction action;
            TableColumn column = columns.nextElement();
            if (column.getHeaderValue() == null || (action = this.createColumnVisibilityAction(column)) == null) continue;
            this.getColumnVisibilityActions().add(action);
        }
    }

    protected ColumnVisibilityAction createColumnVisibilityAction(TableColumn column) {
        return new ColumnVisibilityAction(column);
    }

    protected List<ColumnVisibilityAction> getColumnVisibilityActions() {
        if (this.columnVisibilityActions == null) {
            this.columnVisibilityActions = new ArrayList<ColumnVisibilityAction>();
        }
        return this.columnVisibilityActions;
    }

    protected List<Action> getAdditionalActions() {
        List actionKeys = this.getColumnControlActionKeys();
        ArrayList<Action> actions = new ArrayList<Action>();
        for (Object key : actionKeys) {
            actions.add(this.table.getActionMap().get(key));
        }
        return actions;
    }

    protected List getColumnControlActionKeys() {
        Object[] allKeys = this.table.getActionMap().allKeys();
        ArrayList<Object> columnKeys = new ArrayList<Object>();
        for (int i2 = 0; i2 < allKeys.length; ++i2) {
            if (!this.isColumnControlActionKey(allKeys[i2])) continue;
            columnKeys.add(allKeys[i2]);
        }
        Collections.sort(columnKeys);
        return columnKeys;
    }

    protected boolean isColumnControlActionKey(Object actionKey) {
        return actionKey instanceof String && ((String)actionKey).startsWith(COLUMN_CONTROL_MARKER);
    }

    private void installTable(CTable table2) {
        this.table = table2;
        table2.addPropertyChangeListener(this.getTablePropertyChangeListener());
        this.updateFromColumnModelChange(null);
        this.updateFromTableEnabledChanged();
    }

    private void init() {
        this.setFocusPainted(false);
        this.setFocusable(false);
        JComboBox box = new JComboBox();
        Object preventHide = box.getClientProperty("doNotCancelPopup");
        this.putClientProperty("doNotCancelPopup", preventHide);
    }

    private Action createControlAction(Icon icon) {
        AbstractAction control = new AbstractAction(){
            private static final long serialVersionUID = -6683797828219296451L;

            @Override
            public void actionPerformed(ActionEvent e) {
                CColumnControlButton.this.togglePopup();
            }
        };
        control.putValue("SmallIcon", icon);
        return control;
    }

    protected PropertyChangeListener getTablePropertyChangeListener() {
        if (this.tablePropertyChangeListener == null) {
            this.tablePropertyChangeListener = this.createTablePropertyChangeListener();
        }
        return this.tablePropertyChangeListener;
    }

    protected PropertyChangeListener createTablePropertyChangeListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("columnModel".equals(evt.getPropertyName())) {
                    CColumnControlButton.this.updateFromColumnModelChange((TableColumnModel)evt.getOldValue());
                } else if ("enabled".equals(evt.getPropertyName())) {
                    CColumnControlButton.this.updateFromTableEnabledChanged();
                }
            }
        };
    }

    protected TableColumnModelListener getColumnModelListener() {
        if (this.columnModelListener == null) {
            this.columnModelListener = this.createColumnModelListener();
        }
        return this.columnModelListener;
    }

    protected TableColumnModelListener createColumnModelListener() {
        return new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
                CColumnControlButton.this.populatePopup();
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
                CColumnControlButton.this.populatePopup();
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        };
    }

    public class DefaultColumnControlPopup
    implements ColumnControlPopup {
        private JPopupMenu popupMenu;
        private JScrollPane scroller;
        private JPanel panelMenus;

        public void updateUI() {
            SwingUtilities.updateComponentTreeUI(this.getPopupMenu());
        }

        private JPanel getPanelMenu() {
            if (this.panelMenus == null) {
                this.panelMenus = new JPanel();
                this.panelMenus.setLayout((LayoutManager)new VerticalLayout());
                this.panelMenus.setBackground(UIManager.getColor("MenuItem.background"));
                this.panelMenus.setBorder(BorderFactory.createEmptyBorder());
            }
            return this.panelMenus;
        }

        private JScrollPane getScroller() {
            if (this.scroller == null) {
                this.scroller = this.createScroller();
                this.scroller.getVerticalScrollBar().setFocusable(false);
                this.scroller.setViewportView(this.getPanelMenu());
            }
            return this.scroller;
        }

        public void toggleVisibility(JComponent owner) {
            JPopupMenu popupMenu = this.getPopupMenu();
            JPanel panel = this.getPanelMenu();
            if (popupMenu.isVisible()) {
                popupMenu.setVisible(false);
            } else if (panel.getComponentCount() > 0) {
                JScrollPane scroller = this.getScroller();
                panel.validate();
                Dimension pSize = CColumnControlButton.this.table.getParent().getSize();
                Dimension size = panel.getPreferredSize();
                if (size.height >= pSize.height) {
                    scroller.setPreferredSize(new Dimension(size.width, pSize.height - 30));
                } else {
                    scroller.setPreferredSize(size);
                }
                popupMenu.setPopupSize(new Dimension(scroller.getPreferredSize().width + 20, scroller.getPreferredSize().height - 20));
                Dimension buttonSize = owner.getSize();
                int xPos = owner.getComponentOrientation().isLeftToRight() ? buttonSize.width - popupMenu.getPreferredSize().width : 0;
                popupMenu.show(owner, xPos, buttonSize.height);
            }
        }

        public void applyComponentOrientation(ComponentOrientation o) {
            this.getPopupMenu().applyComponentOrientation(o);
        }

        public void removeAll() {
            this.getPanelMenu().removeAll();
        }

        public void addVisibilityActionItems(List<? extends AbstractActionExt> actions) {
            this.addItems(new ArrayList<AbstractActionExt>(actions));
        }

        public void addAdditionalActionItems(List<? extends Action> actions) {
            if (actions.size() == 0) {
                return;
            }
            this.addSeparator();
            this.addItems(actions);
        }

        protected void addItems(List<? extends Action> actions) {
            ActionContainerFactory factory = new ActionContainerFactory(null);
            for (Action action : actions) {
                AbstractActionExt a2 = (AbstractActionExt)action;
                if (!action.isEnabled()) continue;
                if (a2.isStateAction()) {
                    this.addItem(this.createCheckBox((AbstractActionExt)action));
                    continue;
                }
                this.addItem(factory.createButton(action));
            }
        }

        private JCheckBox createCheckBox(AbstractActionExt action) {
            JCheckBox c = new JCheckBox((Action)action);
            c.setSelected(action.isSelected());
            c.addItemListener((ItemListener)action);
            return c;
        }

        protected void addSeparator() {
            this.getPanelMenu().add(Box.createVerticalStrut(2));
            this.getPanelMenu().add(new JSeparator());
            this.getPanelMenu().add(Box.createVerticalStrut(2));
        }

        protected void addItem(AbstractButton item) {
            this.getPanelMenu().add(item);
        }

        protected JPopupMenu getPopupMenu() {
            if (this.popupMenu == null) {
                this.popupMenu = new JPopupMenu();
                this.popupMenu.removeAll();
                this.popupMenu.setLayout(new BorderLayout());
                this.popupMenu.add((Component)this.getScroller(), "Center");
            }
            return this.popupMenu;
        }

        protected JScrollPane createScroller() {
            JScrollPane sp = new JScrollPane(null, 20, 31);
            sp.setHorizontalScrollBar(null);
            sp.setBorder(BorderFactory.createEmptyBorder());
            return sp;
        }
    }

    public class ColumnVisibilityAction
    extends AbstractActionExt {
        private static final long serialVersionUID = -5843080042335689992L;
        private TableColumn column;
        private PropertyChangeListener columnListener;
        private boolean fromColumn;

        public ColumnVisibilityAction(TableColumn column) {
            super((String)null);
            this.setStateAction();
            this.installColumn(column);
        }

        public void releaseColumn() {
            this.column.removePropertyChangeListener(this.columnListener);
            this.column = null;
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 2 && CColumnControlButton.this.table.getColumnCount() <= 1 && !this.fromColumn) {
                this.reselect();
            } else {
                this.setSelected(e.getStateChange() == 1);
            }
        }

        public synchronized void setSelected(boolean newValue) {
            super.setSelected(newValue);
            if (!newValue) {
                if (CColumnControlButton.this.table.isColumnVisible(this.column)) {
                    CColumnControlButton.this.table.setColumnVisibility(this.column, newValue);
                }
            } else if (!CColumnControlButton.this.table.isColumnVisible(this.column)) {
                CColumnControlButton.this.table.setColumnVisibility(this.column, newValue);
            }
        }

        public void actionPerformed(ActionEvent e) {
        }

        private void updateFromColumnVisible(boolean visible) {
            this.fromColumn = true;
            this.setSelected(visible);
            this.fromColumn = false;
        }

        private void updateFromColumnHeader(Object value) {
            if (value == null) {
                this.setEnabled(false);
            } else {
                this.setName(String.valueOf(value));
                this.setEnabled(true);
            }
        }

        private void reselect() {
            this.firePropertyChange("selected", null, Boolean.TRUE);
        }

        private void installColumn(TableColumn column) {
            this.column = column;
            column.addPropertyChangeListener(this.getColumnListener());
            this.updateFromColumnHeader(column.getHeaderValue());
            if (column.getIdentifier() != null) {
                this.setActionCommand(column.getIdentifier().toString());
            }
            boolean visible = CColumnControlButton.this.table.isColumnVisible(column);
            this.updateFromColumnVisible(visible);
        }

        protected PropertyChangeListener getColumnListener() {
            if (this.columnListener == null) {
                this.columnListener = this.createPropertyChangeListener();
            }
            return this.columnListener;
        }

        protected PropertyChangeListener createPropertyChangeListener() {
            return new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("visible".equals(evt.getPropertyName())) {
                        ColumnVisibilityAction.this.updateFromColumnVisible((Boolean)evt.getNewValue());
                    } else if ("headerValue".equals(evt.getPropertyName())) {
                        ColumnVisibilityAction.this.updateFromColumnHeader(evt.getNewValue());
                        if (evt.getNewValue() == null) {
                            CColumnControlButton.this.populatePopup();
                        }
                    }
                }
            };
        }
    }
}

