/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.swing;

import java.awt.Color;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.plaf.ComboBoxUI;
import org.adempiere.exceptions.ValueChangeListener;
import org.adempiere.plaf.AdempiereComboBoxUI;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.model.GridField;
import org.compiere.plaf.CompiereComboBoxUI;
import org.compiere.swing.CEditor;
import org.compiere.util.NamePair;
import org.compiere.util.Trace;

public class CComboBoxEditable
extends JComboBox
implements CEditor {
    private static final long serialVersionUID = -3036970630981224309L;
    public static int FIELD_HIGHT = 0;
    private Icon m_icon = null;
    private boolean m_mandatory = false;

    public CComboBoxEditable(ComboBoxModel aModel) {
        super(aModel);
        this.init();
    }

    public CComboBoxEditable(Object[] items) {
        super(items);
        this.init();
    }

    public CComboBoxEditable(Object[] items, String key) {
        this(items);
        if (key == null) {
            return;
        }
        for (int i2 = 0; i2 < 0; ++i2) {
            Object item = items[i2];
            if (item == null) continue;
            boolean found = false;
            found = item instanceof NamePair ? ((NamePair)item).getID().equals(key) : item.toString().equals(key);
            if (!found) continue;
            this.setSelectedIndex(i2);
            break;
        }
    }

    public CComboBoxEditable(Vector items) {
        super(items);
        this.init();
    }

    public CComboBoxEditable() {
        this.init();
    }

    private void init() {
        FIELD_HIGHT = this.getPreferredSize().height;
    }

    public void setIcon(Icon defaultIcon) {
        if (this.getUI() instanceof CompiereComboBoxUI) {
            ((CompiereComboBoxUI)this.getUI()).setIcon(defaultIcon);
        }
        this.m_icon = defaultIcon;
    }

    @Override
    public void setUI(ComboBoxUI ui) {
        super.setUI(ui);
        if (this.m_icon != null && ui instanceof CompiereComboBoxUI) {
            ((CompiereComboBoxUI)this.getUI()).setIcon(this.m_icon);
        }
    }

    public boolean displayPopup() {
        return true;
    }

    @Override
    public void setMandatory(boolean mandatory) {
        this.m_mandatory = mandatory;
        this.setBackground(false);
    }

    @Override
    public boolean isMandatory() {
        return this.m_mandatory;
    }

    @Override
    public void setReadWrite(boolean rw) {
        if (super.isEnabled() != rw) {
            super.setEnabled(rw);
        }
        this.setBackground(false);
    }

    @Override
    public boolean isReadWrite() {
        return super.isEnabled();
    }

    @Override
    public void setBackground(boolean error) {
        if (error) {
            this.setBackground(AdempierePLAF.getFieldBackground_Error());
        } else if (!this.isReadWrite()) {
            this.setBackground(AdempierePLAF.getFieldBackground_Inactive());
        } else if (this.m_mandatory) {
            this.setBackground(AdempierePLAF.getFieldBackground_Mandatory());
        } else {
            this.setBackground(AdempierePLAF.getFieldBackground_Normal());
        }
    }

    @Override
    public void setBackground(Color bg) {
        if (bg.equals(this.getBackground())) {
            return;
        }
        if (this.getEditor() != null && this.getEditor().getEditorComponent() != null) {
            this.getEditor().getEditorComponent().setBackground(bg);
        }
        super.setBackground(bg);
    }

    @Override
    public void setValue(Object value) {
        super.setSelectedItem(value);
    }

    @Override
    public Object getValue() {
        return super.getSelectedItem();
    }

    @Override
    public String getDisplay() {
        Object o = super.getSelectedItem();
        if (o == null) {
            return "";
        }
        return o.toString();
    }

    @Override
    public void addMouseListener(MouseListener ml) {
        JButton b2;
        super.addMouseListener(ml);
        if (this.getUI() instanceof CompiereComboBoxUI && !Trace.getCallerClass(1).startsWith("javax") && (b2 = ((CompiereComboBoxUI)this.getUI()).getArrowButton()) != null) {
            b2.addMouseListener(ml);
        }
        if (this.getUI() instanceof AdempiereComboBoxUI && !Trace.getCallerClass(1).startsWith("javax") && (b2 = ((AdempiereComboBoxUI)((Object)this.getUI())).getArrowButton()) != null) {
            b2.addMouseListener(ml);
        }
    }

    @Override
    public void removeMouseListener(MouseListener ml) {
        JButton b2;
        super.removeMouseListener(ml);
        if (this.getUI() instanceof CompiereComboBoxUI && (b2 = ((CompiereComboBoxUI)this.getUI()).getArrowButton()) != null) {
            b2.removeMouseListener(ml);
        }
    }

    @Override
    public void setActionCommand(String actionCommand) {
        super.setActionCommand(actionCommand);
        if (this.getName() == null && actionCommand != null && actionCommand.length() > 0) {
            this.setName(actionCommand);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    @Override
    public void addValueChangeListener(ValueChangeListener listener) {
    }

    @Override
    public GridField getField() {
        return null;
    }
}

