/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.compiere.util.AmtInWords;

public class AmtInWords_HR
implements AmtInWords {
    private static final String I = "";
    private static final String RAZMAK = " ";
    private static final BigDecimal googol = BigDecimal.valueOf(10L).pow(100);
    private static final BigDecimal dvadeset = BigDecimal.valueOf(20L);
    private static final Map<Integer, String> brojevi = new HashMap<Integer, String>(39);
    private static final Map<Integer, String> potencije = new HashMap<Integer, String>(27);
    private static final String[][] nominativi = new String[][]{{"da", "a", "a", "e", "i"}, {"a", "u", "a", "e", "a"}, {"n", "n", "n", "na", "na"}};

    public static String slovimaUValuti(BigDecimal broj) {
        StringBuilder rezultat = new StringBuilder();
        broj = broj.setScale(2, 6);
        BigDecimal kune = broj.setScale(0, 1);
        rezultat.append((CharSequence)AmtInWords_HR.slovima(kune, "kuna", false, false));
        rezultat.append(" i ");
        BigDecimal lipe = broj.movePointRight(2).remainder(BigDecimal.valueOf(100L));
        rezultat.append((CharSequence)AmtInWords_HR.slovima(lipe, "lipa", false, false));
        return rezultat.toString();
    }

    public static StringBuilder slovima(BigDecimal broj) {
        return AmtInWords_HR.slovima(broj, null);
    }

    public static StringBuilder slovima(BigDecimal broj, String jedinica) {
        return AmtInWords_HR.slovima(broj, jedinica, false, false);
    }

    private static StringBuilder slovima(BigDecimal broj, String jedinica, boolean jediniceBezBroja, boolean rekurzija) {
        StringBuilder rezultat = new StringBuilder();
        if (broj.compareTo(BigDecimal.valueOf(0L)) == -1) {
            rezultat.append("minus ");
            broj = broj.multiply(BigDecimal.valueOf(-1L));
        }
        if (googol.compareTo(broj) < 1) {
            if (googol.compareTo(broj) == 0) {
                rezultat.append(potencije.get(100));
                return rezultat;
            }
            throw new IllegalArgumentException("nepoznat broj - nije izme\u0111u-googol i googol (-10^100 i 10^100)");
        }
        int potencija = AmtInWords_HR.potencija(broj);
        if (broj.compareTo(BigDecimal.valueOf(1L)) == 0) {
            if (!jediniceBezBroja && rekurzija) {
                rezultat.append(I.length() > 1 ? I.substring(1) : I);
            }
            rezultat.append(AmtInWords_HR.dekliniraj(1, jedinica, jediniceBezBroja));
        } else if (broj.compareTo(dvadeset) < 1) {
            if (!jediniceBezBroja && rekurzija && broj.compareTo(BigDecimal.valueOf(10L)) == -1) {
                rezultat.append(I.length() > 1 ? I.substring(1) : I);
            }
            rezultat.append(AmtInWords_HR.dekliniraj(broj.intValue(), jedinica, false));
        } else if (potencija < 2) {
            int ostatak = broj.remainder(BigDecimal.valueOf(1L).movePointRight(potencija)).intValue();
            rezultat.append(brojevi.get(broj.subtract(BigDecimal.valueOf(ostatak)).intValue()));
            if (ostatak > 0) {
                rezultat.append(I.length() > 0 ? I : RAZMAK);
                rezultat.append(AmtInWords_HR.dekliniraj(ostatak, jedinica, false));
            } else if (jedinica != null) {
                rezultat.append(RAZMAK);
                rezultat.append(jedinica);
            }
        } else if (potencija < 3) {
            BigDecimal ostatak = broj.remainder(BigDecimal.valueOf(1L).movePointRight(potencija));
            if (ostatak.compareTo(BigDecimal.valueOf(0L)) == 1) {
                rezultat.append(brojevi.get(broj.subtract(ostatak).intValue()));
                rezultat.append(RAZMAK);
                rezultat.append((CharSequence)AmtInWords_HR.slovima(ostatak, jedinica, jediniceBezBroja, true));
            } else {
                rezultat.append(AmtInWords_HR.dekliniraj(broj.subtract(ostatak).intValue(), jedinica, false));
            }
        } else {
            int punaPotencija = potencija - potencija % 3;
            BigDecimal ostatak = broj.remainder(BigDecimal.valueOf(1L).movePointRight(punaPotencija));
            rezultat.append((CharSequence)AmtInWords_HR.slovima(broj.subtract(ostatak).movePointLeft(punaPotencija), potencije.get(punaPotencija), true, true));
            if (ostatak.compareTo(BigDecimal.valueOf(0L)) == 1) {
                rezultat.append(RAZMAK);
                rezultat.append((CharSequence)AmtInWords_HR.slovima(ostatak, jedinica, jediniceBezBroja, true));
            } else if (jedinica != null) {
                rezultat.append(RAZMAK);
                rezultat.append(jedinica);
            }
        }
        return rezultat;
    }

    private static int potencija(BigDecimal broj) {
        BigDecimal deset;
        int potencija = 0;
        BigDecimal i2 = deset = BigDecimal.valueOf(10L);
        while (i2.compareTo(broj) < 1) {
            ++potencija;
            i2 = i2.multiply(deset);
        }
        return potencija;
    }

    private static String dekliniraj(int znamenka, String nominativ, boolean jedinceBezBroja) {
        if (nominativ == null) {
            return brojevi.get(znamenka);
        }
        for (int i2 = 0; i2 < nominativi.length; ++i2) {
            if (!nominativ.endsWith(nominativi[i2][0])) continue;
            String korijen = nominativ.substring(0, nominativ.length() - 1);
            String broj = null;
            if (nominativ.endsWith("a")) {
                broj = brojevi.get(znamenka * -1);
            }
            if (broj == null) {
                broj = brojevi.get(znamenka);
            }
            if (znamenka == 1) {
                if (jedinceBezBroja) {
                    return korijen + nominativi[i2][1];
                }
                return broj + RAZMAK + korijen + nominativi[i2][2];
            }
            if (znamenka > 1 && znamenka < 5) {
                return broj + RAZMAK + korijen + nominativi[i2][3];
            }
            return broj + RAZMAK + korijen + nominativi[i2][4];
        }
        throw new IllegalArgumentException("nominativ '" + nominativ + "'ne znam deklinirati!");
    }

    @Override
    public String getAmtInWords(String amount) throws Exception {
        if (amount == null) {
            return amount;
        }
        StringBuffer sb = new StringBuffer();
        amount = amount.replaceAll(",", I);
        Double iznos = Double.parseDouble(amount);
        sb.append(AmtInWords_HR.slovimaUValuti(new BigDecimal(iznos)));
        return sb.toString();
    }

    private void print(String amt) {
        try {
            System.out.println(amt + " = " + this.getAmtInWords(amt));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        AmtInWords_HR aiw = new AmtInWords_HR();
        aiw.print("263.52");
        aiw.print("0.23");
        aiw.print("1.23");
        aiw.print("12.345");
        aiw.print("123.45");
        aiw.print("1234.56");
        aiw.print("12345.78");
        aiw.print("123457.89");
        aiw.print("1,234,578.90");
    }

    static {
        brojevi.put(-1, "jedna");
        brojevi.put(-2, "dvije");
        brojevi.put(0, "nula");
        brojevi.put(1, "jedan");
        brojevi.put(2, "dva");
        brojevi.put(3, "tri");
        brojevi.put(4, "\u010detiri");
        brojevi.put(5, "pet");
        brojevi.put(6, "\u0161est");
        brojevi.put(7, "sedam");
        brojevi.put(8, "osam");
        brojevi.put(9, "devet");
        brojevi.put(10, "deset");
        brojevi.put(11, "jedanaest");
        brojevi.put(12, "dvanaest");
        brojevi.put(13, "trinaest");
        brojevi.put(14, "\u010detrnaest");
        brojevi.put(15, "petnaest");
        brojevi.put(16, "\u0161esnaest");
        brojevi.put(17, "sedamnaest");
        brojevi.put(18, "osamnaest");
        brojevi.put(19, "devetnaest");
        brojevi.put(20, "dvadeset");
        brojevi.put(30, "trideset");
        brojevi.put(40, "\u010detrdeset");
        brojevi.put(50, "pedeset");
        brojevi.put(60, "\u0161ezdeset");
        brojevi.put(70, "sedamdeset");
        brojevi.put(80, "osamdeset");
        brojevi.put(90, "devedeset");
        brojevi.put(100, "sto");
        brojevi.put(200, "dvjesto");
        brojevi.put(300, "tristo");
        brojevi.put(400, "\u010detristo");
        brojevi.put(500, "petsto");
        brojevi.put(600, "\u0161esto");
        brojevi.put(700, "sedamsto");
        brojevi.put(800, "osamsto");
        brojevi.put(900, "devetsto");
        potencije.put(3, "tisu\u0107a");
        potencije.put(6, "milijun");
        potencije.put(9, "milijarda");
        potencije.put(12, "bilijun");
        potencije.put(15, "bilijarda");
        potencije.put(18, "trilijun");
        potencije.put(21, "trilijarda");
        potencije.put(24, "kvatrilijun");
        potencije.put(27, "kvatrilijarda");
        potencije.put(30, "kvintilijun");
        potencije.put(33, "kvintilijarda");
        potencije.put(36, "sekstilijun");
        potencije.put(39, "sekstilijarda");
        potencije.put(42, "septilijun");
        potencije.put(45, "septilijarda");
        potencije.put(48, "oktilijun");
        potencije.put(51, "oktilijarda");
        potencije.put(54, "nonilijun");
        potencije.put(57, "nonilijarda");
        potencije.put(60, "decilijun");
        potencije.put(63, "decilijarda");
        potencije.put(66, "undecilijun");
        potencije.put(69, "undecilijarda");
        potencije.put(72, "duodecilijun");
        potencije.put(75, "duodecilijarda");
        potencije.put(78, "tridecilijun");
        potencije.put(81, "tridecilijarda");
        potencije.put(84, "kvatridecilijun");
        potencije.put(87, "kvatridecilijarda");
        potencije.put(90, "kvindecilijun");
        potencije.put(93, "kvindecilijarda");
        potencije.put(96, "seksdecilijun");
        potencije.put(99, "seksdecilijarda");
        potencije.put(100, "googol");
    }
}

