/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class CLogFilter
implements Filter {
    private static CLogFilter s_filter = null;

    public static synchronized CLogFilter get() {
        if (s_filter == null) {
            s_filter = new CLogFilter();
        }
        return s_filter;
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        if (record.getLevel() == Level.SEVERE || record.getLevel() == Level.WARNING) {
            return true;
        }
        String loggerName = record.getLoggerName();
        if (loggerName != null && (loggerName.startsWith("sun.") || loggerName.startsWith("java.awt.") || loggerName.startsWith("javax."))) {
            return false;
        }
        String className = record.getSourceClassName();
        return className == null || !className.startsWith("sun.") && !className.startsWith("java.awt.") && !className.startsWith("javax.");
    }
}

