/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import com.sun.mail.smtp.SMTPMessage;
import com.sun.mail.smtp.SMTPTransport;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.URLDataSource;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.adempiere.util.EMailOAuth2Provider;
import org.compiere.Adempiere;
import org.compiere.model.MClient;
import org.compiere.model.MEMailConfig;
import org.compiere.model.MSysConfig;
import org.compiere.util.ByteArrayDataSource;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.EMailAuthenticator;
import org.compiere.util.Env;
import org.compiere.util.Ini;

public final class EMail
implements Serializable {
    private static final long serialVersionUID = -1408649015285763245L;
    public static final String HTML_MAIL_MARKER = "ContentType=text/html;";
    private InternetAddress from;
    private ArrayList<InternetAddress> to;
    private ArrayList<InternetAddress> cc;
    private ArrayList<InternetAddress> bcc;
    private InternetAddress replyTo;
    private String subject;
    private String messageText;
    private String messageHTML;
    private String host;
    private int port = 0;
    private String protocol = null;
    private String encryptionType = null;
    private String authMechanism = null;
    private boolean isSmtpAuthorization = false;
    private String domain = null;
    private long timeout = 0L;
    private long connectionTimeout = 0L;
    private int eMailConfigId = 0;
    private ArrayList<Object> attachments;
    private EMailAuthenticator auth = null;
    private SMTPMessage msg = null;
    private String user = null;
    private String token = "";
    private Properties ctx;
    private boolean isManual = false;
    private boolean valid = false;
    private String sentMsg = null;
    private Store store = null;
    private Session session = null;
    private Transport transport = null;
    public static final String SENT_OK = "OK";
    protected static CLogger log = CLogger.getCLogger(EMail.class);

    public EMail(MClient client, String from, String to, String subject, String message) {
        this(client, 0, from, to, subject, message, false);
    }

    public EMail(MClient client, int eMailConfigId, String from, String to, String subject, String message, boolean html) {
        this.ctx = client.getCtx();
        this.isManual = false;
        this.setEMailParameters(eMailConfigId);
        this.configureEMail(from, to, subject, message, html);
        this.valid = this.isValid(true);
    }

    @Deprecated
    public EMail(String smtpHost, String from, String to, String subject, String message, boolean html) {
        this(smtpHost, 25, "S", "N", "L", from, to, subject, message, html);
    }

    @Deprecated
    public EMail(String smtpHost, int smtpPort, String protocol, String encryptionType, String authMechanism, String from, String to, String subject, String message, boolean html) {
        this.setSmtpHost(smtpHost);
        this.setPort(smtpPort);
        this.setProtocol(protocol);
        this.setEncryptionType(encryptionType);
        this.setAuthMechanism(authMechanism);
        this.isSmtpAuthorization = false;
        this.isManual = true;
        if (from == null && to == null) {
            return;
        }
        this.configureEMail(from, to, subject, message, html);
        this.valid = this.isValid(true);
    }

    @Deprecated
    public EMail(String smtpHost, int smtpPort, String protocol, String encryptionType, String authMechanism) {
        this(smtpHost, smtpPort, protocol, encryptionType, authMechanism, null, null, null, null, false);
    }

    public EMail(MClient client, int eMailConfigId) {
        this(client, eMailConfigId, null, null, null, null, false);
    }

    public EMail(MClient client) {
        this(client, client.getAD_EMailConfig_ID());
    }

    public Session getSession() {
        if (this.session != null) {
            return this.session;
        }
        if (this.getAuthMechanism().equals("O")) {
            Security.addProvider(new EMailOAuth2Provider());
            this.session = Session.getInstance((Properties)this.getEMailProperties());
        } else {
            this.session = Session.getInstance((Properties)this.getEMailProperties(), (Authenticator)this.auth);
        }
        this.session.setDebug(CLogMgt.isLevelFinest());
        return this.session;
    }

    public Transport getTransport(Session session) throws MessagingException {
        if (this.transport != null) {
            return this.transport;
        }
        if (this.getAuthMechanism().equals("O")) {
            this.transport = new SMTPTransport(session, null);
            this.transport.connect(this.getSmtpHost(), this.getPort(), this.user, this.token);
        } else {
            this.transport = session.getTransport(this.getStringProtocol());
            this.transport.connect();
        }
        this.session = session;
        log.fine("transport=" + this.transport);
        log.fine("transport connected");
        return this.transport;
    }

    public Transport getTransport() throws MessagingException {
        if (this.transport != null) {
            return this.transport;
        }
        return this.getTransport(this.getSession());
    }

    public Folder getDefaultFolder() throws MessagingException {
        if (this.store != null) {
            return this.store.getDefaultFolder();
        }
        this.getStore();
        return this.store.getDefaultFolder();
    }

    public Store getStore() throws MessagingException {
        if (this.store != null) {
            return this.store;
        }
        if (this.getSession() == null) {
            throw new IllegalStateException("No Session");
        }
        this.store = this.session.getStore(this.getStringProtocol());
        if (this.getAuthMechanism().equals("O")) {
            this.store.connect(this.getSmtpHost(), this.user, this.token);
        } else {
            this.store = this.session.getStore(this.getStringProtocol());
            this.store.connect();
        }
        log.fine("getStore - " + this.store);
        return this.store;
    }

    public String send() {
        log.info("(" + this.host + ") " + this.from + " -> " + this.to);
        this.sentMsg = null;
        if (!this.isValid(true)) {
            this.sentMsg = "Invalid Data";
            return this.sentMsg;
        }
        try {
            this.getSession();
        }
        catch (SecurityException se) {
            log.log(Level.WARNING, "Auth=" + (Object)((Object)this.auth) + " - " + se.toString());
            this.sentMsg = se.toString();
            return se.toString();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Auth=" + (Object)((Object)this.auth), e);
            this.sentMsg = e.toString();
            return e.toString();
        }
        try {
            this.msg = new SMTPMessage(this.getSession());
            this.msg.setFrom((Address)this.from);
            InternetAddress[] rec = this.getTos();
            if (rec.length == 1) {
                this.msg.setRecipient(Message.RecipientType.TO, (Address)rec[0]);
            } else {
                this.msg.setRecipients(Message.RecipientType.TO, (Address[])rec);
            }
            rec = this.getCcs();
            if (rec != null && rec.length > 0) {
                this.msg.setRecipients(Message.RecipientType.CC, (Address[])rec);
            }
            if ((rec = this.getBccs()) != null && rec.length > 0) {
                this.msg.setRecipients(Message.RecipientType.BCC, (Address[])rec);
            }
            if (this.replyTo != null) {
                this.msg.setReplyTo(new Address[]{this.replyTo});
            }
            this.msg.setSentDate(new Date());
            this.msg.setHeader("Comments", "AdempiereMail");
            this.msg.setAllow8bitMIME(true);
            this.msg.setReturnOption(2);
            this.setContent();
            this.msg.saveChanges();
            log.fine("message =" + this.msg);
            this.getTransport();
            Transport.send((Message)this.msg);
            log.fine("Success - MessageID=" + this.msg.getMessageID());
        }
        catch (MessagingException me) {
            Throwable ex = me;
            StringBuffer sb = new StringBuffer("(ME)");
            boolean printed = false;
            do {
                String className;
                if (ex instanceof SendFailedException) {
                    SendFailedException sfex = (SendFailedException)ex;
                    Address[] invalid = sfex.getInvalidAddresses();
                    if (!printed) {
                        Address[] validSent;
                        Address[] validUnsent;
                        if (invalid != null && invalid.length > 0) {
                            sb.append(" - Invalid:");
                            for (int i2 = 0; i2 < invalid.length; ++i2) {
                                sb.append(" ").append(invalid[i2]);
                            }
                        }
                        if ((validUnsent = sfex.getValidUnsentAddresses()) != null && validUnsent.length > 0) {
                            sb.append(" - ValidUnsent:");
                            for (int i3 = 0; i3 < validUnsent.length; ++i3) {
                                sb.append(" ").append(validUnsent[i3]);
                            }
                        }
                        if ((validSent = sfex.getValidSentAddresses()) != null && validSent.length > 0) {
                            sb.append(" - ValidSent:");
                            for (int i4 = 0; i4 < validSent.length; ++i4) {
                                sb.append(" ").append(validSent[i4]);
                            }
                        }
                        printed = true;
                    }
                    if (sfex.getNextException() != null) continue;
                    sb.append(" ").append(sfex.getLocalizedMessage());
                    continue;
                }
                if (ex instanceof AuthenticationFailedException) {
                    sb.append(" - Invalid Username/Password - " + (Object)((Object)this.auth));
                    continue;
                }
                String msg = ex.getLocalizedMessage();
                if (msg == null) {
                    sb.append(": ").append(ex.toString());
                    continue;
                }
                if (msg.indexOf("Could not connect to SMTP host:") != -1) {
                    int index = msg.indexOf(10);
                    if (index != -1) {
                        msg = msg.substring(0, index);
                    }
                    String cc = "??";
                    if (this.ctx != null) {
                        cc = this.ctx.getProperty("#AD_Client_ID");
                    }
                    msg = msg + " - AD_Client_ID=" + cc;
                }
                if ((className = ex.getClass().getName()).indexOf("MessagingException") != -1) {
                    sb.append(": ").append(msg);
                    continue;
                }
                sb.append(" ").append(className).append(": ").append(msg);
            } while ((ex = ex instanceof MessagingException ? ex.getNextException() : null) != null);
            if (CLogMgt.isLevelFinest()) {
                log.log(Level.WARNING, sb.toString(), me);
            } else {
                log.log(Level.WARNING, sb.toString());
            }
            this.sentMsg = sb.toString();
            return sb.toString();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
            this.sentMsg = e.getLocalizedMessage();
            return e.getLocalizedMessage();
        }
        if (CLogMgt.isLevelFinest()) {
            this.dumpMessage();
        }
        this.sentMsg = SENT_OK;
        return this.sentMsg;
    }

    public Properties getEMailProperties() {
        Properties props = System.getProperties();
        if (CLogMgt.isLevelFinest()) {
            props.put("mail.debug", "true");
        }
        props.put("mail.host", this.host);
        if (this.protocol.equals("S")) {
            if (this.timeout > 0L) {
                props.put("mail.smtp.timeout", String.valueOf(this.timeout));
            }
            if (this.timeout > 0L) {
                props.put("mail.smtp.connectiontimeout", String.valueOf(this.connectionTimeout));
            }
            props.put("mail.smtp.port", String.valueOf(this.getPort()));
            if (this.isSmtpAuthorization && this.auth != null) {
                props.put("mail.smtp.auth", "true");
            }
            props.put("mail.store.protocol", this.getStringProtocol());
            props.put("mail.transport.protocol", this.getStringProtocol());
            if (!this.getAuthMechanism().equals("O")) {
                if (this.getEncryptionType().equals("S")) {
                    props.put("mail.smtp.ssl.enable", "true");
                } else if (this.getEncryptionType().equals("T")) {
                    props.put("mail.smtp.starttls.enable", "true");
                }
                if (this.getAuthMechanism().equals("N")) {
                    props.put("mail.smtp.auth.mechanisms", "NTLM");
                    if (this.domain != null) {
                        props.put("mail.smtp.auth.ntlm.domain", this.domain);
                    }
                }
            } else if (this.getAuthMechanism().equals("O")) {
                props.put("mail.smtp.starttls.enable", "true");
                props.put("mail.smtp.sasl.enable", "true");
                props.put("mail.smtp.sasl.mechanisms", "XOAUTH2");
                props.put("mail.imaps.sasl.mechanisms.oauth2.oauthToken", this.token);
            }
        }
        if (this.protocol.equals("I")) {
            if (this.timeout > 0L) {
                props.put("mail.imap.timeout", String.valueOf(this.timeout));
            }
            if (this.timeout > 0L) {
                props.put("mail.imap.connectiontimeout", String.valueOf(this.connectionTimeout));
            }
            if (this.auth != null) {
                props.put("mail.imap.auth", "true");
            }
            props.put("mail.imap.port", String.valueOf(this.getPort()));
            props.put("mail.store.protocol", this.getStringProtocol());
            props.put("mail.transport.protocol", this.getStringProtocol());
            if (!this.getAuthMechanism().equals("O")) {
                if (this.getEncryptionType().equals("S")) {
                    props.put("mail.imap.ssl.enable", "true");
                } else if (this.getEncryptionType().equals("T")) {
                    props.put("mail.imap.starttls.enable", "true");
                }
                if (this.getAuthMechanism().equals("N")) {
                    props.put("mail.imap.auth.mechanisms", "NTLM");
                    if (this.domain != null) {
                        props.put("mail.imap.auth.ntlm.domain", this.domain);
                    }
                }
            } else {
                props.put("mail.imap.starttls.enable", "true");
                props.put("mail.imap.sasl.enable", "true");
                props.put("mail.imap.sasl.mechanisms", "XOAUTH2");
            }
        }
        return props;
    }

    private void setEMailParameters(int eMailConfigId) {
        MEMailConfig eMailConfig;
        if (eMailConfigId != 0) {
            this.eMailConfigId = eMailConfigId;
        }
        if (eMailConfigId == 0) {
            MClient client = MClient.get(this.ctx);
            eMailConfigId = client.getAD_EMailConfig_ID();
        }
        if ((eMailConfig = MEMailConfig.get(this.ctx, eMailConfigId)) != null) {
            this.host = eMailConfig.getSMTPHost();
            this.port = eMailConfig.getPort();
            this.timeout = eMailConfig.getTimeout();
            this.connectionTimeout = eMailConfig.getConnectionTimeout();
            this.protocol = eMailConfig.getProtocol();
            this.encryptionType = eMailConfig.getEncryptionType();
            this.authMechanism = eMailConfig.getAuthMechanism();
            this.isSmtpAuthorization = eMailConfig.isSmtpAuthorization();
            this.domain = eMailConfig.getLDAPDomain();
        } else {
            this.getPort();
            this.getProtocol();
            this.getEncryptionType();
            this.getAuthMechanism();
            this.isSmtpAuthorization = false;
        }
    }

    private void configureEMail(String from, String to, String subject, String message, boolean html) {
        this.setFrom(from);
        this.addTo(to);
        if (subject == null || subject.length() == 0) {
            this.setSubject(".");
        } else {
            this.setSubject(subject);
        }
        if (message != null && message.length() > 0) {
            if (html) {
                this.setMessageHTML(subject, message);
            } else {
                this.setMessageText(message);
            }
        }
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int gerEMailConfigId() {
        return this.eMailConfigId;
    }

    public int getPort() {
        if (this.port <= 0) {
            if (this.getProtocol().equals("S")) {
                this.port = this.getEncryptionType().equals("N") ? 25 : 587;
            } else if (this.getProtocol().equals("P")) {
                this.port = this.getEncryptionType().equals("N") ? 110 : 995;
            } else if (this.getProtocol().equals("I")) {
                this.port = this.getEncryptionType().equals("N") ? 143 : 993;
            }
        }
        return this.port;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        if (this.protocol == null) {
            this.protocol = "S";
        }
        return this.protocol;
    }

    public void setEncryptionType(String encryptionType) {
        this.encryptionType = encryptionType;
    }

    public String getEncryptionType() {
        if (this.encryptionType == null) {
            this.encryptionType = "N";
        }
        return this.encryptionType;
    }

    public void setAuthMechanism(String authMechanism) {
        this.authMechanism = authMechanism;
    }

    public String getAuthMechanism() {
        if (this.authMechanism == null) {
            this.authMechanism = "L";
        }
        return this.authMechanism;
    }

    public String getSentMsg() {
        return this.sentMsg;
    }

    public boolean isSentOK() {
        return this.sentMsg != null && SENT_OK.equals(this.sentMsg);
    }

    private void dumpMessage() {
        if (this.msg == null) {
            return;
        }
        try {
            Enumeration e = this.msg.getAllHeaderLines();
            while (e.hasMoreElements()) {
                log.fine("- " + e.nextElement());
            }
        }
        catch (MessagingException ex) {
            log.log(Level.WARNING, this.msg.toString(), ex);
        }
    }

    public boolean isSmtpAuthorization() {
        return this.isSmtpAuthorization;
    }

    protected MimeMessage getMimeMessage() {
        return this.msg;
    }

    public String getMessageID() {
        try {
            if (this.msg != null) {
                return this.msg.getMessageID();
            }
        }
        catch (MessagingException ex) {
            log.log(Level.SEVERE, "", ex);
        }
        return null;
    }

    public void createAuthenticator(String username, String password) {
        this.isSmtpAuthorization = false;
        if (this.getAuthMechanism().equals("O")) {
            this.user = username;
            this.token = password;
            this.isSmtpAuthorization = true;
        } else if (username == null || password == null) {
            log.warning("Ignored - " + username + "/" + password);
            this.auth = null;
        } else {
            this.auth = new EMailAuthenticator(username, password);
            this.isSmtpAuthorization = true;
        }
    }

    public String getStringProtocol() {
        if (this.getProtocol().equals("S")) {
            return "smtp";
        }
        if (this.getProtocol().equals("I")) {
            return "imap";
        }
        if (this.getProtocol().equals("P")) {
            return "pop3s";
        }
        return "";
    }

    public InternetAddress getFrom() {
        return this.from;
    }

    public void setFrom(String newFrom) {
        if (newFrom == null) {
            this.valid = false;
            return;
        }
        try {
            this.from = new InternetAddress(newFrom, true);
            if (this.isManual) {
                return;
            }
            if (MSysConfig.getBooleanValue("MAIL_SEND_BCC_TO_FROM", false, Env.getAD_Client_ID(Env.getCtx()))) {
                // empty if block
            }
            this.addBcc(newFrom);
            String bccAddressForAllMails = MSysConfig.getValue("MAIL_SEND_BCC_TO_ADDRESS", Env.getAD_Client_ID(Env.getCtx()));
            if (bccAddressForAllMails != null && bccAddressForAllMails.length() > 0) {
                this.addBcc(bccAddressForAllMails);
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, newFrom + ": " + e.toString());
            this.valid = false;
        }
    }

    public boolean addTo(String newTo) {
        if (newTo == null || newTo.length() == 0) {
            this.valid = false;
            return false;
        }
        InternetAddress ia = null;
        try {
            ia = new InternetAddress(newTo, true);
        }
        catch (Exception e) {
            log.log(Level.WARNING, newTo + ": " + e.toString());
            this.valid = false;
            return false;
        }
        if (this.to == null) {
            this.to = new ArrayList();
        }
        this.to.add(ia);
        return true;
    }

    public InternetAddress getTo() {
        if (this.to == null || this.to.size() == 0) {
            return null;
        }
        InternetAddress ia = this.to.get(0);
        return ia;
    }

    public InternetAddress[] getTos() {
        if (this.to == null || this.to.size() == 0) {
            return null;
        }
        InternetAddress[] ias = new InternetAddress[this.to.size()];
        this.to.toArray(ias);
        return ias;
    }

    public boolean addCc(String newCc) {
        if (newCc == null || newCc.length() == 0) {
            return false;
        }
        InternetAddress ia = null;
        try {
            ia = new InternetAddress(newCc, true);
        }
        catch (Exception e) {
            log.log(Level.WARNING, newCc + ": " + e.toString());
            return false;
        }
        if (this.cc == null) {
            this.cc = new ArrayList();
        }
        this.cc.add(ia);
        return true;
    }

    public InternetAddress[] getCcs() {
        if (this.cc == null || this.cc.size() == 0) {
            return null;
        }
        InternetAddress[] ias = new InternetAddress[this.cc.size()];
        this.cc.toArray(ias);
        return ias;
    }

    public boolean addBcc(String newBcc) {
        if (newBcc == null || newBcc.length() == 0) {
            return false;
        }
        InternetAddress ia = null;
        try {
            ia = new InternetAddress(newBcc, true);
        }
        catch (Exception e) {
            log.log(Level.WARNING, newBcc + ": " + e.getMessage());
            return false;
        }
        if (this.bcc == null) {
            this.bcc = new ArrayList();
        }
        this.bcc.add(ia);
        return true;
    }

    public InternetAddress[] getBccs() {
        if (this.bcc == null || this.bcc.size() == 0) {
            return null;
        }
        InternetAddress[] ias = new InternetAddress[this.bcc.size()];
        this.bcc.toArray(ias);
        return ias;
    }

    public boolean setReplyTo(String newTo) {
        if (newTo == null || newTo.length() == 0) {
            return false;
        }
        InternetAddress ia = null;
        try {
            ia = new InternetAddress(newTo, true);
        }
        catch (Exception e) {
            log.log(Level.WARNING, newTo + ": " + e.toString());
            return false;
        }
        this.replyTo = ia;
        return true;
    }

    public InternetAddress getReplyTo() {
        return this.replyTo;
    }

    public void setSubject(String newSubject) {
        if (newSubject == null || newSubject.length() == 0) {
            this.valid = false;
        } else {
            this.subject = newSubject;
        }
    }

    public String getSubject() {
        return this.subject;
    }

    public void setMessageText(String newMessage) {
        if (newMessage == null || newMessage.length() == 0) {
            this.valid = false;
        } else {
            this.messageText = newMessage;
            if (!this.messageText.endsWith("\n")) {
                this.messageText = this.messageText + "\n";
            }
        }
    }

    public String getMessageCRLF() {
        if (this.messageText == null) {
            return "";
        }
        char[] chars = this.messageText.toCharArray();
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < chars.length; ++i2) {
            char c = chars[i2];
            if (c == '\n') {
                int previous = i2 - 1;
                if (previous >= 0 && chars[previous] == '\r') {
                    sb.append(c);
                    continue;
                }
                sb.append("\r\n");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public void setMessageHTML(String html) {
        if (html == null || html.length() == 0) {
            this.valid = false;
        } else {
            this.messageHTML = html;
            if (!this.messageHTML.endsWith("\n")) {
                this.messageHTML = this.messageHTML + "\n";
            }
        }
    }

    public void setMessageHTML(String subject, String message) {
        this.subject = subject;
        StringBuffer sb = new StringBuffer("<HTML>\n").append("<HEAD>\n").append("<TITLE>\n").append(subject + "\n").append("</TITLE>\n").append("</HEAD>\n");
        sb.append("<BODY>\n").append("<H2>" + subject + "</H2>\n").append(message).append("\n").append("</BODY>\n");
        sb.append("</HTML>\n");
        this.messageHTML = sb.toString();
    }

    public String getMessageHTML() {
        return this.messageHTML;
    }

    public void addAttachment(File file) {
        if (file == null) {
            return;
        }
        if (this.attachments == null) {
            this.attachments = new ArrayList();
        }
        this.attachments.add(file);
    }

    public void addAttachments(Collection<File> files) {
        if (files == null || files.size() == 0) {
            return;
        }
        for (File f : files) {
            this.addAttachment(f);
        }
    }

    public void addAttachment(URI url) {
        if (url == null) {
            return;
        }
        if (this.attachments == null) {
            this.attachments = new ArrayList();
        }
        this.attachments.add(url);
    }

    public void addAttachment(byte[] data, String type, String name) {
        ByteArrayDataSource byteArray = new ByteArrayDataSource(data, type).setName(name);
        this.addAttachment(byteArray);
    }

    public void addAttachment(DataSource dataSource) {
        if (dataSource == null) {
            return;
        }
        if (this.attachments == null) {
            this.attachments = new ArrayList();
        }
        this.attachments.add(dataSource);
    }

    /*
     * Unable to fully structure code
     */
    private void setContent() throws MessagingException, IOException {
        block13: {
            block12: {
                charSetName = Ini.getCharset().name();
                if (charSetName == null || charSetName.length() == 0) {
                    charSetName = "iso-8859-1";
                }
                this.msg.setSubject(this.getSubject(), charSetName);
                if (this.attachments != null && this.attachments.size() != 0) break block12;
                if (this.messageHTML == null || this.messageHTML.length() == 0) {
                    this.msg.setText(this.getMessageCRLF(), charSetName);
                } else {
                    this.msg.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(this.messageHTML, charSetName, "text/html")));
                }
                EMail.log.fine("(simple) " + this.getSubject());
                break block13;
            }
            mbp_1 = new MimeBodyPart();
            mbp_1.setText("");
            if (this.messageHTML == null || this.messageHTML.length() == 0) {
                mbp_1.setText(this.getMessageCRLF(), charSetName);
            } else {
                mbp_1.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(this.messageHTML, charSetName, "text/html")));
            }
            mp = new MimeMultipart();
            mp.addBodyPart((BodyPart)mbp_1);
            EMail.log.fine("(multi) " + this.getSubject() + " - " + mbp_1);
            for (i = 0; i < this.attachments.size(); ++i) {
                attachment = this.attachments.get(i);
                ds = null;
                if (!(attachment instanceof File)) ** GOTO lbl32
                file = (File)attachment;
                if (file.exists()) {
                    ds = new FileDataSource(file);
                } else {
                    EMail.log.log(Level.WARNING, "File does not exist: " + file);
                    continue;
lbl32:
                    // 1 sources

                    if (attachment instanceof URI) {
                        url = (URI)attachment;
                        ds = new URLDataSource(url.toURL());
                    } else if (attachment instanceof DataSource) {
                        ds = (DataSource)attachment;
                    } else {
                        EMail.log.log(Level.WARNING, "Attachement type unknown: " + attachment);
                        continue;
                    }
                }
                mbp_2 = new MimeBodyPart();
                mbp_2.setDataHandler(new DataHandler(ds));
                mbp_2.setFileName(ds.getName());
                EMail.log.fine("Added Attachment " + ds.getName() + " - " + mbp_2);
                mp.addBodyPart((BodyPart)mbp_2);
            }
            this.msg.setContent((Multipart)mp);
        }
    }

    public void setSmtpHost(String newSmtpHost) {
        if (newSmtpHost == null || newSmtpHost.length() == 0) {
            this.valid = false;
        } else {
            this.host = newSmtpHost;
        }
    }

    public String getSmtpHost() {
        return this.host;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isValid(boolean recheck) {
        if (!recheck) {
            return this.valid;
        }
        if (this.from == null || this.from.getAddress().length() == 0 || this.from.getAddress().indexOf(32) != -1) {
            log.warning("From is invalid=" + this.from);
            return false;
        }
        InternetAddress[] ias = this.getTos();
        if (ias == null) {
            log.warning("No To");
            return false;
        }
        for (int i2 = 0; i2 < ias.length; ++i2) {
            if (ias[i2] != null && ias[i2].getAddress().length() != 0 && ias[i2].getAddress().indexOf(32) == -1) continue;
            log.warning("To(" + i2 + ") is invalid=" + ias[i2]);
            return false;
        }
        if (this.host == null || this.host.length() == 0) {
            log.warning("SMTP Host is invalid" + this.host);
            return false;
        }
        if (this.subject == null || this.subject.length() == 0) {
            log.warning("Subject is invalid=" + this.subject);
            return false;
        }
        return true;
    }

    public Object[] getAttachments() {
        if (this.attachments == null) {
            return new Object[0];
        }
        return this.attachments.toArray();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("EMail[");
        sb.append("From:").append(this.from).append(",To:").append(this.getTo()).append(",Subject=").append(this.getSubject()).append("]");
        return sb.toString();
    }

    public static void main(String[] args) {
        Adempiere.startup(true);
        if (args.length != 5) {
            System.out.println("Parameters: smtpHost from to subject message");
            System.out.println("Example: java org.compiere.util.EMail mail.acme.com joe@acme.com sue@acme.com HiThere CheersJoe");
            System.exit(1);
        }
        EMail email = new EMail(args[0], args[1], args[2], args[3], args[4], false);
        email.send();
    }
}

