/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.io.File;
import java.io.Serializable;
import javax.swing.filechooser.FileFilter;

public class ExtensionFileFilter
extends FileFilter
implements Serializable {
    private static final long serialVersionUID = 1653311024184813302L;
    private String m_extension;
    private String m_description;

    public ExtensionFileFilter() {
        this("", "");
    }

    public ExtensionFileFilter(String extension, String description) {
        this.setDescription(description);
        this.setExtension(extension);
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String newDescription) {
        this.m_description = newDescription;
    }

    public void setExtension(String newExtension) {
        this.m_extension = newExtension;
    }

    public String getExtension() {
        return this.m_extension;
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String ext = file.getName();
        int pos = ext.lastIndexOf(46);
        if (pos == -1) {
            return false;
        }
        return this.m_extension.equalsIgnoreCase(ext = ext.substring(pos + 1));
    }

    public static String getFileName(File file, FileFilter filter) {
        return ExtensionFileFilter.getFile(file, filter).getAbsolutePath();
    }

    public static File getFile(File file, FileFilter filter) {
        String fName = file.getAbsolutePath();
        if (fName == null || fName.equals("")) {
            fName = "Adempiere";
        }
        ExtensionFileFilter eff = null;
        if (!(filter instanceof ExtensionFileFilter)) {
            return file;
        }
        eff = (ExtensionFileFilter)filter;
        int pos = fName.lastIndexOf(46);
        if (pos == -1) {
            fName = fName + '.' + eff.getExtension();
            return new File(fName);
        }
        String ext = fName.substring(pos + 1);
        if (ext.equalsIgnoreCase(eff.getExtension())) {
            return file;
        }
        fName = fName + '.' + eff.getExtension();
        return new File(fName);
    }
}

