/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.engine.warehouse;

import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.Adempiere;
import org.compiere.model.MBPartner;
import org.compiere.model.MLocator;
import org.compiere.model.MProduct;
import org.compiere.model.MStorage;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Login;
import org.eevolution.engine.warehouse.WMRuleFIFO;
import org.eevolution.engine.warehouse.WMRuleInterface;
import org.eevolution.model.MWMDefinition;
import org.eevolution.model.MWMInOutBound;
import org.eevolution.model.MWMInOutBoundLine;
import org.eevolution.model.MWMRule;
import org.eevolution.model.MWMStrategy;
import org.eevolution.model.MWMStrategyDetail;

public final class WMRuleEngine {
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private static WMRuleEngine s_instance = null;
    private static TreeSet<String> s_RuleNoImplement = new TreeSet();
    private HashMap<String, WMRuleInterface> m_WMRules = new HashMap();
    private String m_packageName = "org.eevolution.engine.warehouse";

    public static List<MWMRule> getWMRules(Properties properties, int n, String string) {
        String string2 = "";
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (n > 0) {
            string2 = "AD_Client_ID=?";
            arrayList.add(n);
        } else {
            string2 = null;
        }
        return new Query(properties, "WM_Rule", string2, string).setOnlyActiveRecords(true).setParameters(new Object[]{arrayList}).list();
    }

    public static void applyWMRule(List<MWMInOutBound> list, String string) {
        for (MWMInOutBound mWMInOutBound : list) {
            for (MWMDefinition mWMDefinition : MWMDefinition.getAll(mWMInOutBound.getCtx(), mWMInOutBound.get_TrxName())) {
                WMRuleEngine.validateDefinition(mWMInOutBound, mWMDefinition, string);
            }
        }
    }

    private static void validateDefinition(MWMInOutBound mWMInOutBound, MWMDefinition mWMDefinition, String string) {
        for (MWMStrategy mWMStrategy : MWMStrategy.getByBoundType(mWMInOutBound.getCtx(), string, mWMInOutBound.get_TrxName())) {
            for (MWMStrategyDetail mWMStrategyDetail : mWMStrategy.getStrategyDetail()) {
                MWMRule mWMRule = (MWMRule)mWMStrategyDetail.getWM_Rule();
            }
        }
    }

    private WMRuleEngine() {
        this.registerRules(true);
    }

    protected void registerRules(boolean bl) {
        if (bl) {
            this.m_WMRules.clear();
        }
        WMRuleInterface wMRuleInterface = this.getWMRuleFactory(WMRuleFIFO.class.getSimpleName());
    }

    public static WMRuleEngine get() {
        if (s_instance == null) {
            s_instance = new WMRuleEngine();
        }
        return s_instance;
    }

    public WMRuleInterface getWMRuleFactory(String string) {
        if (this.m_WMRules.containsKey(string)) {
            return this.m_WMRules.get(string);
        }
        try {
            Class clazz = this.getClass(string);
            Constructor constructor = null;
            try {
                constructor = clazz.getDeclaredConstructor(new Class[0]);
            }
            catch (Exception exception) {
                this.log.fine("Not found <WMRule>()");
            }
            if (constructor != null) {
                WMRuleInterface wMRuleInterface = (WMRuleInterface)constructor.newInstance(new Object[0]);
                this.m_WMRules.put(string, wMRuleInterface);
                return wMRuleInterface;
            }
            constructor = clazz.getDeclaredConstructor(new Class[0]);
            WMRuleInterface wMRuleInterface = (WMRuleInterface)constructor.newInstance(new Object[0]);
            this.m_WMRules.put(string, wMRuleInterface);
            return wMRuleInterface;
        }
        catch (ClassNotFoundException classNotFoundException) {
            s_RuleNoImplement.add(string);
        }
        catch (Throwable throwable) {
            throw new AdempiereException(throwable);
        }
        return null;
    }

    public String getPackageName() {
        return this.m_packageName;
    }

    protected <T extends WMRuleInterface> Class<T> getClass(String string) throws ClassNotFoundException {
        return Class.forName(this.getPackageName() + "." + string);
    }

    protected String getClassName(MWMRule mWMRule) {
        if ("WMF".equals(mWMRule.getInOutBoundRule())) {
            return WMRuleFIFO.class.getSimpleName();
        }
        if ("WMI".equals(mWMRule.getInOutBoundRule())) {
            return mWMRule.getInOutboundClass();
        }
        throw new AdempiereException(mWMRule.getInOutBoundRule() + "is not implement");
    }

    public List<MLocator> getLocator(MWMInOutBoundLine mWMInOutBoundLine, int n, int n2) {
        MWMStrategy mWMStrategy = this.applyDefinition(mWMInOutBoundLine, n, n2);
        return WMRuleEngine.getLocator(mWMStrategy, mWMInOutBoundLine.getProduct().getM_Product_ID(), n2, n2);
    }

    public List<MStorage> getStorage(MWMInOutBoundLine mWMInOutBoundLine, int n, int n2) {
        MWMStrategy mWMStrategy = this.applyDefinition(mWMInOutBoundLine, n, n2);
        return WMRuleEngine.getStorage(mWMStrategy, mWMInOutBoundLine.getProduct().getM_Product_ID(), mWMInOutBoundLine.getM_AttributeSetInstance_ID(), mWMInOutBoundLine.getMovementQty(), n2, n2);
    }

    private MWMStrategy applyDefinition(MWMInOutBoundLine mWMInOutBoundLine, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer("(");
        stringBuffer.append("M_Product_ID IN (0,?) OR ");
        stringBuffer.append("M_Product_ID IS NULL");
        stringBuffer.append(") AND ");
        stringBuffer.append("(");
        stringBuffer.append("M_Product_Category_ID IN (0,?) OR ");
        stringBuffer.append("M_Product_Category_ID IS NULL");
        stringBuffer.append(") AND ");
        stringBuffer.append("(");
        stringBuffer.append("Group1 IN ('',?) OR ");
        stringBuffer.append("Group1 IS NULL");
        stringBuffer.append(") AND ");
        stringBuffer.append("(");
        stringBuffer.append("Group2 IN ('',?) OR ");
        stringBuffer.append("Group2 IS NULL");
        stringBuffer.append(") AND ");
        stringBuffer.append("(");
        stringBuffer.append("Classification IN ('',?) OR ");
        stringBuffer.append("Classification IS NULL");
        stringBuffer.append(") AND ");
        stringBuffer.append("(");
        stringBuffer.append("C_BPartner_ID IN (0,?) OR ");
        stringBuffer.append("C_BPartner_ID IS NULL");
        stringBuffer.append(") AND ");
        stringBuffer.append("(");
        stringBuffer.append("C_BP_Group_ID IN (0,?) OR ");
        stringBuffer.append("C_BP_Group_ID IS NULL");
        stringBuffer.append(") AND ");
        stringBuffer.append("(");
        stringBuffer.append("WM_Area_Type_ID IN (0,?) OR ");
        stringBuffer.append("WM_Area_Type_ID IS NULL");
        stringBuffer.append(") AND ");
        stringBuffer.append("(");
        stringBuffer.append("WM_Section_Type_ID IN (0,?) OR ");
        stringBuffer.append("WM_Section_Type_ID IS NULL");
        stringBuffer.append(")");
        stringBuffer.append(" AND EXISTS (SELECT 1 FROM WM_Strategy");
        stringBuffer.append(" WHERE ");
        stringBuffer.append("WM_Strategy.WM_Strategy_ID=");
        stringBuffer.append("WM_Definition.WM_Strategy_ID");
        stringBuffer.append(" AND ");
        stringBuffer.append("InOutBoundType=?");
        stringBuffer.append(")");
        MProduct mProduct = mWMInOutBoundLine.getProduct();
        MBPartner mBPartner = mWMInOutBoundLine.getBPartner();
        MWMDefinition mWMDefinition = (MWMDefinition)new Query(mWMInOutBoundLine.getCtx(), "WM_Definition", stringBuffer.toString(), mWMInOutBoundLine.get_TrxName()).setClient_ID().setParameters(mProduct.getM_Product_ID(), mProduct.getM_Product_Category_ID(), mProduct.getGroup1(), mProduct.getGroup2(), mProduct.getClassification(), mBPartner.getC_BPartner_ID(), mBPartner.getC_BP_Group_ID(), n, n2, "O").first();
        if (mWMDefinition == null) {
            throw new AdempiereException("@WM_Definition_ID@ @NotFound@");
        }
        return mWMDefinition.getWarehouseStrategy();
    }

    public static List<MLocator> getLocator(MWMStrategy mWMStrategy, int n, int n2, int n3) {
        ArrayList<MLocator> arrayList = new ArrayList<MLocator>();
        WMRuleEngine wMRuleEngine = WMRuleEngine.get();
        for (MWMStrategyDetail mWMStrategyDetail : mWMStrategy.getStrategyDetail()) {
            MWMRule mWMRule = (MWMRule)mWMStrategyDetail.getWM_Rule();
            WMRuleInterface wMRuleInterface = wMRuleEngine.getWMRuleFactory(wMRuleEngine.getClassName(mWMRule));
            List<MLocator> list = wMRuleInterface.getLocator(mWMStrategy.getCtx(), n, mWMStrategy.getM_Warehouse_ID(), n2, n3, mWMStrategy.get_TrxName());
            for (MLocator mLocator : list) {
                arrayList.add(mLocator);
            }
        }
        return arrayList;
    }

    public static List<MStorage> getStorage(MWMStrategy mWMStrategy, int n, int n2, BigDecimal bigDecimal, int n3, int n4) {
        ArrayList<MStorage> arrayList = new ArrayList<MStorage>();
        WMRuleEngine wMRuleEngine = WMRuleEngine.get();
        for (MWMStrategyDetail mWMStrategyDetail : mWMStrategy.getStrategyDetail()) {
            MWMRule mWMRule = (MWMRule)mWMStrategyDetail.getWM_Rule();
            WMRuleInterface wMRuleInterface = wMRuleEngine.getWMRuleFactory(wMRuleEngine.getClassName(mWMRule));
            List<MStorage> list = wMRuleInterface.getStorage(mWMStrategy.getCtx(), mWMStrategy.getM_Warehouse_ID(), n, n2, bigDecimal, n3, n4, mWMStrategy.get_TrxName());
            for (MStorage mStorage : list) {
                arrayList.add(mStorage);
            }
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        Adempiere.startup(true);
        Ini.setProperty("ApplicationUserID", "SuperUser");
        Ini.setProperty("ApplicationPassword", "System");
        Ini.setProperty("Role", "GardenWorld Admin");
        Ini.setProperty("Client", "GardenWorld");
        Ini.setProperty("Organization", "HQ");
        Ini.setProperty("Warehouse", "HQ Warehouse");
        Ini.setProperty("Language", "English");
        Login login = new Login(Env.getCtx());
        login.batchLogin();
        MWMInOutBoundLine mWMInOutBoundLine = new MWMInOutBoundLine(Env.getCtx(), 1000006, null);
        WMRuleEngine wMRuleEngine = WMRuleEngine.get();
        MWMInOutBound mWMInOutBound = mWMInOutBoundLine.getParent();
        wMRuleEngine.getLocator(mWMInOutBoundLine, 0, 0);
    }
}

