/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import org.compiere.model.I_M_Shipper;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MWarehouse;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_C_Order;
import org.compiere.model.X_C_OrderLine;
import org.compiere.util.Env;
import org.eevolution.engine.freight.FreightEngine;
import org.eevolution.engine.freight.FreightEngineFactory;
import org.eevolution.model.MDDOrder;
import org.eevolution.model.MDDOrderLine;
import org.eevolution.model.MWMInOutBound;
import org.eevolution.model.MWMInOutBoundLine;
import org.eevolution.model.X_DD_Order;
import org.eevolution.model.X_DD_OrderLine;
import org.eevolution.model.X_WM_InOutBound;
import org.eevolution.model.X_WM_InOutBoundLine;

public class FreightModelValidator
implements ModelValidator {
    FreightEngine freightEngine;

    @Override
    public void initialize(ModelValidationEngine modelValidationEngine, MClient mClient) {
        Integer n = mClient != null ? Integer.valueOf(mClient.getAD_Client_ID()) : Integer.valueOf(this.getAD_Client_ID());
        this.freightEngine = FreightEngineFactory.getFreightEngine(n);
        modelValidationEngine.addModelChange("C_OrderLine", this);
        modelValidationEngine.addModelChange("WM_InOutBoundLine", this);
        modelValidationEngine.addModelChange("DD_OrderLine", this);
        modelValidationEngine.addDocValidate("C_Order", this);
        modelValidationEngine.addDocValidate("DD_Order", this);
        modelValidationEngine.addDocValidate("WM_InOutBound", this);
    }

    @Override
    public int getAD_Client_ID() {
        return Env.getAD_Client_ID(Env.getCtx());
    }

    @Override
    public String login(int n, int n2, int n3) {
        return null;
    }

    @Override
    public String docValidate(PO pO, int n) {
        if (9 == n) {
            AtomicReference<BigDecimal> atomicReference;
            PO pO2;
            if (pO instanceof MOrder) {
                pO2 = (MOrder)pO;
                atomicReference = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
                Arrays.stream(((MOrder)pO2).getLines()).forEach(mOrderLine -> atomicReference.getAndUpdate(bigDecimal -> bigDecimal.add(mOrderLine.getFreightAmt())));
                ((X_C_Order)pO2).setFreightAmt(atomicReference.get());
                pO2.saveEx();
            }
            if (pO instanceof MDDOrder) {
                pO2 = (MDDOrder)pO;
                atomicReference = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
                ((MDDOrder)pO2).getLines().forEach(mDDOrderLine -> atomicReference.getAndUpdate(bigDecimal -> bigDecimal.add(mDDOrderLine.getFreightAmt())));
                ((X_DD_Order)pO2).setFreightAmt(atomicReference.get());
                pO2.saveEx();
            }
            if (pO instanceof MWMInOutBound) {
                pO2 = (MWMInOutBound)pO;
                atomicReference = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
                ((MWMInOutBound)pO2).getLines(false, null).forEach(mWMInOutBoundLine -> atomicReference.getAndUpdate(bigDecimal -> bigDecimal.add(mWMInOutBoundLine.getFreightAmt())));
                ((X_WM_InOutBound)pO2).setFreightAmt(atomicReference.get());
                pO2.saveEx();
            }
        }
        return null;
    }

    @Override
    public String modelChange(PO pO, int n) throws Exception {
        if (2 == n) {
            PO pO2;
            if (pO instanceof MOrderLine && "S".equals(((MOrderLine)(pO2 = (MOrderLine)pO)).getParent().getDeliveryViaRule())) {
                BigDecimal bigDecimal = this.getFreight((MOrderLine)pO2, null);
                ((X_C_OrderLine)pO2).setFreightAmt(bigDecimal.multiply(((X_C_OrderLine)pO2).getQtyOrdered()));
                if (!"I".equals(((MOrderLine)pO2).getParent().getFreightCostRule()) && bigDecimal.signum() != 0) {
                    BigDecimal bigDecimal2 = ((X_C_OrderLine)pO2).getPriceActual().add(bigDecimal);
                    ((X_C_OrderLine)pO2).setPriceEntered(bigDecimal2);
                    ((MOrderLine)pO2).setPriceActual(bigDecimal2);
                    ((MOrderLine)pO2).setLineNetAmt();
                }
            }
            if (pO instanceof MDDOrderLine && "S".equals(((MDDOrderLine)(pO2 = (MDDOrderLine)pO)).getParent().getDeliveryViaRule())) {
                ((X_DD_OrderLine)pO2).setFreightAmt(this.getFreight((MDDOrderLine)pO2, null).multiply(((X_DD_OrderLine)pO2).getQtyOrdered()));
            }
            if (pO instanceof MWMInOutBoundLine && "S".equals(((MWMInOutBoundLine)(pO2 = (MWMInOutBoundLine)pO)).getParent().getDeliveryViaRule())) {
                ((X_WM_InOutBoundLine)pO2).setFreightAmt(this.getFreight((MWMInOutBoundLine)pO2).multiply(((X_WM_InOutBoundLine)pO2).getMovementQty()));
            }
        }
        return null;
    }

    private BigDecimal getFreight(MOrderLine mOrderLine, MWMInOutBound mWMInOutBound) {
        int n;
        I_M_Shipper i_M_Shipper;
        MOrder mOrder = mOrderLine.getParent();
        MWarehouse mWarehouse = (MWarehouse)mOrder.getM_Warehouse();
        I_M_Shipper i_M_Shipper2 = i_M_Shipper = "L".equals(mOrder.getFreightCostRule()) ? mOrderLine.getM_Shipper() : mOrder.getM_Shipper();
        int n2 = mWMInOutBound == null ? ("L".equals(mOrder.getFreightCostRule()) ? mOrderLine.getM_FreightCategory_ID() : mOrder.getM_FreightCategory_ID()) : (n = mWMInOutBound.getM_FreightCategory_ID());
        if (this.isCalculatedFreight(mOrder.getFreightCostRule()) && n > 0) {
            this.freightEngine = FreightEngineFactory.getFreightEngine(mOrderLine.getAD_Client_ID());
            return this.freightEngine.getFreightRuleFactory(i_M_Shipper, mOrder.getFreightCostRule()).calculate(mOrder.getCtx(), mOrderLine.getM_Product_ID(), i_M_Shipper.getM_Shipper_ID(), mWarehouse.getC_Location_ID(), mOrder.getC_BPartner_Location().getC_Location_ID(), n, mOrder.getC_Currency_ID(), mOrder.getDateOrdered(), mOrder.get_TrxName());
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal getFreight(MDDOrderLine mDDOrderLine, MWMInOutBound mWMInOutBound) {
        int n;
        I_M_Shipper i_M_Shipper;
        MDDOrder mDDOrder = mDDOrderLine.getParent();
        I_M_Shipper i_M_Shipper2 = i_M_Shipper = "L".equals(mDDOrder.getFreightCostRule()) ? mDDOrderLine.getM_Shipper() : mDDOrder.getM_Shipper();
        int n2 = mWMInOutBound == null ? ("L".equals(mDDOrder.getFreightCostRule()) ? mDDOrderLine.getM_FreightCategory_ID() : mDDOrder.getM_FreightCategory_ID()) : (n = mWMInOutBound.getM_FreightCategory_ID());
        if (this.isCalculatedFreight(mDDOrder.getFreightCostRule()) && n > 0) {
            return this.freightEngine.getFreightRuleFactory(i_M_Shipper, mDDOrder.getFreightCostRule()).calculate(mDDOrder.getCtx(), mDDOrderLine.getM_Product_ID(), i_M_Shipper.getM_Shipper_ID(), mDDOrderLine.getM_Locator().getM_Warehouse().getC_Location_ID(), mDDOrder.getC_BPartner_Location().getC_Location_ID(), n, mDDOrder.getC_Currency_ID(), mDDOrder.getDateOrdered(), mDDOrder.get_TrxName());
        }
        return BigDecimal.ZERO;
    }

    private boolean isCalculatedFreight(String string) {
        return "L".equals(string) || "C".equals(string) || "I".equals(string);
    }

    private BigDecimal getFreight(MWMInOutBoundLine mWMInOutBoundLine) {
        if (mWMInOutBoundLine.getC_OrderLine_ID() > 0) {
            return this.getFreight((MOrderLine)mWMInOutBoundLine.getC_OrderLine(), mWMInOutBoundLine.getParent());
        }
        if (mWMInOutBoundLine.getDD_OrderLine_ID() > 0) {
            return this.getFreight((MDDOrderLine)mWMInOutBoundLine.getDD_OrderLine(), mWMInOutBoundLine.getParent());
        }
        return BigDecimal.ZERO;
    }
}

