/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDocType;
import org.compiere.model.MPeriod;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.DB;
import org.compiere.util.Msg;
import org.eevolution.model.MDDFreightLine;
import org.eevolution.model.X_DD_Freight;

public class MDDFreight
extends X_DD_Freight
implements DocAction {
    private List<MDDFreightLine> freightLines = null;
    private String processMsg = null;
    private boolean justPrepared = false;

    public MDDFreight(Properties properties, int n, String string) {
        super(properties, n, string);
    }

    public MDDFreight(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    public List<MDDFreightLine> getLines() {
        if (this.freightLines != null) {
            return this.freightLines;
        }
        this.freightLines = new Query(this.getCtx(), "DD_FreightLine", "DD_Freight_ID=?", this.get_TrxName()).setParameters(this.get_ID()).setOrderBy("Line").list();
        return this.freightLines;
    }

    @Override
    protected boolean beforeDelete() {
        for (MDDFreightLine mDDFreightLine : this.getLines()) {
            mDDFreightLine.deleteEx(true);
        }
        return true;
    }

    @Override
    public boolean processIt(String string) throws Exception {
        this.processMsg = null;
        DocumentEngine documentEngine = new DocumentEngine(this, this.getDocStatus());
        return documentEngine.processIt(string, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        return true;
    }

    @Override
    public boolean invalidateIt() {
        this.log.info("invalidateIt - " + this.toString());
        return true;
    }

    @Override
    public String prepareIt() {
        this.log.info(this.toString());
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.processMsg != null) {
            return "IN";
        }
        if (this.getLines().size() == 0) {
            throw new AdempiereException("@NoLines@");
        }
        MPeriod.testPeriodOpen(this.getCtx(), this.getDateDoc(), "DOO", this.getAD_Org_ID());
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.processMsg != null) {
            return "IN";
        }
        this.justPrepared = true;
        return "IP";
    }

    @Override
    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        String string;
        if (!this.justPrepared && !"IP".equals(string = this.prepareIt())) {
            return string;
        }
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        string = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (string != null) {
            this.processMsg = string;
            return "IN";
        }
        this.setDefiniteDocumentNo();
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    private void setDefiniteDocumentNo() {
        String string;
        MDocType mDocType = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (mDocType.isOverwriteDateOnComplete()) {
            this.setDateDoc(new Timestamp(System.currentTimeMillis()));
        }
        if (mDocType.isOverwriteSeqOnComplete() && (string = DB.getDocumentNo(this.getC_DocType_ID(), this.get_TrxName(), true, (PO)this)) != null) {
            this.setDocumentNo(string);
        }
    }

    @Override
    public boolean voidIt() {
        this.log.info("voidIt - " + this.toString());
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
        if (this.processMsg != null) {
            return false;
        }
        if (!this.closeIt()) {
            return false;
        }
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 10);
        return this.processMsg == null;
    }

    @Override
    public boolean closeIt() {
        this.log.info("closeIt - " + this.toString());
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 3);
        if (this.processMsg != null) {
            return false;
        }
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 11);
        return this.processMsg == null;
    }

    @Override
    public boolean reverseCorrectIt() {
        this.log.info("reverseCorrectIt - " + this.toString());
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 5);
        if (this.processMsg != null) {
            return false;
        }
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 13);
        if (this.processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean reverseAccrualIt() {
        this.log.info("reverseAccrualIt - " + this.toString());
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 6);
        if (this.processMsg != null) {
            return false;
        }
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 14);
        if (this.processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean reActivateIt() {
        this.log.info("reActivateIt - " + this.toString());
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.processMsg != null) {
            return false;
        }
        if (!this.reverseCorrectIt()) {
            return false;
        }
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 12);
        return this.processMsg == null;
    }

    @Override
    public String getSummary() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getDocumentNo());
        stringBuffer.append(" - ").append(this.getDocumentInfo());
        stringBuffer.append(": ").append(" (#").append(this.getLines().size()).append(")");
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            stringBuffer.append(" - ").append(this.getDescription());
        }
        return stringBuffer.toString();
    }

    @Override
    public String getDocumentInfo() {
        return Msg.getElement(this.getCtx(), "DD_Freight_ID") + " " + this.getDocumentNo();
    }

    @Override
    public File createPDF() {
        try {
            File file = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(file);
        }
        catch (Exception exception) {
            this.log.severe("Could not create PDF - " + exception.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    public boolean isComplete() {
        String string = this.getDocStatus();
        return "CO".equals(string) || "CL".equals(string) || "RE".equals(string);
    }

    @Override
    public String getProcessMsg() {
        return null;
    }

    @Override
    public int getDoc_User_ID() {
        return 0;
    }

    @Override
    public int getC_Currency_ID() {
        return 0;
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return null;
    }
}

