/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import org.compiere.model.MBPartner;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.eevolution.model.MHRPayroll;
import org.eevolution.model.MHRPeriod;
import org.eevolution.model.MHRProcess;
import org.eevolution.model.X_HR_Employee;
import org.eevolution.model.X_HR_Period;
import org.eevolution.model.X_I_HR_Employee;

public class MHREmployee
extends X_HR_Employee {
    private static final long serialVersionUID = -7083160315471023587L;
    private static CCache<Integer, MHREmployee> employeeCache = new CCache("HR_Employee", 1000);

    public static MHREmployee getByPartnerIdAndStartDate(Properties properties, Integer n, Timestamp timestamp, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("C_BPartner_ID").append("=? AND ");
        stringBuilder.append("StartDate").append("=? ");
        return (MHREmployee)new Query(properties, "HR_Employee", stringBuilder.toString(), string).setClient_ID().setParameters(n, timestamp).first();
    }

    public static MHREmployee getById(Properties properties, int n) {
        if (n <= 0) {
            return null;
        }
        MHREmployee mHREmployee = employeeCache.get(n);
        if (mHREmployee != null) {
            return mHREmployee;
        }
        mHREmployee = new MHREmployee(properties, n, null);
        if (mHREmployee.get_ID() == n) {
            employeeCache.put(n, mHREmployee);
        } else {
            mHREmployee = null;
        }
        return mHREmployee;
    }

    @Deprecated
    public static MHREmployee get(Properties properties, int n) {
        return MHREmployee.getById(properties, n);
    }

    public static MBPartner[] getEmployees(MHRProcess mHRProcess) {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("EXISTS(SELECT 1 FROM HR_Employee e WHERE e.C_BPartner_ID = C_BPartner.C_BPartner_ID AND (e.EmployeeStatus = ? OR EmployeeStatus IS NULL) ");
        arrayList.add("13");
        MHRPayroll mHRPayroll = MHRPayroll.getById(mHRProcess.getCtx(), mHRProcess.getHR_Payroll_ID(), mHRProcess.get_TrxName());
        if (mHRProcess.getHR_Payroll_ID() != 0 && mHRProcess.getHR_Period_ID() != 0 && !mHRPayroll.isIgnoreDefaultPayroll()) {
            stringBuffer.append(" AND (e.HR_Payroll_ID IS NULL OR e.HR_Payroll_ID=?) ");
            arrayList.add(mHRProcess.getHR_Payroll_ID());
        }
        stringBuffer.append(" AND e.IsActive = 'Y' ");
        if (mHRProcess.getHR_Period_ID() == 0) {
            stringBuffer.append(" AND e.StartDate <=? ");
            arrayList.add(mHRProcess.getDateAcct());
        } else {
            object = new MHRPeriod(mHRProcess.getCtx(), mHRProcess.getHR_Period_ID(), mHRProcess.get_TrxName());
            stringBuffer.append(" AND e.StartDate <=? ");
            arrayList.add(((X_HR_Period)object).getEndDate());
            stringBuffer.append(" AND (e.EndDate IS NULL OR e.EndDate >=?) ");
            arrayList.add(((X_HR_Period)object).getStartDate());
        }
        if (mHRProcess.getHR_Department_ID() != 0) {
            stringBuffer.append(" AND e.HR_Department_ID =? ");
            arrayList.add(mHRProcess.getHR_Department_ID());
        }
        if (mHRProcess.getHR_Job_ID() != 0) {
            stringBuffer.append(" AND e.HR_Job_ID =? ");
            arrayList.add(mHRProcess.getHR_Job_ID());
        }
        stringBuffer.append(" ) ");
        if (mHRProcess.getC_BPartner_ID() != 0) {
            stringBuffer.append(" AND C_BPartner_ID =? ");
            arrayList.add(mHRProcess.getC_BPartner_ID());
        }
        stringBuffer.append(" AND AD_Client_ID =? ");
        arrayList.add(mHRProcess.getAD_Client_ID());
        object = new Query(mHRProcess.getCtx(), "C_BPartner", stringBuffer.toString(), mHRProcess.get_TrxName()).setParameters(arrayList).setOnlyActiveRecords(true).setOrderBy("Name").list();
        return object.toArray(new MBPartner[object.size()]);
    }

    public static MHREmployee getActiveEmployee(Properties properties, int n, String string) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(n);
        arrayList.add("13");
        return (MHREmployee)new Query(properties, "HR_Employee", "C_BPartner_ID=? AND (EmployeeStatus = ? OR EmployeeStatus IS NULL)", string).setOnlyActiveRecords(true).setParameters(arrayList).setOrderBy("StartDate DESC").first();
    }

    public MHREmployee(Properties properties, int n, String string) {
        super(properties, n, string);
        if (n == 0) {
            this.setClientOrg(Env.getAD_Client_ID(Env.getCtx()), Env.getAD_Org_ID(Env.getCtx()));
        }
    }

    public MHREmployee(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    public MHREmployee(X_I_HR_Employee x_I_HR_Employee) {
        super(x_I_HR_Employee.getCtx(), 0, x_I_HR_Employee.get_TrxName());
        this.updateEmployeeData(x_I_HR_Employee);
    }

    public MHREmployee updateEmployeeData(X_I_HR_Employee x_I_HR_Employee) {
        this.setC_BPartner_ID(x_I_HR_Employee.getC_BPartner_ID());
        this.setAD_Org_ID(x_I_HR_Employee.getAD_Org_ID());
        this.setAD_User_ID(x_I_HR_Employee.getAD_User_ID());
        this.setName(x_I_HR_Employee.getName());
        this.setName2(x_I_HR_Employee.getName2());
        this.setNationalCode(x_I_HR_Employee.getNationalCode());
        this.setSSCode(x_I_HR_Employee.getSSCode());
        this.setNationality_ID(x_I_HR_Employee.getNationality_ID());
        this.setHR_Race_ID(x_I_HR_Employee.getHR_Race_ID());
        this.setIdentificationMark(x_I_HR_Employee.getIdentificationMark());
        this.setMaritalStatus(x_I_HR_Employee.getMaritalStatus());
        this.setMarriageAnniversaryDate(x_I_HR_Employee.getMarriageAnniversaryDate());
        this.setPartnersBirthDate(x_I_HR_Employee.getPartnersBirthDate());
        this.setCode(x_I_HR_Employee.getCode());
        this.setIsManager(x_I_HR_Employee.isManager());
        this.setHR_Payroll_ID(x_I_HR_Employee.getHR_Payroll_ID());
        this.setPaymentRule(x_I_HR_Employee.getPaymentRule());
        this.setHR_Department_ID(x_I_HR_Employee.getHR_Department_ID());
        this.setC_Activity_ID(x_I_HR_Employee.getC_Activity_ID());
        this.setC_Project_ID(x_I_HR_Employee.getC_Project_ID());
        this.setC_Campaign_ID(x_I_HR_Employee.getC_Campaign_ID());
        this.setC_SalesRegion_ID(x_I_HR_Employee.getC_SalesRegion_ID());
        this.setHR_Job_ID(x_I_HR_Employee.getHR_Job_ID());
        this.setHR_WorkGroup_ID(x_I_HR_Employee.getHR_WorkGroup_ID());
        this.setHR_ShiftGroup_ID(x_I_HR_Employee.getHR_ShiftGroup_ID());
        this.setHR_Degree_ID(x_I_HR_Employee.getHR_Degree_ID());
        this.setHR_Grade_ID(x_I_HR_Employee.getHR_Grade_ID());
        this.setHR_JobType_ID(x_I_HR_Employee.getHR_JobType_ID());
        this.setHR_JobEducation_ID(x_I_HR_Employee.getHR_JobEducation_ID());
        this.setHR_CareerLevel_ID(x_I_HR_Employee.getHR_CareerLevel_ID());
        this.setHR_Designation_ID(x_I_HR_Employee.getHR_Designation_ID());
        this.setHR_SalaryStructure_ID(x_I_HR_Employee.getHR_SalaryStructure_ID());
        this.setHR_SalaryRange_ID(x_I_HR_Employee.getHR_SalaryRange_ID());
        this.setMonthlySalary(x_I_HR_Employee.getMonthlySalary());
        this.setDailySalary(x_I_HR_Employee.getDailySalary());
        this.setStartDate(x_I_HR_Employee.getStartDate());
        this.setEndDate(x_I_HR_Employee.getEndDate());
        this.setHR_EmployeeType_ID(x_I_HR_Employee.getHR_EmployeeType_ID());
        this.setHR_SkillType_ID(x_I_HR_Employee.getHR_SkillType_ID());
        this.setEmployeeStatus(x_I_HR_Employee.getEmployeeStatus());
        this.setEmployeeImage_ID(x_I_HR_Employee.getEmployeeImage_ID());
        this.setLogo_ID(x_I_HR_Employee.getLogo_ID());
        this.setThumbImage_ID(x_I_HR_Employee.getThumbImage_ID());
        this.setImageURL(x_I_HR_Employee.getImageURL());
        return this;
    }
}

