/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MCurrency;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.eevolution.model.I_HR_Concept;
import org.eevolution.model.MHRConcept;
import org.eevolution.model.MHREmployee;
import org.eevolution.model.MHRPeriod;
import org.eevolution.model.MHRProcess;
import org.eevolution.model.X_HR_Movement;
import org.eevolution.model.X_I_HR_Movement;

public class MHRMovement
extends X_HR_Movement {
    private static final long serialVersionUID = 9100478676337821603L;

    public static List<MHRMovement> findByProcessAndConceptValueAndPartnerId(MHRProcess mHRProcess, String string, int n) {
        return MHRMovement.findByProcessAndConceptValueAndPartnerId(mHRProcess, string, n, null, null);
    }

    public static List<MHRMovement> findByProcessAndConceptValueAndPartnerId(MHRProcess mHRProcess, String string, int n, String string2, String string3) {
        ArrayList<MHRMovement> arrayList = new ArrayList<MHRMovement>();
        MHRConcept mHRConcept = MHRConcept.getByValue(mHRProcess.getCtx(), string, mHRProcess.get_TrxName());
        if (mHRConcept == null) {
            return arrayList;
        }
        return MHRMovement.findByProcessAndConceptIdAndPartnerId(mHRProcess, mHRConcept.getHR_Concept_ID(), n, string2, string3);
    }

    public static List<MHRMovement> findByProcessAndConceptIdAndPartnerId(MHRProcess mHRProcess, int n, int n2, String string, String string2) {
        List<MHRMovement> list = new ArrayList<MHRMovement>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (n < 0) {
            return list;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("HR_Process_ID").append("=? AND ");
        arrayList.add(mHRProcess.getHR_Process_ID());
        stringBuilder.append("HR_Concept_ID").append("=? AND ");
        arrayList.add(n);
        stringBuilder.append("C_BPartner_ID").append("=?");
        arrayList.add(n2);
        if (string != null && string.length() > 0) {
            stringBuilder.append(" AND ").append("ReferenceNo").append("=?");
            arrayList.add(string);
        }
        if (string2 != null && string2.length() > 0) {
            stringBuilder.append(" AND ").append("Description").append("=?");
            arrayList.add(string2);
        }
        list = new Query(mHRProcess.getCtx(), "HR_Movement", stringBuilder.toString(), mHRProcess.get_TrxName()).setClient_ID().setParameters(arrayList).list();
        return list;
    }

    public static List<MHRMovement> findByConceptValueAndPartnerId(Properties properties, String string, Integer n, String string2, String string3, String string4) {
        return MHRMovement.findByConceptValueAndPartnerId(properties, string, n, string2, string3, null, null, string4);
    }

    public static List<MHRMovement> findByConceptValueAndPartnerId(Properties properties, String string, Integer n, String string2, String string3, Timestamp timestamp, Timestamp timestamp2, String string4) {
        List<MHRMovement> list = new ArrayList<MHRMovement>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (string == null) {
            return list;
        }
        MHRConcept mHRConcept = MHRConcept.getByValue(properties, string, string4);
        if (mHRConcept == null) {
            return list;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("HR_Concept_ID").append("=?");
        arrayList.add(mHRConcept.getHR_Concept_ID());
        if (n > 0) {
            stringBuilder.append(" AND ").append("C_BPartner_ID").append("=?");
            arrayList.add(n);
        }
        if (string2 != null && string2.length() > 0) {
            stringBuilder.append(" AND ").append("ReferenceNo").append("=?");
            arrayList.add(string2);
        }
        if (string3 != null && string3.length() > 0) {
            stringBuilder.append(" AND ").append("Description").append("=?");
            arrayList.add(string3);
        }
        if (timestamp != null) {
            stringBuilder.append(" AND ").append("ValidFrom").append("=>?");
            arrayList.add(timestamp);
        }
        if (timestamp2 != null) {
            stringBuilder.append(" AND ").append("ValidTo").append("<=?");
            arrayList.add(timestamp2);
        }
        list = new Query(properties, "HR_Movement", stringBuilder.toString(), string4).setClient_ID().setParameters(arrayList).list();
        return list;
    }

    public static double getConceptSum(Properties properties, String string, int n, int n2, Timestamp timestamp, Timestamp timestamp2, String string2) {
        return MHRMovement.getConceptSum(properties, string, n, n2, timestamp, timestamp2, false, string2);
    }

    public static double getConceptSum(Properties properties, String string, int n, int n2, Timestamp timestamp, Timestamp timestamp2, boolean bl, String string2) {
        String string3;
        MHRConcept mHRConcept = MHRConcept.getByValue(properties, string, string2);
        if (mHRConcept == null) {
            return 0.0;
        }
        if ("Q".equals(mHRConcept.getColumnType())) {
            string3 = "Qty";
        } else if ("A".equals(mHRConcept.getColumnType())) {
            string3 = "Amount";
        } else {
            return 0.0;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("HR_Concept_ID=?");
        arrayList.add(mHRConcept.get_ID());
        stringBuffer.append(" AND C_BPartner_ID=?");
        arrayList.add(n2);
        stringBuffer.append(" AND validTo BETWEEN ? AND ?");
        arrayList.add(timestamp);
        arrayList.add(timestamp2);
        stringBuffer.append(" AND EXISTS (SELECT 1 FROM HR_Process p WHERE HR_Movement.HR_Process_ID = p.HR_Process_ID AND " + (bl ? "p.DocStatus IN('DR','IP', 'CO', 'CL')" : "p.DocStatus IN('CO', 'CL')") + " AND p.HR_Payroll_ID=?");
        arrayList.add(n);
        stringBuffer.append(")");
        StringBuffer stringBuffer2 = new StringBuffer("SELECT COALESCE(SUM(").append(string3).append("),0) FROM ").append("HR_Movement").append(" WHERE ").append(stringBuffer);
        BigDecimal bigDecimal = DB.getSQLValueBDEx(null, stringBuffer2.toString(), arrayList);
        return bigDecimal.doubleValue();
    }

    public static double getConceptAvg(Properties properties, String string, int n, int n2, Timestamp timestamp, Timestamp timestamp2, String string2) {
        return MHRMovement.getConceptAvg(properties, string, n, n2, timestamp, timestamp2, true, string2);
    }

    public static double getConceptAvg(Properties properties, String string, int n, int n2, Timestamp timestamp, Timestamp timestamp2, boolean bl, String string2) {
        String string3;
        MHRConcept mHRConcept = MHRConcept.getByValue(properties, string, string2);
        if (mHRConcept == null) {
            return 0.0;
        }
        if ("Q".equals(mHRConcept.getColumnType())) {
            string3 = "Qty";
        } else if ("A".equals(mHRConcept.getColumnType())) {
            string3 = "Amount";
        } else {
            return 0.0;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("HR_Concept_ID=?");
        arrayList.add(mHRConcept.get_ID());
        stringBuffer.append(" AND C_BPartner_ID=?");
        arrayList.add(n2);
        stringBuffer.append(" AND validTo BETWEEN ? AND ?");
        arrayList.add(timestamp);
        arrayList.add(timestamp2);
        stringBuffer.append(" AND EXISTS (SELECT 1 FROM HR_Process p WHERE HR_Movement.HR_Process_ID = p.HR_Process_ID AND " + (bl ? "p.DocStatus IN('DR', 'IP', 'CO', 'CL')" : "p.DocStatus IN('CO', 'CL')") + " AND p.HR_Payroll_ID=?");
        arrayList.add(n);
        stringBuffer.append(")");
        StringBuffer stringBuffer2 = new StringBuffer("SELECT COALESCE(AVG(").append(string3).append("),0) FROM ").append("HR_Movement").append(" WHERE ").append(stringBuffer);
        BigDecimal bigDecimal = DB.getSQLValueBDEx(null, stringBuffer2.toString(), arrayList);
        return bigDecimal.doubleValue();
    }

    public static double getConceptSum(Properties properties, String string, int n, int n2, int n3, int n4, int n5, String string2) {
        return MHRMovement.getConceptSum(properties, string, n, n2, n3, n4, n5, true, string2);
    }

    public static double getConceptSum(Properties properties, String string, int n, int n2, int n3, int n4, int n5, boolean bl, String string2) {
        String string3;
        MHRConcept mHRConcept = MHRConcept.getByValue(properties, string, string2);
        if (mHRConcept == null) {
            return 0.0;
        }
        if ("Q".equals(mHRConcept.getColumnType())) {
            string3 = "Qty";
        } else if ("A".equals(mHRConcept.getColumnType())) {
            string3 = "Amount";
        } else {
            return 0.0;
        }
        MHRPeriod mHRPeriod = MHRPeriod.getById(properties, n3, string2);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("HR_Concept_ID=?");
        arrayList.add(mHRConcept.get_ID());
        stringBuffer.append(" AND C_BPartner_ID=?");
        arrayList.add(n2);
        stringBuffer.append(" AND EXISTS (SELECT 1 FROM HR_Process p INNER JOIN HR_Period pr ON (pr.HR_Period_id=p.HR_Period_ID) WHERE HR_Movement.HR_Process_ID = p.HR_Process_ID AND " + (bl ? "p.DocStatus IN('DR', 'IP', 'CO', 'CL')" : "p.DocStatus IN('CO', 'CL')") + " AND p.HR_Payroll_ID=?");
        arrayList.add(n);
        if (n4 < 0) {
            stringBuffer.append(" AND pr.PeriodNo >= ?");
            arrayList.add(mHRPeriod.getPeriodNo() + n4);
        }
        if (n5 > 0) {
            stringBuffer.append(" AND pr.PeriodNo <= ?");
            arrayList.add(mHRPeriod.getPeriodNo() + n5);
        }
        stringBuffer.append(")");
        StringBuffer stringBuffer2 = new StringBuffer("SELECT COALESCE(SUM(").append(string3).append("),0) FROM ").append("HR_Movement").append(" WHERE ").append(stringBuffer);
        BigDecimal bigDecimal = DB.getSQLValueBDEx(null, stringBuffer2.toString(), arrayList);
        return bigDecimal.doubleValue();
    }

    public static MHRMovement getLastMovement(Properties properties, String string, int n, int n2, Timestamp timestamp, String string2) {
        MHRConcept mHRConcept = MHRConcept.getByValue(properties, string, string2);
        if (mHRConcept == null) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("HR_Concept_ID=?");
        arrayList.add(mHRConcept.get_ID());
        stringBuffer.append(" AND C_BPartner_ID=?");
        arrayList.add(n2);
        stringBuffer.append(" AND validTo <= ?");
        arrayList.add(timestamp);
        stringBuffer.append(" AND EXISTS (SELECT 1 FROM HR_Process p WHERE HR_Movement.HR_Process_ID = p.HR_Process_ID AND p.DocStatus IN('CO', 'CL') AND p.HR_Payroll_ID=?");
        arrayList.add(n);
        stringBuffer.append(")");
        return (MHRMovement)new Query(properties, "HR_Movement", stringBuffer.toString(), string2).setParameters(arrayList).setOrderBy("ValidFrom DESC").first();
    }

    public static double getLastConcept(Properties properties, String string, int n, int n2, Timestamp timestamp, String string2) {
        MHRConcept mHRConcept = MHRConcept.getByValue(properties, string, string2);
        if (mHRConcept == null) {
            return 0.0;
        }
        if (!"Q".equals(mHRConcept.getColumnType()) && !"A".equals(mHRConcept.getColumnType())) {
            return 0.0;
        }
        MHRMovement mHRMovement = MHRMovement.getLastMovement(properties, string, n, n2, timestamp, string2);
        if (mHRMovement == null) {
            return 0.0;
        }
        if ("Q".equals(mHRConcept.getColumnType())) {
            if (mHRMovement.getQty() != null) {
                return mHRMovement.getQty().doubleValue();
            }
        } else if ("A".equals(mHRConcept.getColumnType()) && mHRMovement.getAmount() != null) {
            return mHRMovement.getAmount().doubleValue();
        }
        return 0.0;
    }

    public static Timestamp getLastConceptDate(Properties properties, String string, int n, int n2, Timestamp timestamp, String string2) {
        MHRConcept mHRConcept = MHRConcept.getByValue(properties, string, string2);
        if (mHRConcept == null) {
            return null;
        }
        if (!"D".equals(mHRConcept.getColumnType())) {
            return null;
        }
        MHRMovement mHRMovement = MHRMovement.getLastMovement(properties, string, n, n2, timestamp, string2);
        if (mHRMovement == null) {
            return null;
        }
        return mHRMovement.getServiceDate();
    }

    public static double getConceptAvg(Properties properties, String string, int n, int n2, int n3, int n4, int n5, String string2) {
        return MHRMovement.getConceptAvg(properties, string, n, n2, n3, n4, n5, true, string2);
    }

    public static double getConceptAvg(Properties properties, String string, int n, int n2, int n3, int n4, int n5, boolean bl, String string2) {
        String string3;
        MHRConcept mHRConcept = MHRConcept.getByValue(properties, string, string2);
        if (mHRConcept == null) {
            return 0.0;
        }
        if ("Q".equals(mHRConcept.getColumnType())) {
            string3 = "Qty";
        } else if ("A".equals(mHRConcept.getColumnType())) {
            string3 = "Amount";
        } else {
            return 0.0;
        }
        MHRPeriod mHRPeriod = MHRPeriod.getById(properties, n3, string2);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("HR_Concept_ID=?");
        arrayList.add(mHRConcept.get_ID());
        stringBuffer.append(" AND C_BPartner_ID=?");
        arrayList.add(n2);
        stringBuffer.append(" AND EXISTS (SELECT 1 FROM HR_Process p INNER JOIN HR_Period pr ON (pr.HR_Period_id=p.HR_Period_ID) WHERE HR_Movement.HR_Process_ID = p.HR_Process_ID AND " + (bl ? "p.DocStatus IN('DR', 'IP', 'CO', 'CL')" : "p.DocStatus IN('CO', 'CL')") + " AND p.HR_Payroll_ID=?");
        arrayList.add(n);
        if (n4 < 0) {
            stringBuffer.append(" AND pr.PeriodNo >= ?");
            arrayList.add(mHRPeriod.getPeriodNo() + n4);
        }
        if (n5 > 0) {
            stringBuffer.append(" AND pr.PeriodNo <= ?");
            arrayList.add(mHRPeriod.getPeriodNo() + n5);
        }
        stringBuffer.append(")");
        StringBuffer stringBuffer2 = new StringBuffer("SELECT COALESCE(AVG(").append(string3).append("),0) FROM ").append("HR_Movement").append(" WHERE ").append(stringBuffer);
        BigDecimal bigDecimal = DB.getSQLValueBDEx(null, stringBuffer2.toString(), arrayList);
        return bigDecimal.doubleValue();
    }

    public static List<MHRMovement> findByProcess(MHRProcess mHRProcess) {
        return new Query(mHRProcess.getCtx(), "HR_Movement", "HR_Process_ID=?", mHRProcess.get_TrxName()).setClient_ID().setParameters(mHRProcess.getHR_Process_ID()).list();
    }

    public MHRMovement(Properties properties, int n, String string) {
        super(properties, n, string);
    }

    public MHRMovement(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    public MHRMovement(X_I_HR_Movement x_I_HR_Movement) {
        this(x_I_HR_Movement.getCtx(), 0, x_I_HR_Movement.get_TrxName());
        MHRConcept mHRConcept = new MHRConcept(this.getCtx(), x_I_HR_Movement.getHR_Concept_ID(), this.get_TrxName());
        MHREmployee mHREmployee = MHREmployee.getActiveEmployee(this.getCtx(), x_I_HR_Movement.getC_BPartner_ID(), this.get_TrxName());
        this.setAD_Org_ID(mHREmployee.getAD_Org_ID());
        this.setUpdatedBy(x_I_HR_Movement.getUpdatedBy());
        this.setHR_Process_ID(x_I_HR_Movement.getHR_Process_ID());
        this.setC_BPartner_ID(x_I_HR_Movement.getC_BPartner_ID());
        this.setHR_Concept_ID(x_I_HR_Movement.getHR_Concept_ID());
        this.setHR_Concept_Category_ID(mHRConcept.getHR_Concept_Category_ID());
        this.setDescription(x_I_HR_Movement.getDescription());
        this.setHR_Job_ID(mHREmployee.getHR_Job_ID());
        this.setHR_Department_ID(mHREmployee.getHR_Department_ID());
        this.setC_Activity_ID(mHREmployee.getC_Activity_ID());
        this.setValidFrom(x_I_HR_Movement.getValidFrom());
        this.setValidTo(x_I_HR_Movement.getValidTo());
        this.setIsManual(mHRConcept.isManual());
        this.setIsPrinted(mHRConcept.isPrinted());
        this.setAmount(null);
        this.setQty(null);
        this.setServiceDate(null);
        this.setTextMsg(null);
        if (mHRConcept.getColumnType().equals("Q")) {
            this.setQty(x_I_HR_Movement.getQty());
        } else if (mHRConcept.getColumnType().equals("A")) {
            this.setAmount(x_I_HR_Movement.getAmount());
        } else if (mHRConcept.getColumnType().equals("D")) {
            this.setServiceDate(x_I_HR_Movement.getServiceDate());
        } else if (mHRConcept.getColumnType().equals("T")) {
            this.setTextMsg(x_I_HR_Movement.getTextMsg());
        }
    }

    public MHRMovement(MHRProcess mHRProcess, I_HR_Concept i_HR_Concept) {
        this(mHRProcess.getCtx(), 0, mHRProcess.get_TrxName());
        this.setSeqNo(i_HR_Concept.getSeqNo());
        this.setHR_Process_ID(mHRProcess.getHR_Process_ID());
        this.setHR_Payroll_ID(mHRProcess.getHR_Payroll_ID());
        this.setHR_Concept_Category_ID(i_HR_Concept.getHR_Concept_Category_ID());
        this.setHR_Concept_ID(i_HR_Concept.getHR_Concept_ID());
    }

    public void addAmount(BigDecimal bigDecimal) {
        this.setAmount(this.getAmount().add(bigDecimal == null ? Env.ZERO : bigDecimal));
    }

    public void addQty(BigDecimal bigDecimal) {
        this.setQty(this.getAmount().add(bigDecimal == null ? Env.ZERO : bigDecimal));
    }

    public boolean isEmpty() {
        return this.getQty().signum() == 0 && this.getAmount().signum() == 0 && Util.isEmpty(this.getTextMsg()) && this.getServiceDate() == null;
    }

    public void setColumnValue(Object object) {
        block10: {
            if (object == null) {
                return;
            }
            try {
                MHRConcept mHRConcept = MHRConcept.getById(this.getCtx(), this.getHR_Concept_ID(), this.get_TrxName());
                if (mHRConcept == null) {
                    throw new AdempiereException("@HR_Concept_ID@ @NotFound@");
                }
                String string = mHRConcept.getColumnType();
                int n = MCurrency.getStdPrecision(this.getCtx(), Env.getContextAsInt(this.p_ctx, "#C_Currency_ID"));
                Optional<Integer> optional = Optional.ofNullable((Integer)mHRConcept.get_Value("StdPrecision"));
                if ("Q".equals(string)) {
                    BigDecimal bigDecimal = new BigDecimal(object.toString());
                    this.setQty(bigDecimal);
                    this.setAmount(Env.ZERO);
                    break block10;
                }
                if ("A".equals(string)) {
                    BigDecimal bigDecimal = new BigDecimal(object.toString()).setScale((int)optional.orElse(n), 4);
                    this.setAmount(bigDecimal);
                    this.setQty(Env.ZERO);
                    break block10;
                }
                if ("T".equals(string)) {
                    this.setTextMsg(object.toString().trim());
                    break block10;
                }
                if ("D".equals(string)) {
                    if (object instanceof Timestamp) {
                        this.setServiceDate((Timestamp)object);
                    } else {
                        this.setServiceDate(Timestamp.valueOf(object.toString().trim().substring(0, 10) + " 00:00:00.0"));
                    }
                    break block10;
                }
                throw new AdempiereException("@NotSupported@ @ColumnType@ - " + string);
            }
            catch (Exception exception) {
                throw new AdempiereException("@Script Error@");
            }
        }
    }

    @Override
    protected boolean beforeSave(boolean bl) {
        MHREmployee mHREmployee = MHREmployee.getActiveEmployee(Env.getCtx(), this.getC_BPartner_ID(), this.get_TrxName());
        if (mHREmployee != null) {
            this.setAD_Org_ID(mHREmployee.getAD_Org_ID());
        }
        return true;
    }

    public void setEmployee(MHREmployee mHREmployee) {
        this.setAD_Org_ID(mHREmployee.getAD_Org_ID());
        this.setHR_Department_ID(mHREmployee.getHR_Department_ID());
        this.setHR_Job_ID(mHREmployee.getHR_Job_ID());
        this.setC_Activity_ID(mHREmployee.getC_Activity_ID() > 0 ? mHREmployee.getC_Activity_ID() : mHREmployee.getHR_Department().getC_Activity_ID());
        this.setHR_Employee_ID(mHREmployee.getHR_Employee_ID());
        this.setHR_EmployeeType_ID(mHREmployee.getHR_EmployeeType_ID());
        this.setHR_SkillType_ID(mHREmployee.getHR_SkillType_ID());
        this.setHR_Payroll_ID(mHREmployee.getHR_Payroll_ID());
        this.setC_Project_ID(mHREmployee.getC_Project_ID());
        if (mHREmployee.getHR_Payroll_ID() > 0) {
            this.setHR_Contract_ID(mHREmployee.getHR_Payroll().getHR_Contract_ID());
        }
    }
}

