/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.compiere.model.I_C_OrderLine;
import org.compiere.model.MOrder;
import org.compiere.model.MRequisition;
import org.compiere.model.MRequisitionLine;
import org.compiere.process.ProcessInfo;
import org.compiere.process.RequisitionPOCreate;
import org.eevolution.process.CreatePOFromRequisitionLinesAbstract;
import org.eevolution.service.dsl.ProcessBuilder;

public class CreatePOFromRequisitionLines
extends CreatePOFromRequisitionLinesAbstract {
    List<Integer> purchaseOrderIds = new ArrayList<Integer>();

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        this.getSelectionKeys().stream().forEach(requisitionLineId -> {
            MRequisitionLine requisitionLine = new MRequisitionLine(this.getCtx(), (int)requisitionLineId, this.get_TrxName());
            if (this.getPriceListId() > 0) {
                MRequisition requisition = (MRequisition)requisitionLine.getM_Requisition();
                requisition.setM_PriceList_ID(this.getPriceListId());
                requisition.saveEx();
            }
            if (this.getBPartnerId() > 0) {
                requisitionLine.setC_BPartner_ID(this.getBPartnerId());
                requisitionLine.saveEx();
            }
        });
        ProcessInfo createPORequisition = ProcessBuilder.create(this.getCtx()).process(RequisitionPOCreate.getProcessId()).withTitle(RequisitionPOCreate.getProcessName()).withSelectedRecordsIds(MRequisitionLine.Table_ID, this.getSelectionKeys()).withParameter("ConsolidateDocument", this.isConsolidateDocument()).withoutTransactionClose().execute(this.get_TrxName());
        this.addLog(createPORequisition.getLogInfo());
        if (createPORequisition.isError()) {
            return "@Error@ " + createPORequisition.getLogInfo();
        }
        this.getSelectionKeys().stream().forEach(requisitionLineId -> {
            I_C_OrderLine orderLine;
            MRequisitionLine requisitionLine = new MRequisitionLine(this.getCtx(), (int)requisitionLineId, this.get_TrxName());
            if (requisitionLine.getC_OrderLine_ID() > 0 && !this.purchaseOrderIds.contains((orderLine = requisitionLine.getC_OrderLine()).getC_Order_ID())) {
                this.purchaseOrderIds.add(orderLine.getC_Order_ID());
            }
        });
        this.purchaseOrderIds.stream().forEach(purchaseOrderId -> {
            MOrder purchaseOrder = new MOrder(this.getCtx(), (int)purchaseOrderId, this.get_TrxName());
            Optional.ofNullable(this.getDateOrdered()).ifPresent(ordered -> purchaseOrder.setDateOrdered((Timestamp)ordered));
            Optional.ofNullable(this.getDatePromised()).ifPresent(promised -> purchaseOrder.setDatePromised((Timestamp)promised));
            Optional.ofNullable(this.getPriorityRule()).ifPresent(priority -> purchaseOrder.setPriorityRule((String)priority));
            Optional.ofNullable(this.getPOReference()).ifPresent(POReference -> purchaseOrder.setPOReference((String)POReference));
            if (this.getBPartnerLocationId() > 0) {
                purchaseOrder.setC_BPartner_Location_ID(this.getBPartnerLocationId());
            }
            if (this.getPaymentTermId() > 0) {
                purchaseOrder.setC_PaymentTerm_ID(this.getPaymentTermId());
            }
            if (this.getSalesRepId() > 0) {
                purchaseOrder.setSalesRep_ID(this.getSalesRepId());
            }
            purchaseOrder.saveEx();
            if ("PR".equals(this.getDocAction()) || "CO".equals(this.getDocAction()) || "AP".equals(this.getDocAction())) {
                purchaseOrder.processIt(this.getDocAction());
                purchaseOrder.saveEx();
            }
        });
        return "@Ok@ " + this.getProcessInfo().getLogInfo();
    }
}

