/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.adempiere.engine.CostEngineFactory;
import org.adempiere.engine.CostingMethodFactory;
import org.adempiere.engine.IDocumentLine;
import org.adempiere.engine.StandardCostingMethod;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCostDetail;
import org.compiere.model.MCostElement;
import org.compiere.model.MCostType;
import org.compiere.model.MInOutLine;
import org.compiere.model.MLandedCostAllocation;
import org.compiere.model.MMatchInv;
import org.compiere.model.MMatchPO;
import org.compiere.model.MTransaction;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Trx;
import org.eevolution.model.MPPCostCollector;
import org.eevolution.process.GenerateCostDetailAbstract;

public class GenerateCostDetail
extends GenerateCostDetailAbstract {
    private ArrayList<Object> deleteParameters;
    private ArrayList<Object> resetCostParameters;
    private List<MAcctSchema> acctSchemas = new ArrayList<MAcctSchema>();
    private List<MCostType> costTypes = new ArrayList<MCostType>();
    private List<MCostElement> costElements = new ArrayList<MCostElement>();
    private StringBuffer deleteCostDetailWhereClause;
    private StringBuffer resetCostWhereClause;

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getDateAcct() != null) {
            this.setup();
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.generateCostDetail();
        return "@Ok@";
    }

    private void deleteCostDetail(String trxName) throws SQLException {
        StringBuffer sqlDelete = new StringBuffer("DELETE FROM M_CostDetail WHERE ");
        sqlDelete.append(this.deleteCostDetailWhereClause);
        DB.executeUpdateEx(sqlDelete.toString(), this.deleteParameters.toArray(), trxName);
    }

    private void resetCostDimension(String costingMethod, String trxName) throws SQLException {
        StringBuffer sqlReset = new StringBuffer("UPDATE M_Cost SET ");
        if ("I".equals(costingMethod)) {
            sqlReset.append("CurrentCostPrice").append("=0.0,");
            sqlReset.append("CurrentCostPriceLL").append("= 0.0,");
        }
        sqlReset.append("CurrentQty").append("= 0.0,");
        sqlReset.append("CumulatedAmt").append("= 0.0,");
        sqlReset.append("CumulatedAmtLL").append("= 0.0,");
        sqlReset.append("CumulatedQty").append("= 0.0 ");
        sqlReset.append(" WHERE ").append(this.resetCostWhereClause);
        DB.executeUpdateEx(sqlReset.toString(), this.resetCostParameters.toArray(), trxName);
    }

    private void setup() {
        if (this.getAcctSchemaId() > 0) {
            this.acctSchemas.add(MAcctSchema.get(this.getCtx(), this.getAcctSchemaId(), this.get_TrxName()));
        } else {
            this.acctSchemas = new ArrayList<MAcctSchema>(Arrays.asList(MAcctSchema.getClientAcctSchema(this.getCtx(), this.getAD_Client_ID(), this.get_TrxName())));
        }
        if (this.getCostTypeId() > 0) {
            this.costTypes.add(new MCostType(this.getCtx(), this.getCostTypeId(), this.get_TrxName()));
        } else {
            this.costTypes = MCostType.get(this.getCtx(), this.get_TrxName());
        }
        if (this.getCostElementId() > 0) {
            this.costElements.add(MCostElement.get(this.getCtx(), this.getCostElementId()));
        } else {
            this.costElements = MCostElement.getCostElement(this.getCtx(), this.get_TrxName());
        }
    }

    private void applyCriteria(int accountSchemaId, int costTypeId, int costElementId, int productId, Timestamp dateAccount, Timestamp dateAccountTo) {
        this.deleteParameters = new ArrayList();
        this.resetCostParameters = new ArrayList();
        this.deleteCostDetailWhereClause = new StringBuffer("1=1");
        this.resetCostWhereClause = new StringBuffer("1=1");
        if (accountSchemaId > 0) {
            this.deleteCostDetailWhereClause.append(" AND ").append("C_AcctSchema_ID").append("=? ");
            this.deleteParameters.add(accountSchemaId);
            this.resetCostWhereClause.append(" AND ").append("C_AcctSchema_ID").append("=? ");
            this.resetCostParameters.add(accountSchemaId);
        }
        if (costTypeId > 0) {
            this.deleteCostDetailWhereClause.append(" AND ").append("M_CostType_ID").append("=? ");
            this.deleteParameters.add(costTypeId);
            this.resetCostWhereClause.append(" AND ").append("M_CostType_ID").append("=? ");
            this.resetCostParameters.add(costTypeId);
        }
        if (costElementId > 0) {
            this.deleteCostDetailWhereClause.append(" AND ").append("M_CostElement_ID").append("=? ");
            this.deleteParameters.add(costElementId);
            this.resetCostWhereClause.append(" AND ").append("M_CostElement_ID").append("=? ");
            this.resetCostParameters.add(costElementId);
        }
        if (productId > 0) {
            this.deleteCostDetailWhereClause.append(" AND ").append("M_Product_ID").append("=? ");
            this.deleteParameters.add(productId);
            this.resetCostWhereClause.append(" AND ").append("M_Product_ID").append("=? ");
            this.resetCostParameters.add(productId);
        }
        if (dateAccount != null) {
            this.deleteCostDetailWhereClause.append(" AND ").append("DateAcct").append(">=? ");
            this.deleteParameters.add(dateAccount);
        }
        if (dateAccountTo != null) {
            this.deleteCostDetailWhereClause.append(" AND ").append("DateAcct").append("<=? ");
            this.deleteParameters.add(dateAccountTo);
        }
        this.resetCostWhereClause.append(" AND EXISTS ( SELECT 1 FROM RV_Transaction WHERE M_Product_ID=? AND TRUNC(DateAcct)>=? AND TRUNC(DateAcct)<=?)");
        this.resetCostParameters.add(productId);
        this.resetCostParameters.add(dateAccount);
        this.resetCostParameters.add(dateAccountTo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateCostDetail() {
        KeyNamePair[] transactions = this.getTransactionIdsByDateAcct();
        Integer process = 0;
        Integer productId = 0;
        Trx dbTransaction = null;
        try {
            for (KeyNamePair keyNamePair : transactions) {
                int transactionId = keyNamePair.getKey();
                int transactionProductId = new Integer(keyNamePair.getName());
                if (productId != transactionProductId) {
                    if (dbTransaction != null) {
                        dbTransaction.commit(true);
                        dbTransaction.close();
                    }
                    productId = transactionProductId;
                    dbTransaction = Trx.get(productId.toString(), true);
                    for (MAcctSchema accountSchema : this.acctSchemas) {
                        for (MCostType costType : this.costTypes) {
                            for (MCostElement costElement : this.costElements) {
                                this.applyCriteria(accountSchema.getC_AcctSchema_ID(), costType.getM_CostType_ID(), costElement.getM_CostElement_ID(), productId, this.getDateAcct(), this.getDateAcctTo());
                                this.deleteCostDetail(dbTransaction.getTrxName());
                                this.resetCostDimension(costType.getCostingMethod(), dbTransaction.getTrxName());
                                this.generateCostCollectorNotTransaction(accountSchema, costType, productId, dbTransaction.getTrxName());
                            }
                        }
                    }
                }
                MTransaction transaction = new MTransaction(this.getCtx(), transactionId, dbTransaction.getTrxName());
                for (MAcctSchema accountSchema : this.acctSchemas) {
                    for (MCostType costType : this.costTypes) {
                        for (MCostElement costElement : this.costElements) {
                            this.generateCostDetail(accountSchema, costType, costElement, transaction);
                        }
                    }
                }
                Integer n = process;
                process = process + 1;
                Integer n2 = process;
            }
            if (dbTransaction != null) {
                dbTransaction.commit(true);
                dbTransaction.close();
                dbTransaction = null;
            }
        }
        catch (Exception e) {
            if (dbTransaction != null) {
                dbTransaction.rollback();
                dbTransaction.close();
                dbTransaction = null;
                e.printStackTrace();
                this.addLog(e.getMessage());
            }
        }
        finally {
            if (dbTransaction != null) {
                dbTransaction.commit();
                dbTransaction.close();
                dbTransaction = null;
            }
        }
    }

    private boolean IsUsedInProduction(int productId, String trxName) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("M_Product_ID").append("=? AND ");
        whereClause.append("MovementType").append("=?");
        return new Query(this.getCtx(), "M_Transaction", whereClause.toString(), trxName).setClient_ID().setParameters(productId, "P+").match();
    }

    public void generateCostDetail(MAcctSchema accountSchema, MCostType costType, MCostElement costElement, MTransaction transaction) {
        CostEngineFactory.getCostEngine(accountSchema.getAD_Client_ID()).createCostDetail(accountSchema, costType, costElement, transaction, transaction.getDocumentLine(), true);
        CostEngineFactory.getCostEngine(accountSchema.getAD_Client_ID()).clearAccounting(accountSchema, transaction);
        if ("V+".equals(transaction.getMovementType())) {
            MInOutLine line = (MInOutLine)transaction.getDocumentLine();
            if ("M".equals(costElement.getCostElementType())) {
                List<MMatchPO> orderMatches = MMatchPO.getInOutLine(line);
                orderMatches.stream().forEach(match -> {
                    if (match.getM_Product_ID() == transaction.getM_Product_ID() && match.getDateAcct().after(this.getDateAcct()) && match.getDateAcct().before(this.getDateAcctTo())) {
                        CostEngineFactory.getCostEngine(accountSchema.getAD_Client_ID()).createCostDetail(accountSchema, costType, costElement, transaction, (IDocumentLine)match, true);
                    }
                });
                List<MMatchInv> invoiceMatches = MMatchInv.getInOutLine(line);
                invoiceMatches.forEach(match -> {
                    if (match.getM_Product_ID() == transaction.getM_Product_ID() && match.getDateAcct().after(this.getDateAcct()) && match.getDateAcct().before(this.getDateAcctTo())) {
                        CostEngineFactory.getCostEngine(accountSchema.getAD_Client_ID()).createCostDetail(accountSchema, costType, costElement, transaction, (IDocumentLine)match, true);
                    }
                });
            }
            MLandedCostAllocation.getOfInOutline(line, costElement.getM_CostElement_ID()).stream().forEach(allocation -> {
                if (allocation.getDateAcct().after(this.getDateAcct()) && allocation.getDateAcct().before(this.getDateAcctTo())) {
                    CostEngineFactory.getCostEngine(accountSchema.getAD_Client_ID()).createCostDetail(accountSchema, costType, costElement, transaction, (IDocumentLine)allocation, true);
                }
            });
        }
    }

    private void generateCostCollectorNotTransaction(MAcctSchema accountSchema, MCostType costType, int productId, String trxName) throws SQLException {
        List<MPPCostCollector> costCollectors = MPPCostCollector.getCostCollectorNotTransaction(this.getCtx(), productId, this.getDateAcct(), this.getDateAcctTo(), trxName);
        for (MPPCostCollector costCollector : costCollectors) {
            for (MCostDetail costDetail : MCostDetail.getByCollectorCost(costCollector)) {
                costDetail.deleteEx(true);
            }
            CostEngineFactory.getCostEngine(this.getAD_Client_ID()).clearAccounting(accountSchema, costType, costCollector, productId, costCollector.getDateAcct());
            StandardCostingMethod standardCostingMethod = (StandardCostingMethod)CostingMethodFactory.get().getCostingMethod("S");
            if ("120".equals(costCollector.getCostCollectorType())) {
                standardCostingMethod.createUsageVariances(costCollector);
                continue;
            }
            if ("130".equals(costCollector.getCostCollectorType())) {
                standardCostingMethod.createMethodVariances(costCollector);
                continue;
            }
            if ("140".equals(costCollector.getCostCollectorType())) {
                standardCostingMethod.createRateVariances(costCollector);
                continue;
            }
            if (!"160".equals(costCollector.getCostCollectorType())) continue;
            standardCostingMethod.createActivityControl(costCollector);
        }
    }

    private KeyNamePair[] getTransactionIdsByDateAcct() {
        StringBuilder sql = new StringBuilder();
        ArrayList<Comparable<Integer>> parameters = new ArrayList<Comparable<Integer>>();
        StringBuilder whereClause = new StringBuilder("WHERE ");
        whereClause.append("AD_Client_ID").append("=").append(this.getAD_Client_ID()).append(" AND ");
        if (this.getProductId() > 0) {
            whereClause.append("M_Product_ID").append("=?").append(" AND ");
            parameters.add(Integer.valueOf(this.getProductId()));
        }
        whereClause.append("TRUNC(").append("DateAcct").append(")>=?");
        parameters.add(this.getDateAcct());
        if (this.getDateAcctTo() != null) {
            whereClause.append(" AND TRUNC(").append("DateAcct").append(")<=?");
            parameters.add(this.getDateAcctTo());
        }
        sql.append("SELECT M_Transaction_ID , M_Product_ID FROM RV_Transaction ").append((CharSequence)whereClause).append(" ORDER BY lowlevel desc, M_Product_ID ,  TRUNC( DateAcct ) , M_Transaction_ID , SUBSTR(MovementType,2,1) ");
        return DB.getKeyNamePairs(this.get_TrxName(), sql.toString(), false, parameters.toArray());
    }
}

