/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.compiere.model.I_C_BPartner;
import org.compiere.model.Query;
import org.eevolution.model.MHREmployee;
import org.eevolution.model.MHRPaySelection;
import org.eevolution.model.MHRPaySelectionLine;
import org.eevolution.process.HRPaySelectionCreateFromAbstract;

public class HRPaySelectionCreateFrom
extends HRPaySelectionCreateFromAbstract {
    @Override
    protected void prepare() {
        super.prepare();
        this.getProcessInfo().setTable_ID(MHRPaySelection.Table_ID);
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("Pay Selection Id=" + this.getRecord_ID() + ", Process=" + this.getHRProcessId() + ", Payroll=" + this.getPayrollId() + ", BP Group=" + this.getBPGroupId() + ", PaymentRule=" + this.getPaymentRule() + ", Concept=" + this.getConceptId() + ", Depatment=" + this.getDepartmentId() + ", Job=" + this.getJobId());
        MHRPaySelection mHRPaySelection = (MHRPaySelection)this.getInstance(this.get_TrxName());
        mHRPaySelection.setHR_Process_ID(this.getHRProcessId());
        mHRPaySelection.saveEx();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.getRecord_ID() == 0) {
            throw new IllegalArgumentException("@HR_PaySelection_ID@ @Notfound@");
        }
        if (mHRPaySelection.isProcessed()) {
            throw new IllegalArgumentException("@HR_PaySelection_ID@ @Processed@");
        }
        arrayList.add(this.getHRProcessId());
        arrayList.add(true);
        arrayList.add(this.getRecord_ID());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("HR_Process_ID").append("=?");
        stringBuilder.append(" AND EXISTS(SELECT 1 FROM HR_Concept WHERE HR_Concept_ID = HR_Movement.HR_Concept_ID AND IsPaid=?)");
        stringBuilder.append(" AND NOT EXISTS(SELECT 1  FROM HR_PaySelectionLine  WHERE HR_Movement_ID = HR_Movement.HR_Movement_ID AND HR_PaySelectionCheck_ID > 0 OR HR_PaySelection_ID=?)");
        if (this.getBPGroupId() > 0) {
            stringBuilder.append(" AND ").append("C_BP_Group_ID").append("=?");
            arrayList.add(this.getBPGroupId());
        }
        if (this.getEmployeeTypeId() > 0) {
            stringBuilder.append(" AND ").append("HR_EmployeeType_ID").append("=?");
            arrayList.add(this.getEmployeeTypeId());
        }
        if (this.getBPartnerId() > 0) {
            stringBuilder.append(" AND ").append("C_BPartner_ID").append("=?");
            arrayList.add(this.getBPartnerId());
        }
        if (this.getPaymentRule() != null) {
            stringBuilder.append(" AND EXISTS(SELECT 1 FROM HR_Employee WHERE HR_Employee_ID = HR_Movement.HR_Employee_ID AND PaymentRule=?)");
            arrayList.add(this.getPaymentRule());
        }
        if (this.getConceptId() > 0) {
            stringBuilder.append(" AND ").append("HR_Concept_ID").append("=?");
            arrayList.add(this.getConceptId());
        }
        if (this.getDepartmentId() > 0) {
            stringBuilder.append(" AND ").append("HR_Department_ID").append("=?");
            arrayList.add(this.getDepartmentId());
        }
        if (this.getJobId() > 0) {
            stringBuilder.append(" AND ").append("HR_Job_ID").append("=?");
            arrayList.add(this.getJobId());
        }
        List list = new Query(this.getCtx(), "HR_Movement", stringBuilder.toString(), this.get_TrxName()).setClient_ID().setParameters(arrayList).list();
        AtomicInteger atomicInteger = new AtomicInteger();
        list.stream().filter(mHRMovement -> mHRMovement != null).forEach(mHRMovement -> {
            I_C_BPartner i_C_BPartner = mHRMovement.getC_BPartner();
            Optional<MHREmployee> optional = Optional.ofNullable(MHREmployee.getActiveEmployee(this.getCtx(), i_C_BPartner.getC_BPartner_ID(), mHRMovement.get_TrxName()));
            String string = optional.flatMap(mHREmployee -> Optional.ofNullable(mHREmployee.getPaymentRule())).orElse(Optional.ofNullable(i_C_BPartner.getPaymentRule()).orElse("T"));
            atomicInteger.updateAndGet(n -> n + 10);
            MHRPaySelectionLine mHRPaySelectionLine = new MHRPaySelectionLine(this.getCtx(), 0, this.get_TrxName());
            mHRPaySelectionLine.setHR_PaySelection_ID(this.getRecord_ID());
            mHRPaySelectionLine.setHR_Movement_ID(mHRMovement.getHR_Movement_ID());
            mHRPaySelectionLine.setPaymentRule(string);
            mHRPaySelectionLine.setAD_Org_ID(mHRPaySelection.getAD_Org_ID());
            mHRPaySelectionLine.setLine(atomicInteger.get());
            mHRPaySelectionLine.setOpenAmt(mHRMovement.getAmount().setScale(2, 5));
            mHRPaySelectionLine.setPayAmt(mHRMovement.getAmount().setScale(2, 5));
            mHRPaySelectionLine.setDescription(i_C_BPartner.getName() + " " + i_C_BPartner.getName2());
            mHRPaySelectionLine.setDifferenceAmt(BigDecimal.ZERO);
            mHRPaySelectionLine.setDiscountAmt(BigDecimal.ZERO);
            mHRPaySelectionLine.setIsManual(false);
            mHRPaySelectionLine.setIsSOTrx(false);
            mHRPaySelectionLine.setIsActive(true);
            mHRPaySelectionLine.saveEx();
        });
        return "@HR_PaySelection_ID@  - #" + atomicInteger.get();
    }
}

