/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.compiere.model.MActivity;
import org.compiere.model.MCampaign;
import org.compiere.model.MOrg;
import org.compiere.model.MProject;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_C_Activity;
import org.compiere.model.X_C_Campaign;
import org.compiere.model.X_C_Project;
import org.compiere.util.DB;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.eevolution.model.MHRAttribute;
import org.eevolution.model.MHRCareerLevel;
import org.eevolution.model.MHRConcept;
import org.eevolution.model.MHRDegree;
import org.eevolution.model.MHRDepartment;
import org.eevolution.model.MHRDesignation;
import org.eevolution.model.MHREmployee;
import org.eevolution.model.MHREmployeeType;
import org.eevolution.model.MHRGrade;
import org.eevolution.model.MHRJob;
import org.eevolution.model.MHRJobEducation;
import org.eevolution.model.MHRJobType;
import org.eevolution.model.MHRPayroll;
import org.eevolution.model.MHRRace;
import org.eevolution.model.MHRSalaryRange;
import org.eevolution.model.MHRSalaryStructure;
import org.eevolution.model.MHRShiftGroup;
import org.eevolution.model.MHRSkillType;
import org.eevolution.model.MHRWorkGroup;
import org.eevolution.model.X_HR_Attribute;
import org.eevolution.model.X_HR_CareerLevel;
import org.eevolution.model.X_HR_Concept;
import org.eevolution.model.X_HR_Degree;
import org.eevolution.model.X_HR_Department;
import org.eevolution.model.X_HR_Designation;
import org.eevolution.model.X_HR_Employee;
import org.eevolution.model.X_HR_EmployeeType;
import org.eevolution.model.X_HR_Grade;
import org.eevolution.model.X_HR_Job;
import org.eevolution.model.X_HR_JobEducation;
import org.eevolution.model.X_HR_JobType;
import org.eevolution.model.X_HR_Payroll;
import org.eevolution.model.X_HR_Race;
import org.eevolution.model.X_HR_SalaryRange;
import org.eevolution.model.X_HR_SalaryStructure;
import org.eevolution.model.X_HR_ShiftGroup;
import org.eevolution.model.X_HR_SkillType;
import org.eevolution.model.X_HR_WorkGroup;
import org.eevolution.model.X_I_HR_Attribute;
import org.eevolution.process.ImportEmployeeAttributesAbstract;

public class ImportEmployeeAttributes
extends ImportEmployeeAttributesAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        if (this.isDeleteOldImported()) {
            Arrays.stream(this.getAttributeIds(true, true, null)).forEach(n -> {
                X_I_HR_Attribute x_I_HR_Attribute = new X_I_HR_Attribute(this.getCtx(), n, null);
                x_I_HR_Attribute.deleteEx(true);
            });
        }
        AtomicInteger atomicInteger = new AtomicInteger(0);
        AtomicInteger atomicInteger2 = new AtomicInteger(0);
        Arrays.stream(this.getAttributeIds(false, false, null)).forEach(n -> Trx.run(string -> {
            X_I_HR_Attribute x_I_HR_Attribute = new X_I_HR_Attribute(this.getCtx(), n, string);
            this.fillIdValues(x_I_HR_Attribute);
            if (this.importRecord(x_I_HR_Attribute)) {
                atomicInteger.updateAndGet(n -> n + 1);
            } else {
                atomicInteger2.updateAndGet(n -> n + 1);
            }
        }));
        return "@HR_Attribute_ID@ @Import@ @Records@ " + atomicInteger.get() + " @Errors@ " + atomicInteger2.get();
    }

    private void fillIdValues(X_I_HR_Attribute x_I_HR_Attribute) {
        PO pO;
        StringBuilder stringBuilder = new StringBuilder();
        x_I_HR_Attribute.setI_ErrorMsg("");
        int n = DB.getSQLValue(x_I_HR_Attribute.get_TrxName(), "SELECT HR_Concept_ID FROM HR_Concept WHERE TRIM(Value) = TRIM(?)", x_I_HR_Attribute.getConceptValue());
        if (n < 0) {
            stringBuilder.append(", ").append("@HR_Concept_ID@ @NotFound@");
        }
        int n2 = DB.getSQLValue(null, "SELECT C_BPartner_ID FROM C_BPartner WHERE TRIM(Value) = TRIM(?)", x_I_HR_Attribute.getValue());
        if (n > 0 && ((X_HR_Concept)(pO = MHRConcept.getById(this.getCtx(), n, x_I_HR_Attribute.get_TrxName()))).isEmployee() && n2 < 0) {
            stringBuilder.append("@HR_Employee_ID@ @NotFound@");
        }
        if (x_I_HR_Attribute.getValidFrom() == null) {
            stringBuilder.append(", ").append("@Invalid@ @ValidFrom@");
        }
        if (stringBuilder.length() > 0) {
            this.setImportError(x_I_HR_Attribute, stringBuilder.toString()).saveEx(x_I_HR_Attribute.get_TrxName());
        }
        x_I_HR_Attribute.setC_BPartner_ID(n2);
        x_I_HR_Attribute.setHR_Concept_ID(n);
        pO = null;
        if (x_I_HR_Attribute.getHR_Race_ID() > 0) {
            pO = MHRRace.getById(this.getCtx(), x_I_HR_Attribute.getHR_Race_ID(), x_I_HR_Attribute.get_TrxName());
        }
        if (pO != null && ((X_HR_Race)pO).getHR_Race_ID() < 0 && x_I_HR_Attribute.getRaceValue() != null) {
            pO = MHRRace.getByValue(this.getCtx(), x_I_HR_Attribute.getRaceValue(), x_I_HR_Attribute.get_TrxName());
        }
        if (pO != null && ((X_HR_Race)pO).getHR_Race_ID() > 0) {
            x_I_HR_Attribute.setHR_Race_ID(((X_HR_Race)pO).getHR_Race_ID());
        }
        MOrg mOrg = null;
        if (x_I_HR_Attribute.getAD_OrgTrx_ID() > 0) {
            mOrg = MOrg.get(this.getCtx(), x_I_HR_Attribute.getAD_OrgTrx_ID());
        }
        if (mOrg == null && x_I_HR_Attribute.getOrgTrxValue() != null) {
            int n3 = this.getId("AD_Org", "Value=?", this.get_TrxName(), x_I_HR_Attribute.getOrgTrxValue());
            mOrg = MOrg.get(this.getCtx(), n3);
        }
        if (mOrg != null && mOrg.getAD_Org_ID() > 0) {
            x_I_HR_Attribute.setAD_OrgTrx_ID(mOrg.getAD_Org_ID());
        }
        X_C_Project x_C_Project = null;
        if (x_I_HR_Attribute.getC_Project_ID() > 0) {
            x_C_Project = MProject.getById(this.getCtx(), x_I_HR_Attribute.getC_Project_ID(), x_I_HR_Attribute.get_TrxName());
        }
        if (x_C_Project == null && x_I_HR_Attribute.getProjectValue() != null) {
            x_C_Project = MProject.getByValue(this.getCtx(), x_I_HR_Attribute.getProjectValue(), x_I_HR_Attribute.get_TrxName());
        }
        if (x_C_Project != null && x_C_Project.getC_Project_ID() > 0) {
            x_I_HR_Attribute.setC_Project_ID(x_C_Project.getC_Project_ID());
        }
        X_HR_Department x_HR_Department = null;
        if (x_I_HR_Attribute.getHR_Department_ID() > 0) {
            x_HR_Department = MHRDepartment.getById(this.getCtx(), x_I_HR_Attribute.getHR_Department_ID(), x_I_HR_Attribute.get_TrxName());
        }
        if (x_HR_Department == null && x_I_HR_Attribute.getDepartmentValue() != null) {
            x_HR_Department = MHRDepartment.getByValue(this.getCtx(), x_I_HR_Attribute.getDepartmentValue(), x_I_HR_Attribute.get_TrxName());
        }
        if (x_HR_Department != null && x_HR_Department.getHR_Department_ID() > 0) {
            x_I_HR_Attribute.setHR_Department_ID(x_HR_Department.getHR_Department_ID());
        }
        X_HR_Job x_HR_Job = null;
        if (x_I_HR_Attribute.getHR_Job_ID() > 0) {
            x_HR_Job = MHRJob.getById(this.getCtx(), x_I_HR_Attribute.getHR_Job_ID(), x_I_HR_Attribute.get_TrxName());
        }
        if (x_HR_Job == null && x_I_HR_Attribute.getJobValue() != null) {
            x_HR_Job = MHRJob.getByValue(this.getCtx(), x_I_HR_Attribute.getJobValue(), x_I_HR_Attribute.get_TrxName());
        }
        if (x_HR_Job != null && x_HR_Job.getHR_Job_ID() > 0) {
            x_I_HR_Attribute.setHR_Job_ID(x_HR_Job.getHR_Job_ID());
        }
        X_HR_JobEducation x_HR_JobEducation = null;
        if (x_I_HR_Attribute.getHR_JobEducation_ID() > 0) {
            x_HR_JobEducation = MHRJobEducation.getById(this.getCtx(), x_I_HR_Attribute.getHR_JobEducation_ID(), x_I_HR_Attribute.get_TrxName());
        }
        if (x_HR_JobEducation == null && x_I_HR_Attribute.getJobEducationValue() != null) {
            x_HR_JobEducation = MHRJobEducation.getByValue(this.getCtx(), x_I_HR_Attribute.getJobEducationValue(), x_I_HR_Attribute.get_TrxName());
        }
        if (x_HR_JobEducation != null && x_HR_JobEducation.getHR_JobEducation_ID() > 0) {
            x_I_HR_Attribute.setHR_JobEducation_ID(x_HR_JobEducation.getHR_JobEducation_ID());
        }
        X_HR_CareerLevel x_HR_CareerLevel = null;
        if (x_I_HR_Attribute.getHR_CareerLevel_ID() > 0) {
            x_HR_CareerLevel = MHRCareerLevel.getById(this.getCtx(), x_I_HR_Attribute.getHR_CareerLevel_ID(), x_I_HR_Attribute.get_TrxName());
        }
        if (x_HR_CareerLevel == null && x_I_HR_Attribute.getCareerLevelValue() != null) {
            x_HR_CareerLevel = MHRCareerLevel.getByValue(this.getCtx(), x_I_HR_Attribute.getCareerLevelValue(), x_I_HR_Attribute.get_TrxName());
        }
        if (x_HR_CareerLevel != null && x_HR_CareerLevel.getHR_CareerLevel_ID() > 0) {
            x_I_HR_Attribute.setHR_CareerLevel_ID(x_HR_CareerLevel.getHR_CareerLevel_ID());
        }
        X_HR_JobType x_HR_JobType = null;
        if (x_I_HR_Attribute.getHR_JobType_ID() > 0) {
            x_HR_JobType = MHRJobType.getById(this.getCtx(), x_I_HR_Attribute.getHR_JobType_ID(), x_I_HR_Attribute.get_TrxName());
        }
        if (x_HR_JobType == null && x_I_HR_Attribute.getJobTypeValue() != null) {
            x_HR_JobType = MHRJobType.getByValue(this.getCtx(), x_I_HR_Attribute.getJobTypeValue(), x_I_HR_Attribute.get_TrxName());
        }
        if (x_HR_JobType != null && x_HR_JobType.getHR_JobType_ID() > 0) {
            x_I_HR_Attribute.setHR_JobType_ID(x_HR_JobType.getHR_JobType_ID());
        }
        X_HR_Payroll x_HR_Payroll = null;
        if (x_I_HR_Attribute.getHR_Payroll_ID() > 0) {
            x_HR_Payroll = MHRPayroll.getById(this.getCtx(), x_I_HR_Attribute.getHR_Job_ID(), x_I_HR_Attribute.get_TrxName());
        }
        if (x_HR_Payroll == null && x_I_HR_Attribute.getPayrollValue() != null) {
            x_HR_Payroll = MHRPayroll.getByValue(this.getCtx(), x_I_HR_Attribute.getPayrollValue(), x_I_HR_Attribute.get_TrxName());
        }
        if (x_HR_Payroll != null && x_HR_Payroll.getHR_Payroll_ID() > 0) {
            x_I_HR_Attribute.setHR_Payroll_ID(x_HR_Payroll.getHR_Payroll_ID());
        }
        X_C_Activity x_C_Activity = null;
        if (x_I_HR_Attribute.getC_Activity_ID() > 0) {
            x_C_Activity = MActivity.getById(this.getCtx(), x_I_HR_Attribute.getC_Activity_ID(), x_I_HR_Attribute.get_TrxName());
        }
        if (x_C_Activity == null && x_I_HR_Attribute.getActivityValue() != null) {
            x_C_Activity = MActivity.getByValue(this.getCtx(), x_I_HR_Attribute.getActivityValue(), x_I_HR_Attribute.get_TrxName());
        }
        if (x_C_Activity != null && x_C_Activity.getC_Activity_ID() > 0) {
            x_I_HR_Attribute.setC_Activity_ID(x_C_Activity.getC_Activity_ID());
        }
        X_C_Campaign x_C_Campaign = null;
        if (x_I_HR_Attribute.getC_Campaign_ID() > 0) {
            x_C_Campaign = MCampaign.getById(this.getCtx(), x_I_HR_Attribute.getC_Campaign_ID(), x_I_HR_Attribute.get_TrxName());
        }
        if (x_C_Campaign == null && x_I_HR_Attribute.getCampaignValue() != null) {
            x_C_Campaign = MCampaign.getByValue(this.getCtx(), x_I_HR_Attribute.getCampaignValue(), x_I_HR_Attribute.get_TrxName());
        }
        if (x_C_Campaign != null && x_C_Campaign.getC_Campaign_ID() > 0) {
            x_I_HR_Attribute.setC_Campaign_ID(x_C_Campaign.getC_Campaign_ID());
        }
        X_HR_WorkGroup x_HR_WorkGroup = null;
        if (x_I_HR_Attribute.getHR_WorkGroup_ID() > 0) {
            x_HR_WorkGroup = MHRWorkGroup.getById(this.getCtx(), x_I_HR_Attribute.getHR_WorkGroup_ID(), x_I_HR_Attribute.get_TrxName());
        }
        if (x_HR_WorkGroup == null && x_I_HR_Attribute.getWorkGroupValue() != null) {
            x_HR_WorkGroup = MHRWorkGroup.getByValue(this.getCtx(), x_I_HR_Attribute.getWorkGroupValue(), x_I_HR_Attribute.get_TrxName());
        }
        if (x_HR_WorkGroup != null && x_HR_WorkGroup.getHR_WorkGroup_ID() > 0) {
            x_I_HR_Attribute.setHR_WorkGroup_ID(x_HR_WorkGroup.getHR_WorkGroup_ID());
        }
        X_HR_ShiftGroup x_HR_ShiftGroup = null;
        if (x_I_HR_Attribute.getHR_ShiftGroup_ID() > 0) {
            x_HR_ShiftGroup = MHRShiftGroup.getById(this.getCtx(), x_I_HR_Attribute.getHR_WorkGroup_ID(), x_I_HR_Attribute.get_TrxName());
        }
        if (x_HR_ShiftGroup == null && x_I_HR_Attribute.getShiftGroupValue() != null) {
            x_HR_ShiftGroup = MHRShiftGroup.getByValue(this.getCtx(), x_I_HR_Attribute.getWorkGroupValue(), x_I_HR_Attribute.get_TrxName());
        }
        if (x_HR_ShiftGroup != null && x_HR_ShiftGroup.getHR_ShiftGroup_ID() > 0) {
            x_I_HR_Attribute.setHR_ShiftGroup_ID(x_HR_ShiftGroup.getHR_ShiftGroup_ID());
        }
        X_HR_Degree x_HR_Degree = null;
        if (x_I_HR_Attribute.getHR_Degree_ID() > 0) {
            x_HR_Degree = MHRDegree.getById(this.getCtx(), x_I_HR_Attribute.getHR_Degree_ID(), x_I_HR_Attribute.get_TrxName());
        }
        if (x_HR_Degree == null && x_I_HR_Attribute.getDegreeValue() != null) {
            x_HR_Degree = MHRDegree.getByValue(this.getCtx(), x_I_HR_Attribute.getDegreeValue(), x_I_HR_Attribute.get_TrxName());
        }
        if (x_HR_Degree != null && x_HR_Degree.getHR_Degree_ID() > 0) {
            x_I_HR_Attribute.setHR_Degree_ID(x_HR_Degree.getHR_Degree_ID());
        }
        X_HR_Grade x_HR_Grade = null;
        if (x_I_HR_Attribute.getHR_Grade_ID() > 0) {
            x_HR_Grade = MHRGrade.getById(this.getCtx(), x_I_HR_Attribute.getHR_Grade_ID(), x_I_HR_Attribute.get_TrxName());
        }
        if (x_HR_Grade == null && x_I_HR_Attribute.getGradeValue() != null) {
            x_HR_Grade = MHRGrade.getByValue(this.getCtx(), x_I_HR_Attribute.getGradeValue(), x_I_HR_Attribute.get_TrxName());
        }
        if (x_HR_Grade != null && x_HR_Grade.getHR_Grade_ID() > 0) {
            x_I_HR_Attribute.setHR_Grade_ID(x_HR_Grade.getHR_Grade_ID());
        }
        X_HR_Designation x_HR_Designation = null;
        if (x_I_HR_Attribute.getHR_Designation_ID() > 0) {
            x_HR_Designation = MHRDesignation.getById(this.getCtx(), x_I_HR_Attribute.getHR_Designation_ID(), x_I_HR_Attribute.get_TrxName());
        }
        if (x_HR_Designation == null && x_I_HR_Attribute.getDesignationValue() != null) {
            x_HR_Designation = MHRDesignation.getByValue(this.getCtx(), x_I_HR_Attribute.getDesignationValue(), x_I_HR_Attribute.get_TrxName());
        }
        if (x_HR_Designation != null && x_HR_Designation.getHR_Designation_ID() > 0) {
            x_I_HR_Attribute.setHR_Designation_ID(x_HR_Designation.getHR_Designation_ID());
        }
        X_HR_SalaryStructure x_HR_SalaryStructure = null;
        if (x_I_HR_Attribute.getHR_SalaryRange_ID() > 0) {
            x_HR_SalaryStructure = MHRSalaryStructure.getById(this.getCtx(), x_I_HR_Attribute.getHR_SalaryStructure_ID(), x_I_HR_Attribute.get_TrxName());
        }
        if (x_HR_SalaryStructure == null && x_I_HR_Attribute.getSalaryStructureValue() != null) {
            x_HR_SalaryStructure = MHRSalaryStructure.getByValue(this.getCtx(), x_I_HR_Attribute.getSalaryStructureValue());
        }
        if (x_HR_SalaryStructure != null && x_HR_SalaryStructure.getHR_SalaryStructure_ID() > 0) {
            x_I_HR_Attribute.setHR_SalaryRange_ID(x_HR_SalaryStructure.getHR_SalaryStructure_ID());
        }
        X_HR_SalaryRange x_HR_SalaryRange = null;
        if (x_I_HR_Attribute.getHR_SalaryRange_ID() > 0) {
            x_HR_SalaryRange = MHRSalaryRange.getById(this.getCtx(), x_I_HR_Attribute.getHR_SalaryRange_ID(), x_I_HR_Attribute.get_TrxName());
        }
        if (x_HR_SalaryRange == null && x_I_HR_Attribute.getSalaryRangeValue() != null) {
            x_HR_SalaryRange = MHRSalaryRange.getByValue(this.getCtx(), x_I_HR_Attribute.getSalaryRangeValue(), x_I_HR_Attribute.get_TrxName());
        }
        if (x_HR_SalaryRange != null && x_HR_SalaryRange.getHR_SalaryRange_ID() > 0) {
            x_I_HR_Attribute.setHR_SalaryRange_ID(x_HR_SalaryRange.getHR_SalaryRange_ID());
        }
        X_HR_EmployeeType x_HR_EmployeeType = null;
        if (x_I_HR_Attribute.getHR_EmployeeType_ID() > 0) {
            x_HR_EmployeeType = MHREmployeeType.getById(this.getCtx(), x_I_HR_Attribute.getHR_EmployeeType_ID(), x_I_HR_Attribute.get_TrxName());
        }
        if (x_HR_EmployeeType == null && x_I_HR_Attribute.getEmployeeTypeValue() != null) {
            x_HR_EmployeeType = MHREmployeeType.getByValue(this.getCtx(), x_I_HR_Attribute.getEmployeeTypeValue(), x_I_HR_Attribute.get_TrxName());
        }
        if (x_HR_EmployeeType != null && x_HR_EmployeeType.getHR_EmployeeType_ID() > 0) {
            x_I_HR_Attribute.setHR_EmployeeType_ID(x_HR_EmployeeType.getHR_EmployeeType_ID());
        }
        X_HR_SkillType x_HR_SkillType = null;
        if (x_I_HR_Attribute.getHR_SkillType_ID() > 0) {
            x_HR_SkillType = MHRSkillType.getById(this.getCtx(), x_I_HR_Attribute.getHR_SkillType_ID(), x_I_HR_Attribute.get_TrxName());
        }
        if (x_HR_SkillType == null && x_I_HR_Attribute.getSkillTypeValue() != null) {
            x_HR_SkillType = MHRSkillType.getByValue(this.getCtx(), x_I_HR_Attribute.getSkillTypeValue(), x_I_HR_Attribute.get_TrxName());
        }
        if (x_HR_SkillType != null && x_HR_SkillType.getHR_SkillType_ID() > 0) {
            x_I_HR_Attribute.setHR_SkillType_ID(x_HR_SkillType.getHR_SkillType_ID());
        }
        x_I_HR_Attribute.saveEx();
    }

    private int getId(String string, String string2, String string3, Object ... objectArray) {
        return new Query(this.getCtx(), string, string2, string3).setParameters(objectArray).firstId();
    }

    private X_I_HR_Attribute setImportError(X_I_HR_Attribute x_I_HR_Attribute, String string) {
        x_I_HR_Attribute.setI_ErrorMsg(Msg.parseTranslation(this.getCtx(), string));
        this.addLog(x_I_HR_Attribute.getHR_Attribute_ID(), x_I_HR_Attribute.getValidFrom(), x_I_HR_Attribute.getAmount(), x_I_HR_Attribute.getI_ErrorMsg());
        return x_I_HR_Attribute;
    }

    private boolean importRecord(X_I_HR_Attribute x_I_HR_Attribute) {
        PO pO;
        if (x_I_HR_Attribute.getI_ErrorMsg() != null && x_I_HR_Attribute.getI_ErrorMsg().length() > 0) {
            x_I_HR_Attribute.setProcessed(false);
            x_I_HR_Attribute.setI_IsImported(false);
            x_I_HR_Attribute.saveEx();
            return false;
        }
        Optional<BigDecimal> optional = Optional.ofNullable(x_I_HR_Attribute.getAmount());
        Optional<BigDecimal> optional2 = Optional.ofNullable(x_I_HR_Attribute.getQty());
        Optional<Timestamp> optional3 = Optional.ofNullable(x_I_HR_Attribute.getServiceDate());
        Optional<String> optional4 = Optional.ofNullable(x_I_HR_Attribute.getTextMsg());
        Optional<Integer> optional5 = Optional.ofNullable(x_I_HR_Attribute.getMinValue());
        Optional<Integer> optional6 = Optional.ofNullable(x_I_HR_Attribute.getMaxValue());
        Optional<Integer> optional7 = Optional.ofNullable(x_I_HR_Attribute.getHR_Department_ID());
        Optional<Integer> optional8 = Optional.ofNullable(x_I_HR_Attribute.getHR_Job_ID());
        Optional<Timestamp> optional9 = Optional.ofNullable(x_I_HR_Attribute.getValidFrom());
        Optional<Timestamp> optional10 = Optional.ofNullable(x_I_HR_Attribute.getValidTo());
        Optional<Integer> optional11 = Optional.ofNullable(x_I_HR_Attribute.getAD_Rule_ID());
        Optional<MHRPayroll> optional12 = Optional.ofNullable(MHRPayroll.getByValue(this.getCtx(), x_I_HR_Attribute.getPayrollValue(), x_I_HR_Attribute.get_TrxName()));
        Optional<String> optional13 = Optional.ofNullable(x_I_HR_Attribute.getReferenceNo());
        int n2 = optional12.isPresent() ? optional12.get().getHR_Payroll_ID() : 0;
        MHRConcept mHRConcept = MHRConcept.getById(this.getCtx(), x_I_HR_Attribute.getHR_Concept_ID(), x_I_HR_Attribute.get_TrxName());
        Optional<MHRAttribute> optional14 = Optional.ofNullable(MHRAttribute.getByConceptAndPartnerId(mHRConcept, x_I_HR_Attribute.getC_BPartner_ID(), n2, x_I_HR_Attribute.getReferenceNo(), x_I_HR_Attribute.getDescription(), x_I_HR_Attribute.getValidFrom()));
        int n3 = 0;
        if (x_I_HR_Attribute.getC_BPartner_ID() > 0 && (pO = MHREmployee.getActiveEmployee(this.getCtx(), x_I_HR_Attribute.getC_BPartner_ID(), this.get_TrxName())) != null) {
            n3 = ((X_HR_Employee)pO).getHR_Employee_ID();
        }
        if (((X_HR_Attribute)(pO = optional14.orElse(new MHRAttribute(x_I_HR_Attribute)))).getHR_Attribute_ID() <= 0) {
            ((X_HR_Attribute)pO).setColumnType(mHRConcept.getColumnType());
            optional9.ifPresent(arg_0 -> ImportEmployeeAttributes.lambda$importRecord$5((MHRAttribute)pO, arg_0));
            optional12.ifPresent(arg_0 -> ImportEmployeeAttributes.lambda$importRecord$6((MHRAttribute)pO, arg_0));
            if (n3 > 0) {
                ((X_HR_Attribute)pO).setHR_Employee_ID(n3);
            }
        }
        optional13.ifPresent(arg_0 -> ImportEmployeeAttributes.lambda$importRecord$7((MHRAttribute)pO, arg_0));
        optional.filter(bigDecimal -> bigDecimal != null && bigDecimal.signum() > 0).ifPresent(arg_0 -> ImportEmployeeAttributes.lambda$importRecord$9((MHRAttribute)pO, arg_0));
        optional2.filter(bigDecimal -> bigDecimal != null && bigDecimal.signum() > 0).ifPresent(arg_0 -> ImportEmployeeAttributes.lambda$importRecord$11((MHRAttribute)pO, arg_0));
        optional3.ifPresent(arg_0 -> ImportEmployeeAttributes.lambda$importRecord$12((MHRAttribute)pO, arg_0));
        optional4.ifPresent(arg_0 -> ImportEmployeeAttributes.lambda$importRecord$13((MHRAttribute)pO, arg_0));
        optional5.filter(n -> n != null && n > 0).ifPresent(arg_0 -> ImportEmployeeAttributes.lambda$importRecord$15((MHRAttribute)pO, arg_0));
        optional6.filter(n -> n != null && n > 0).ifPresent(arg_0 -> ImportEmployeeAttributes.lambda$importRecord$17((MHRAttribute)pO, arg_0));
        optional7.ifPresent(arg_0 -> ImportEmployeeAttributes.lambda$importRecord$18((MHRAttribute)pO, arg_0));
        optional8.ifPresent(arg_0 -> ImportEmployeeAttributes.lambda$importRecord$19((MHRAttribute)pO, arg_0));
        optional10.ifPresent(arg_0 -> ImportEmployeeAttributes.lambda$importRecord$20((MHRAttribute)pO, arg_0));
        optional11.filter(n -> n != null && n > 0).ifPresent(arg_0 -> ImportEmployeeAttributes.lambda$importRecord$22((MHRAttribute)pO, arg_0));
        pO.setIsActive(true);
        pO.saveEx();
        x_I_HR_Attribute.setHR_Attribute_ID(pO.get_ID());
        x_I_HR_Attribute.setI_IsImported(true);
        x_I_HR_Attribute.setI_ErrorMsg("");
        x_I_HR_Attribute.setProcessed(true);
        x_I_HR_Attribute.saveEx();
        return true;
    }

    private int[] getAttributeIds(boolean bl, boolean bl2, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("I_IsImported").append("=? AND ").append("Processed").append("=?");
        return new Query(this.getCtx(), "I_HR_Attribute", stringBuilder.toString(), string).setOnlyActiveRecords(true).setParameters(bl, bl2).getIDs();
    }

    private static /* synthetic */ void lambda$importRecord$22(MHRAttribute mHRAttribute, Integer n) {
        mHRAttribute.setAD_Rule_ID(n);
    }

    private static /* synthetic */ void lambda$importRecord$20(MHRAttribute mHRAttribute, Timestamp timestamp) {
        mHRAttribute.setValidTo(timestamp);
    }

    private static /* synthetic */ void lambda$importRecord$19(MHRAttribute mHRAttribute, Integer n) {
        mHRAttribute.setHR_Job_ID(n);
    }

    private static /* synthetic */ void lambda$importRecord$18(MHRAttribute mHRAttribute, Integer n) {
        mHRAttribute.setHR_Department_ID(n);
    }

    private static /* synthetic */ void lambda$importRecord$17(MHRAttribute mHRAttribute, Integer n) {
        mHRAttribute.setMaxValue(n);
    }

    private static /* synthetic */ void lambda$importRecord$15(MHRAttribute mHRAttribute, Integer n) {
        mHRAttribute.setMinValue(n);
    }

    private static /* synthetic */ void lambda$importRecord$13(MHRAttribute mHRAttribute, String string) {
        mHRAttribute.setTextMsg(string);
    }

    private static /* synthetic */ void lambda$importRecord$12(MHRAttribute mHRAttribute, Timestamp timestamp) {
        mHRAttribute.setServiceDate(timestamp);
    }

    private static /* synthetic */ void lambda$importRecord$11(MHRAttribute mHRAttribute, BigDecimal bigDecimal) {
        mHRAttribute.setQty(bigDecimal);
    }

    private static /* synthetic */ void lambda$importRecord$9(MHRAttribute mHRAttribute, BigDecimal bigDecimal) {
        mHRAttribute.setAmount(bigDecimal);
    }

    private static /* synthetic */ void lambda$importRecord$7(MHRAttribute mHRAttribute, String string) {
        mHRAttribute.setReferenceNo(string);
    }

    private static /* synthetic */ void lambda$importRecord$6(MHRAttribute mHRAttribute, MHRPayroll mHRPayroll) {
        mHRAttribute.setHR_Payroll_ID(mHRPayroll.getHR_Payroll_ID());
    }

    private static /* synthetic */ void lambda$importRecord$5(MHRAttribute mHRAttribute, Timestamp timestamp) {
        mHRAttribute.setValidFrom(timestamp);
    }
}

