/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.io.Serializable;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.compiere.model.MBPartner;
import org.compiere.model.Query;
import org.compiere.model.X_C_BPartner;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.eevolution.model.MHRConcept;
import org.eevolution.model.MHRMovement;
import org.eevolution.model.MHRProcess;
import org.eevolution.model.X_HR_Process;
import org.eevolution.model.X_I_HR_Movement;
import org.eevolution.process.ImportPayrollMovementsAbstract;

public class ImportPayrollMovements
extends ImportPayrollMovementsAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        if (this.isDeleteOldImported()) {
            Arrays.stream(this.getPayrollImportMovementIds(true, true, null)).forEach(n -> {
                X_I_HR_Movement x_I_HR_Movement = new X_I_HR_Movement(this.getCtx(), n, null);
                x_I_HR_Movement.deleteEx(true);
            });
        }
        AtomicInteger atomicInteger = new AtomicInteger(0);
        AtomicInteger atomicInteger2 = new AtomicInteger(0);
        Arrays.stream(this.getPayrollImportMovementIds(false, false, null)).forEach(n -> Trx.run(string -> {
            X_I_HR_Movement x_I_HR_Movement = new X_I_HR_Movement(this.getCtx(), n, string);
            this.fillIdValues(x_I_HR_Movement);
            if (this.importRecord(x_I_HR_Movement)) {
                atomicInteger.updateAndGet(n -> n + 1);
            } else {
                atomicInteger2.updateAndGet(n -> n + 1);
            }
        }));
        return "@HR_Movement_ID@ @Import@ @Records@ " + atomicInteger.get() + " @Errors@ " + atomicInteger2.get();
    }

    private void fillIdValues(X_I_HR_Movement x_I_HR_Movement) {
        Serializable serializable;
        Serializable serializable2;
        StringBuilder stringBuilder = new StringBuilder();
        x_I_HR_Movement.setI_ErrorMsg("");
        Integer n = this.getId("HR_Process", "Name=?", x_I_HR_Movement.getProcessName());
        if (n < 0) {
            stringBuilder.append("@HR_Process_ID@  @NotFound@ ");
        } else {
            serializable2 = new MHRProcess(this.getCtx(), n, x_I_HR_Movement.get_TrxName());
            if ("DR".equals(((X_HR_Process)serializable2).getDocStatus()) && "IP".equals(((X_HR_Process)serializable2).getDocStatus())) {
                stringBuilder.append("@DocStatus@ @NotValid@");
            }
        }
        serializable2 = Integer.valueOf(this.getId("C_BPartner", "Value=?", x_I_HR_Movement.getBPartner_Value()));
        if ((Integer)serializable2 < 0) {
            stringBuilder.append(", ").append("@C_BPartner_ID@ @NotFound@");
        } else {
            serializable = new MBPartner(this.getCtx(), (Integer)serializable2, x_I_HR_Movement.get_TrxName());
            if (!((X_C_BPartner)serializable).isEmployee()) {
                stringBuilder.append(", ").append("@IsEmployee@ @NotValid@ @C_BPartner_ID@ " + ((X_C_BPartner)serializable).getName());
            }
        }
        serializable = new StringBuilder("");
        ((StringBuilder)serializable).append("Value").append("=? AND ").append("IsManual").append("=? AND ").append("IsActive").append("=? ");
        Integer n2 = this.getId("HR_Concept", ((StringBuilder)serializable).toString(), x_I_HR_Movement.getConceptValue().trim(), true, true);
        if (n2 < 0) {
            this.setImportError(x_I_HR_Movement, "@HR_Concept_ID@ " + x_I_HR_Movement.getConceptValue() + " @NotFound@").saveEx(x_I_HR_Movement.get_TrxName());
        } else {
            MHRConcept mHRConcept = new MHRConcept(this.getCtx(), n2, x_I_HR_Movement.get_TrxName());
            if ("E".equals(mHRConcept.getType())) {
                stringBuilder.append(", ").append("@HR_Concept_ID@ " + mHRConcept.getName() + " @NotValid@ ");
            }
        }
        if (x_I_HR_Movement.getValidFrom() == null) {
            stringBuilder.append(", ").append("@ValidFrom@ @FillMandatory@ ");
        }
        if (x_I_HR_Movement.getValidTo() == null) {
            x_I_HR_Movement.setValidTo(x_I_HR_Movement.getValidFrom());
        }
        if (stringBuilder.length() > 0) {
            this.setImportError(x_I_HR_Movement, stringBuilder.toString()).saveEx(x_I_HR_Movement.get_TrxName());
        }
        x_I_HR_Movement.setHR_Process_ID(n);
        x_I_HR_Movement.setHR_Concept_ID(n2);
        x_I_HR_Movement.setC_BPartner_ID((Integer)serializable2);
        x_I_HR_Movement.saveEx(x_I_HR_Movement.get_TrxName());
    }

    private boolean importRecord(X_I_HR_Movement x_I_HR_Movement) {
        if (x_I_HR_Movement.getI_ErrorMsg() != null && x_I_HR_Movement.getI_ErrorMsg().length() > 0) {
            x_I_HR_Movement.setProcessed(false);
            x_I_HR_Movement.setI_IsImported(false);
            x_I_HR_Movement.saveEx();
            return false;
        }
        MHRMovement mHRMovement = new MHRMovement(x_I_HR_Movement);
        mHRMovement.saveEx(x_I_HR_Movement.get_TrxName());
        x_I_HR_Movement.setHR_Movement_ID(mHRMovement.getHR_Movement_ID());
        x_I_HR_Movement.setI_IsImported(true);
        x_I_HR_Movement.setProcessed(true);
        x_I_HR_Movement.setI_ErrorMsg("");
        x_I_HR_Movement.saveEx(x_I_HR_Movement.get_TrxName());
        return true;
    }

    private int getId(String string, String string2, Object ... objectArray) {
        return new Query(this.getCtx(), string, string2, this.get_TrxName()).setClient_ID().setParameters(objectArray).firstId();
    }

    private X_I_HR_Movement setImportError(X_I_HR_Movement x_I_HR_Movement, String string) {
        x_I_HR_Movement.setI_ErrorMsg(Msg.parseTranslation(this.getCtx(), string));
        this.addLog(x_I_HR_Movement.getI_HR_Movement_ID(), x_I_HR_Movement.getValidFrom(), x_I_HR_Movement.getAmount(), x_I_HR_Movement.getI_ErrorMsg());
        return x_I_HR_Movement;
    }

    private int[] getPayrollImportMovementIds(boolean bl, boolean bl2, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("I_IsImported").append("=? AND ").append("Processed").append("=?");
        return new Query(this.getCtx(), "I_HR_Movement", stringBuilder.toString(), string).setOnlyActiveRecords(true).setParameters(bl, bl2).getIDs();
    }
}

