/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.compiere.model.PO;
import org.eevolution.model.MDDDriver;
import org.eevolution.model.MDDLicense;
import org.eevolution.model.MDDLicenseAssignment;
import org.eevolution.model.MDDVehicle;
import org.eevolution.process.ProcessingLicenseSelectionAbstract;

public class ProcessingLicenseSelection
extends ProcessingLicenseSelectionAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        List<MDDLicense> list = this.getInstancesForSelection(this.get_TrxName());
        if (this.getRecord_ID() > 0 && this.getSelectionKeys().size() > 0 && this.getTableSelectionId() == MDDLicense.Table_ID) {
            PO pO;
            if (this.getProcessInfo().getTable_ID() == MDDDriver.Table_ID) {
                pO = (MDDDriver)this.getInstance(this.get_TrxName());
                this.createDriverLicense((MDDDriver)pO, list);
            }
            if (this.getProcessInfo().getTable_ID() == MDDVehicle.Table_ID) {
                pO = (MDDVehicle)this.getInstance(this.get_TrxName());
                this.createVehicleLicense((MDDVehicle)pO, list);
            }
        } else if (this.getRecord_ID() == 0 && this.getSelectionKeys().size() > 0) {
            this.UpdatingLicense(list);
        }
        return "";
    }

    private void createDriverLicense(MDDDriver mDDDriver, List<MDDLicense> list) {
        AtomicInteger atomicInteger = new AtomicInteger(0);
        list.stream().filter(mDDLicense -> mDDLicense != null).forEach(mDDLicense -> {
            MDDLicenseAssignment mDDLicenseAssignment = new MDDLicenseAssignment(mDDDriver, mDDLicense.get_ID());
            mDDLicenseAssignment.setSeqNo(atomicInteger.updateAndGet(n -> n + 10));
            mDDLicenseAssignment.saveEx();
        });
    }

    private void createVehicleLicense(MDDVehicle mDDVehicle, List<MDDLicense> list) {
        AtomicInteger atomicInteger = new AtomicInteger(0);
        list.stream().filter(mDDLicense -> mDDLicense != null).forEach(mDDLicense -> {
            MDDLicenseAssignment mDDLicenseAssignment = new MDDLicenseAssignment(mDDVehicle, mDDLicense.get_ID());
            mDDLicenseAssignment.setSeqNo(atomicInteger.updateAndGet(n -> n + 10));
            mDDLicenseAssignment.saveEx();
        });
    }

    private void UpdatingLicense(List<MDDLicense> list) {
        list.stream().filter(mDDLicense -> mDDLicense != null).forEach(mDDLicense -> {
            int n = mDDLicense.get_ColumnCount();
            for (int i = 0; i < n; ++i) {
                String string = mDDLicense.get_ColumnName(i);
                Optional.ofNullable(this.getSelection(mDDLicense.get_ID(), this.getPrefixAliasForTableSelection() + string)).ifPresent(object -> mDDLicense.set_ValueOfColumn(string, object));
            }
            mDDLicense.saveEx();
        });
    }
}

