/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.eevolution.model.MWMInOutBound;
import org.eevolution.model.MWMInOutBoundLine;
import org.eevolution.process.ProcessingOrderSelectionAbstract;

public class ProcessingOrderSelection
extends ProcessingOrderSelectionAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        List<MOrder> list = this.getInstancesForSelection(this.get_TrxName());
        if (this.getRecord_ID() > 0 && this.getSelectionKeys().size() > 0 && this.getTableSelectionId() == MWMInOutBound.Table_ID) {
            this.createInboundLineFrom(list);
        } else if (this.getRecord_ID() == 0 && this.getSelectionKeys().size() > 0) {
            this.updatingOrderProperties(list);
        }
        return "";
    }

    private void updatingOrderProperties(List<MOrder> list) {
        list.stream().filter(mOrder -> mOrder != null).forEach(mOrder -> {
            int n = mOrder.get_ColumnCount();
            for (int i = 0; i < n; ++i) {
                String string = mOrder.get_ColumnName(i);
                Optional.ofNullable(this.getSelection(mOrder.get_ID(), this.getPrefixAliasForTableSelection() + string)).ifPresent(object -> mOrder.set_ValueOfColumn(string, object));
            }
            mOrder.saveEx();
        });
    }

    private void createInboundLineFrom(List<MOrder> list) {
        MWMInOutBound mWMInOutBound = (MWMInOutBound)this.getInstance(this.get_TrxName());
        AtomicInteger atomicInteger = new AtomicInteger(10);
        list.stream().filter(mOrder -> mOrder != null).flatMap(mOrder -> Arrays.stream(mOrder.getLines())).forEach(mOrderLine -> {
            MWMInOutBoundLine mWMInOutBoundLine = MWMInOutBoundLine.getByOrderLine(mOrderLine);
            if (mWMInOutBoundLine == null) {
                mWMInOutBoundLine = new MWMInOutBoundLine(mWMInOutBound, (MOrderLine)mOrderLine);
                mWMInOutBoundLine.setLine(atomicInteger.get());
                mWMInOutBoundLine.saveEx();
                atomicInteger.updateAndGet(n -> n + 10);
            }
        });
    }
}

