/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.compiere.model.PO;
import org.eevolution.model.MDDDriver;
import org.eevolution.model.MDDRequirement;
import org.eevolution.model.MDDRequirementAssignment;
import org.eevolution.model.MDDVehicle;
import org.eevolution.process.ProcessingRequirementSelectionAbstract;

public class ProcessingRequirementSelection
extends ProcessingRequirementSelectionAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        List<MDDRequirement> list = this.getInstancesForSelection(this.get_TrxName());
        if (this.getRecord_ID() > 0 && this.getSelectionKeys().size() > 0 && this.getTableSelectionId() == MDDRequirement.Table_ID) {
            PO pO;
            if (this.getProcessInfo().getTable_ID() == MDDDriver.Table_ID) {
                pO = (MDDDriver)this.getInstance(this.get_TrxName());
                this.createDriverRequirement((MDDDriver)pO, list);
            }
            if (this.getProcessInfo().getTable_ID() == MDDVehicle.Table_ID) {
                pO = (MDDVehicle)this.getInstance(this.get_TrxName());
                this.createVehicleRequirement((MDDVehicle)pO, list);
            }
        } else if (this.getRecord_ID() == 0 && this.getSelectionKeys().size() > 0) {
            this.UpdatingRequirement(list);
        }
        return "";
    }

    private void createDriverRequirement(MDDDriver mDDDriver, List<MDDRequirement> list) {
        AtomicInteger atomicInteger = new AtomicInteger(0);
        list.stream().filter(mDDRequirement -> mDDRequirement != null).forEach(mDDRequirement -> {
            MDDRequirementAssignment mDDRequirementAssignment = new MDDRequirementAssignment(mDDDriver, mDDRequirement.get_ID());
            mDDRequirementAssignment.setSeqNo(atomicInteger.updateAndGet(n -> n + 10));
            mDDRequirementAssignment.saveEx();
        });
    }

    private void createVehicleRequirement(MDDVehicle mDDVehicle, List<MDDRequirement> list) {
        AtomicInteger atomicInteger = new AtomicInteger(0);
        list.stream().filter(mDDRequirement -> mDDRequirement != null).forEach(mDDRequirement -> {
            MDDRequirementAssignment mDDRequirementAssignment = new MDDRequirementAssignment(mDDVehicle, mDDRequirement.get_ID());
            mDDRequirementAssignment.setSeqNo(atomicInteger.updateAndGet(n -> n + 10));
            mDDRequirementAssignment.saveEx();
        });
    }

    private void UpdatingRequirement(List<MDDRequirement> list) {
        list.stream().filter(mDDRequirement -> mDDRequirement != null).forEach(mDDRequirement -> {
            int n = mDDRequirement.get_ColumnCount();
            for (int i = 0; i < n; ++i) {
                String string = mDDRequirement.get_ColumnName(i);
                Optional.ofNullable(this.getSelection(mDDRequirement.get_ID(), this.getPrefixAliasForTableSelection() + string)).ifPresent(object -> mDDRequirement.set_ValueOfColumn(string, object));
            }
            mDDRequirement.saveEx();
        });
    }
}

