/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.NoVendorForProductException;
import org.compiere.model.MBPartner;
import org.compiere.model.MDocType;
import org.compiere.model.MLocator;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrg;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPO;
import org.compiere.model.MQuery;
import org.compiere.model.MRequisition;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.MStorage;
import org.compiere.model.MTable;
import org.compiere.model.MUser;
import org.compiere.model.MWarehouse;
import org.compiere.model.PO;
import org.compiere.model.PrintInfo;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportCtl;
import org.compiere.print.ReportEngine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.wf.MWorkflow;
import org.eevolution.engine.warehouse.WMRuleEngine;
import org.eevolution.exceptions.NoBPartnerLinkedforOrgException;
import org.eevolution.exceptions.NoPlantForWarehouseException;
import org.eevolution.model.MDDOrder;
import org.eevolution.model.MDDOrderLine;
import org.eevolution.model.MPPMRP;
import org.eevolution.model.MPPOrder;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.MPPProductPlanning;
import org.eevolution.model.MWMInOutBound;
import org.eevolution.model.MWMInOutBoundLine;
import org.eevolution.model.X_DD_OrderLine;
import org.eevolution.process.ReleaseInOutBoundAbstract;

public class ReleaseInOutBound
extends ReleaseInOutBoundAbstract {
    private Timestamp today = new Timestamp(System.currentTimeMillis());
    private MDDOrder orderDistribution;

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        MLocator mLocator = new MLocator(this.getCtx(), this.getLocatorId(), this.get_TrxName());
        if (mLocator == null || mLocator.getM_Locator_ID() <= 0) {
            throw new AdempiereException("@M_Locator_ID@ @NotFound@");
        }
        List<?> list = this.getInstancesForSelection(this.get_TrxName());
        Hashtable hashtable = new Hashtable();
        list.stream().forEach(mWMInOutBoundLine -> {
            mWMInOutBoundLine.setM_LocatorTo_ID(mLocator.getM_Locator_ID());
            mWMInOutBoundLine.saveEx();
            MWMInOutBound mWMInOutBound = mWMInOutBoundLine.getParent();
            if (!hashtable.contains(mWMInOutBound.get_ID())) {
                hashtable.put(mWMInOutBound.get_ID(), mWMInOutBound);
            }
        });
        hashtable.entrySet().forEach(entry -> {
            MWMInOutBound mWMInOutBound = (MWMInOutBound)entry.getValue();
            mWMInOutBound.setDocAction("CO");
            mWMInOutBound.processIt("CO");
            mWMInOutBound.saveEx();
        });
        list.stream().forEach(mWMInOutBoundLine -> {
            Serializable serializable;
            if (mWMInOutBoundLine.getDD_OrderLine_ID() > 0) {
                serializable = (MDDOrderLine)mWMInOutBoundLine.getDD_OrderLine();
                if (((X_DD_OrderLine)serializable).getWM_InOutBoundLine_ID() <= 0) {
                    ((X_DD_OrderLine)serializable).setWM_InOutBoundLine_ID(((X_DD_OrderLine)serializable).getWM_InOutBoundLine_ID());
                    ((PO)serializable).saveEx();
                }
                if (((X_DD_OrderLine)serializable).getM_LocatorTo_ID() == mWMInOutBoundLine.getM_LocatorTo_ID()) {
                    return;
                }
            }
            serializable = this.createDistributionOrder((MWMInOutBoundLine)mWMInOutBoundLine);
            if (this.isCreateSupply() && ((BigDecimal)serializable).signum() > 0) {
                Env.setContext(mWMInOutBoundLine.getCtx(), "IsCreateSupply", "Y");
                this.createSupply((MWMInOutBoundLine)mWMInOutBoundLine, (BigDecimal)serializable);
            }
        });
        if (this.orderDistribution != null && this.getDocAction() != null) {
            this.orderDistribution.setDocAction(this.getDocAction());
            this.orderDistribution.setDocStatus("IP");
            this.orderDistribution.completeIt();
            this.orderDistribution.save();
        }
        if (this.isPrintPickList() && this.orderDistribution != null) {
            ReportEngine reportEngine = this.getReportEngine("DistributionOrder_Header  ** TEMPLATE **", "DD_Order_Header_v", this.orderDistribution.getDD_Order_ID());
            if (reportEngine == null) {
                throw new AdempiereException("@NotFound@ @AD_PrintFormat_ID@");
            }
            ReportCtl.preview(reportEngine);
            reportEngine.print();
        }
        return "@Ok@ ";
    }

    protected BigDecimal createDistributionOrder(MWMInOutBoundLine mWMInOutBoundLine) {
        WMRuleEngine wMRuleEngine = WMRuleEngine.get();
        List<MStorage> list = wMRuleEngine.getStorage(mWMInOutBoundLine, this.getAreaTypeId(), this.getSectionTypeId());
        int n = 0;
        AtomicReference<BigDecimal> atomicReference = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        if (list != null && list.size() > 0) {
            MLocator mLocator = MLocator.get(mWMInOutBoundLine.getCtx(), mWMInOutBoundLine.getM_LocatorTo_ID());
            MWarehouse[] mWarehouseArray = MWarehouse.getInTransitForOrg(this.getCtx(), mLocator.getAD_Org_ID());
            if (mWarehouseArray == null || mWarehouseArray.length == 0) {
                throw new AdempiereException("@M_Warehouse_ID@ @IsInTransit@ @NotFound@");
            }
            MOrg mOrg = MOrg.get(this.getCtx(), mLocator.getAD_Org_ID());
            int n2 = mOrg.getLinkedC_BPartner_ID(this.get_TrxName());
            if (n2 == 0) {
                throw new NoBPartnerLinkedforOrgException(mOrg);
            }
            MBPartner mBPartner = MBPartner.get(this.getCtx(), n2);
            if (this.orderDistribution == null) {
                this.orderDistribution = new MDDOrder(this.getCtx(), 0, this.get_TrxName());
                this.orderDistribution.setAD_Org_ID(mLocator.getAD_Org_ID());
                this.orderDistribution.setC_BPartner_ID(n2);
                if (this.getDocTypeId() > 0) {
                    this.orderDistribution.setC_DocType_ID(this.getDocTypeId());
                } else {
                    this.orderDistribution.setC_DocType_ID(MDocType.getDocType("DOO"));
                }
                this.orderDistribution.setM_Warehouse_ID(mWarehouseArray[0].get_ID());
                if (this.getDocAction() != null) {
                    this.orderDistribution.setDocAction(this.getDocAction());
                } else {
                    this.orderDistribution.setDocAction("PR");
                }
                MUser[] mUserArray = MUser.getOfBPartner(this.getCtx(), mBPartner.getC_BPartner_ID(), this.get_TrxName());
                if (mUserArray == null || mUserArray.length == 0) {
                    throw new AdempiereException("@AD_User_ID@ @NotFound@ @Value@ - @C_BPartner_ID@ : " + mBPartner.getValue() + " - " + mBPartner.getName());
                }
                this.orderDistribution.setAD_User_ID(mUserArray[0].getAD_User_ID());
                this.orderDistribution.setDateOrdered(this.getToday());
                this.orderDistribution.setDatePromised(this.getToday());
                this.orderDistribution.setM_Shipper_ID(n);
                this.orderDistribution.setM_FreightCategory_ID(mWMInOutBoundLine.getParent().getM_FreightCategory_ID());
                this.orderDistribution.setFreightCostRule(mWMInOutBoundLine.getParent().getFreightCostRule());
                this.orderDistribution.setFreightAmt(mWMInOutBoundLine.getParent().getFreightAmt());
                this.orderDistribution.setIsInDispute(false);
                this.orderDistribution.setIsInTransit(false);
                this.orderDistribution.setSalesRep_ID(this.getAD_User_ID());
                this.orderDistribution.saveEx();
            }
            list.stream().forEach(mStorage -> {
                MDDOrderLine mDDOrderLine = new MDDOrderLine(this.orderDistribution);
                mDDOrderLine.setM_Locator_ID(mStorage.getM_Locator_ID());
                mDDOrderLine.setM_LocatorTo_ID(mWMInOutBoundLine.getM_LocatorTo_ID());
                mDDOrderLine.setC_UOM_ID(mWMInOutBoundLine.getC_UOM_ID());
                mDDOrderLine.setM_Product_ID(mWMInOutBoundLine.getM_Product_ID());
                mDDOrderLine.setDateOrdered(this.getToday());
                mDDOrderLine.setDatePromised(mWMInOutBoundLine.getPickDate());
                mDDOrderLine.setWM_InOutBoundLine_ID(mWMInOutBoundLine.getWM_InOutBoundLine_ID());
                mDDOrderLine.setIsInvoiced(false);
                if (mWMInOutBoundLine.getQtyToPick().subtract((BigDecimal)atomicReference.get()).compareTo(mStorage.getQtyOnHand()) < 0) {
                    mDDOrderLine.setConfirmedQty(mWMInOutBoundLine.getQtyToPick());
                    mDDOrderLine.setQtyEntered(mWMInOutBoundLine.getQtyToPick());
                    mDDOrderLine.setQtyOrdered(mWMInOutBoundLine.getQtyToPick());
                    mDDOrderLine.setTargetQty(mWMInOutBoundLine.getQtyToPick());
                    atomicReference.updateAndGet(bigDecimal -> bigDecimal.add(mWMInOutBoundLine.getQtyToPick()));
                } else {
                    mDDOrderLine.setConfirmedQty(mStorage.getQtyOnHand());
                    mDDOrderLine.setQtyEntered(mStorage.getQtyOnHand());
                    mDDOrderLine.setQtyOrdered(mStorage.getQtyOnHand());
                    mDDOrderLine.setTargetQty(mStorage.getQtyOnHand());
                    atomicReference.updateAndGet(bigDecimal -> bigDecimal.add(mStorage.getQtyOnHand()));
                }
                if (((BigDecimal)atomicReference.get()).signum() > 0) {
                    mWMInOutBoundLine.setM_Locator_ID(mStorage.getM_Locator_ID());
                    mWMInOutBoundLine.saveEx();
                }
                mDDOrderLine.setFreightAmt(mWMInOutBoundLine.getFreightAmt());
                mDDOrderLine.setM_FreightCategory_ID(mWMInOutBoundLine.getM_FreightCategory_ID());
                mDDOrderLine.setM_Shipper_ID(mWMInOutBoundLine.getM_Shipper_ID());
                mDDOrderLine.saveEx();
            });
        } else {
            atomicReference.updateAndGet(bigDecimal -> mWMInOutBoundLine.getQtyToPick().subtract((BigDecimal)bigDecimal));
        }
        return atomicReference.get();
    }

    public void createSupply(MWMInOutBoundLine mWMInOutBoundLine, BigDecimal bigDecimal) {
        MProduct mProduct = MProduct.get(mWMInOutBoundLine.getCtx(), mWMInOutBoundLine.getM_Product_ID());
        if (mProduct != null && mProduct.isBOM()) {
            this.createManufacturingOrder(mWMInOutBoundLine, mProduct, bigDecimal);
        } else if (mProduct.isPurchased()) {
            this.createRequisition(mWMInOutBoundLine, mProduct, bigDecimal);
        }
    }

    public void createRequisition(MWMInOutBoundLine mWMInOutBoundLine, MProduct mProduct, BigDecimal bigDecimal) {
        int n = 0;
        int n2 = 0;
        MProductPO[] mProductPOArray = MProductPO.getOfProduct(this.getCtx(), mProduct.getM_Product_ID(), null);
        Arrays.stream(mProductPOArray).forEach(mProductPO -> {
            if (!mProductPO.isCurrentVendor() || mProductPO.getC_BPartner_ID() != 0) {
                // empty if block
            }
        });
        if (n == 0 && mProductPOArray.length > 0) {
            n = mProductPOArray[0].getC_BPartner_ID();
        }
        if (n == 0) {
            throw new NoVendorForProductException(mProduct.getName());
        }
        n2 = DB.getSQLValueEx(this.get_TrxName(), "SELECT COALESCE(bp.PO_PriceList_ID,bpg.PO_PriceList_ID) FROM C_BPartner bp INNER JOIN C_BP_Group bpg ON (bpg.C_BP_Group_ID=bp.C_BP_Group_ID) WHERE bp.C_BPartner_ID=?", n);
        MLocator mLocator = MLocator.get(mWMInOutBoundLine.getCtx(), mWMInOutBoundLine.getM_LocatorTo_ID());
        MRequisition mRequisition = new MRequisition(this.getCtx(), 0, this.get_TrxName());
        mRequisition.setAD_Org_ID(mLocator.getAD_Org_ID());
        mRequisition.setAD_User_ID(this.getAD_User_ID());
        mRequisition.setDateRequired(mWMInOutBoundLine.getPickDate());
        mRequisition.setDescription("Generate from Outbound Order");
        mRequisition.setM_Warehouse_ID(mLocator.getM_Warehouse_ID());
        mRequisition.setC_DocType_ID(MDocType.getDocType("POR"));
        if (n2 > 0) {
            mRequisition.setM_PriceList_ID(n2);
        }
        mRequisition.saveEx();
        MRequisitionLine mRequisitionLine = new MRequisitionLine(mRequisition);
        mRequisitionLine.setLine(10);
        mRequisitionLine.setAD_Org_ID(mLocator.getAD_Org_ID());
        mRequisitionLine.setC_BPartner_ID(n);
        mRequisitionLine.setM_Product_ID(mProduct.getM_Product_ID());
        mRequisitionLine.setPrice();
        mRequisitionLine.setPriceActual(Env.ZERO);
        mRequisitionLine.setQty(bigDecimal);
        mRequisitionLine.saveEx();
        MOrderLine mOrderLine = new MOrderLine(this.getCtx(), mWMInOutBoundLine.getC_OrderLine_ID(), this.get_TrxName());
        mOrderLine.setDescription(mOrderLine.getDescription() + " " + Msg.translate(this.getCtx(), "M_Requisition_ID") + " : " + mRequisition.getDocumentNo());
        mOrderLine.saveEx();
        mWMInOutBoundLine.setDescription(mWMInOutBoundLine.getDescription() + " " + Msg.translate(mWMInOutBoundLine.getCtx(), "M_Requisition_ID") + " : " + mRequisition.getDocumentNo());
    }

    public void createManufacturingOrder(MWMInOutBoundLine mWMInOutBoundLine, MProduct mProduct, BigDecimal bigDecimal) {
        MPPProductBOM mPPProductBOM;
        MPPOrder mPPOrder = MPPOrder.forC_OrderLine_ID(mWMInOutBoundLine.getCtx(), mWMInOutBoundLine.getC_OrderLine_ID(), mProduct.get_ID(), mWMInOutBoundLine.get_TrxName());
        mPPOrder.setM_Shipper_ID(mWMInOutBoundLine.getParent().getM_Shipper_ID());
        mPPOrder.setM_FreightCategory_ID(mWMInOutBoundLine.getParent().getM_FreightCategory_ID());
        mPPOrder.setFreightCostRule(mWMInOutBoundLine.getParent().getFreightCostRule());
        if (mPPOrder == null && (mPPProductBOM = MPPProductBOM.getDefault(mProduct, this.get_TrxName())) != null) {
            MPPProductPlanning mPPProductPlanning = null;
            if (mPPProductBOM == null && (mPPProductPlanning = MPPProductPlanning.find(this.getCtx(), mWMInOutBoundLine.getAD_Org_ID(), 0, 0, mProduct.getM_Product_ID(), null)) != null) {
                mPPProductBOM = mPPProductPlanning.getPP_Product_BOM();
            }
            if (mPPProductBOM != null) {
                int n = MPPProductPlanning.getPlantForWarehouse(mWMInOutBoundLine.getM_Warehouse_ID());
                if (n <= 0) {
                    throw new NoPlantForWarehouseException(mWMInOutBoundLine.getM_Warehouse_ID());
                }
                MWorkflow mWorkflow = MWorkflow.get(this.getCtx(), MWorkflow.getWorkflowSearchKey(mProduct));
                if (mWorkflow == null && mPPProductPlanning != null) {
                    mWorkflow = mPPProductPlanning.getAD_Workflow();
                }
                if (n > 0 && mWorkflow != null) {
                    String string = Msg.translate(this.getCtx(), "WM_InOutBound_ID") + " : " + mWMInOutBoundLine.getParent().getDocumentNo();
                    mPPProductPlanning = new MPPProductPlanning(this.getCtx(), 0, this.get_TrxName());
                    mPPProductPlanning.setAD_Org_ID(mWMInOutBoundLine.getAD_Org_ID());
                    mPPProductPlanning.setM_Product_ID(mProduct.getM_Product_ID());
                    mPPProductPlanning.setPlanner_ID(mWMInOutBoundLine.getParent().getSalesRep_ID());
                    mPPProductPlanning.setPP_Product_BOM_ID(mPPProductBOM.getPP_Product_BOM_ID());
                    mPPProductPlanning.setAD_Workflow_ID(mWorkflow.getAD_Workflow_ID());
                    mPPProductPlanning.setM_Warehouse_ID(mWMInOutBoundLine.getM_Warehouse_ID());
                    mPPProductPlanning.setS_Resource_ID(n);
                    mPPOrder = MPPMRP.createMO(mPPProductPlanning, mWMInOutBoundLine.getC_OrderLine_ID(), mWMInOutBoundLine.getM_AttributeSetInstance_ID(), bigDecimal, mWMInOutBoundLine.getPickDate(), mWMInOutBoundLine.getShipDate(), string);
                    MOrderLine mOrderLine = new MOrderLine(this.getCtx(), mWMInOutBoundLine.getC_OrderLine_ID(), this.get_TrxName());
                    string = "";
                    if (mOrderLine.getDescription() != null) {
                        string = mOrderLine.getDescription();
                    }
                    string = string + " " + Msg.translate(mOrderLine.getCtx(), "PP_Order_ID") + " : " + mPPOrder.getDocumentNo();
                    mOrderLine.setDescription(string);
                    mOrderLine.saveEx();
                    String string2 = "";
                    if (mWMInOutBoundLine.getDescription() != null) {
                        string2 = mWMInOutBoundLine.getDescription();
                    }
                    string2 = string2 + " " + Msg.translate(this.getCtx(), "PP_Order_ID") + " : " + mPPOrder.getDocumentNo();
                    mWMInOutBoundLine.setDescription(string2);
                }
            }
        }
    }

    private ReportEngine getReportEngine(String string, String string2, int n) {
        int n2 = MPrintFormat.getPrintFormat_ID(string, MTable.getTable_ID(string2), this.getAD_Client_ID());
        MPrintFormat mPrintFormat = MPrintFormat.get(this.getCtx(), n2, true);
        if (mPrintFormat == null) {
            this.addLog("@NotFound@ @AD_PrintFormat_ID@");
            return null;
        }
        MQuery mQuery = new MQuery(string2);
        mQuery.addRestriction("DD_Order_ID", "=", n);
        PrintInfo printInfo = new PrintInfo(string2, MTable.getTable_ID(string2), n);
        ReportEngine reportEngine = new ReportEngine(this.getCtx(), mPrintFormat, mQuery, printInfo);
        return reportEngine;
    }

    protected Timestamp getToday() {
        return this.today;
    }
}

