/*
 * Decompiled with CFR 0.152.
 */
package org.spin.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MField;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.model.X_AD_ContextInfo;

public class MADContextInfo
extends X_AD_ContextInfo {
    private static final long serialVersionUID = -9157152272245789095L;
    private static CLogger log = CLogger.getCLogger(MADContextInfo.class);
    private static CCache<Integer, MADContextInfo> contextInfoCacheIds = new CCache("AD_ContextInfo", 30);
    private static CCache<String, MADContextInfo> contextInfoCacheFromIds = new CCache("AD_ContextInfo", 30);
    private static CCache<String, Map<String, MADContextInfo>> contextInfoCacheFielsIds = new CCache("AD_ContextInfo", 30);

    public MADContextInfo(Properties ctx, int contextInfoId, String trxName) {
        super(ctx, contextInfoId, trxName);
    }

    public MADContextInfo(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MADContextInfo getById(Properties ctx, int statusBarId) {
        if (statusBarId <= 0) {
            return null;
        }
        MADContextInfo contextInfo = contextInfoCacheIds.get(statusBarId);
        if (contextInfo != null && contextInfo.get_ID() > 0) {
            return contextInfo;
        }
        contextInfo = (MADContextInfo)new Query(ctx, "AD_ContextInfo", "AD_ContextInfo_ID=?", null).setParameters(statusBarId).first();
        if (contextInfo != null && contextInfo.get_ID() > 0) {
            contextInfoCacheIds.put(contextInfo.get_ID(), contextInfo);
        }
        return contextInfo;
    }

    public static MADContextInfo getFromTabId(Properties ctx, int tabId) {
        if (tabId <= 0) {
            return null;
        }
        String key = "Tab|" + tabId;
        MADContextInfo statusBar = contextInfoCacheFromIds.get(key);
        if (statusBar != null && statusBar.get_ID() > 0) {
            return statusBar;
        }
        try {
            statusBar = (MADContextInfo)new Query(ctx, "AD_ContextInfo", "EXISTS(SELECT 1 FROM AD_Tab t WHERE t.AD_Tab_ID = ? AND t.AD_ContextInfo_ID = AD_ContextInfo.AD_ContextInfo_ID)", null).setParameters(tabId).first();
        }
        catch (Exception e) {
            log.severe("getFromTabId: " + e.getLocalizedMessage());
        }
        if (statusBar != null && statusBar.get_ID() > 0) {
            contextInfoCacheFromIds.put(key, statusBar);
        }
        return statusBar;
    }

    public static MADContextInfo getFromTableId(Properties ctx, int tableId) {
        if (tableId <= 0) {
            return null;
        }
        String key = "Table|" + tableId;
        MADContextInfo statusBar = contextInfoCacheFromIds.get(key);
        if (statusBar != null && statusBar.get_ID() > 0) {
            return statusBar;
        }
        try {
            statusBar = (MADContextInfo)new Query(ctx, "AD_ContextInfo", "EXISTS(SELECT 1 FROM AD_Table t WHERE t.AD_Table_ID = ? AND t.AD_ContextInfo_ID = AD_ContextInfo.AD_ContextInfo_ID)", null).setParameters(tableId).first();
        }
        catch (Exception e) {
            log.severe("getFromTableId: " + e.getLocalizedMessage());
        }
        if (statusBar != null && statusBar.get_ID() > 0) {
            contextInfoCacheFromIds.put(key, statusBar);
        }
        return statusBar;
    }

    public static MADContextInfo getFromWindowId(Properties ctx, int windowId) {
        if (windowId <= 0) {
            return null;
        }
        String key = "Window|" + windowId;
        MADContextInfo statusBar = contextInfoCacheFromIds.get(key);
        if (statusBar != null && statusBar.get_ID() > 0) {
            return statusBar;
        }
        try {
            statusBar = (MADContextInfo)new Query(ctx, "AD_ContextInfo", "EXISTS(SELECT 1 FROM AD_Window w WHERE w.AD_Window_ID = ? AND w.AD_ContextInfo_ID = AD_ContextInfo.AD_ContextInfo_ID)", null).setParameters(windowId).first();
        }
        catch (Exception e) {
            log.severe("getFromWindowId: " + e.getLocalizedMessage());
        }
        if (statusBar != null && statusBar.get_ID() > 0) {
            contextInfoCacheFromIds.put(key, statusBar);
        }
        return statusBar;
    }

    public static Map<String, MADContextInfo> getFromTabIdForField(Properties ctx, int tabId) {
        if (tabId <= 0) {
            return null;
        }
        String key = "TabField|" + tabId;
        Map<String, MADContextInfo> contextInfoHash = contextInfoCacheFielsIds.get(key);
        if (contextInfoHash != null && contextInfoHash.size() > 0) {
            return contextInfoHash;
        }
        List fieldList = null;
        try {
            fieldList = new Query(ctx, "AD_Field", "AD_Tab_ID = ? AND AD_ContextInfo_ID IS NOT NULL", null).setParameters(tabId).list();
        }
        catch (Exception e) {
            log.severe("getFromTabIdForField: " + e.getLocalizedMessage());
        }
        if (fieldList != null && fieldList.size() > 0) {
            contextInfoHash = new HashMap<String, MADContextInfo>();
            for (MField field : fieldList) {
                contextInfoHash.put(field.getAD_Column().getColumnName(), MADContextInfo.getById(field.getCtx(), field.get_ValueAsInt("AD_ContextInfo_ID")));
            }
            if (contextInfoHash != null && contextInfoHash.size() > 0) {
                contextInfoCacheFielsIds.put(key, contextInfoHash);
            }
        }
        return contextInfoHash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getArguments(int windowNo) {
        ResultSet rs;
        CPreparedStatement pstmt;
        block8: {
            Object[] objectArray;
            String sql = this.getSQLStatement();
            if (Util.isEmpty(sql)) {
                return null;
            }
            sql = Env.parseContext(this.getCtx(), windowNo, sql, false, false);
            if (Util.isEmpty(sql)) {
                return null;
            }
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement(sql, null);
                rs = pstmt.executeQuery();
                ResultSetMetaData metaData = rs.getMetaData();
                int columnQty = metaData.getColumnCount();
                Object[] arguments = new Object[columnQty];
                if (!rs.next()) break block8;
                for (int column = 0; column < columnQty; ++column) {
                    Object value = rs.getObject(column + 1);
                    if (value instanceof BigDecimal && value instanceof Double && value instanceof Float && value instanceof Integer && value instanceof String && value instanceof Timestamp) continue;
                    if (value == null) {
                        value = new String();
                    }
                    value = value instanceof BigDecimal ? Double.valueOf(((BigDecimal)value).doubleValue()) : (value instanceof Timestamp ? new Long(((Timestamp)value).getTime()) : (value instanceof Number ? new Integer(((Number)value).intValue()) : String.valueOf(value)));
                    arguments[column] = value;
                }
                objectArray = arguments;
            }
            catch (SQLException e) {
                try {
                    log.log(Level.WARNING, "\nSQL=" + sql, e);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    throw throwable;
                }
                DB.close(rs, pstmt);
            }
            DB.close(rs, pstmt);
            return objectArray;
        }
        DB.close(rs, pstmt);
        return null;
    }

    @Override
    public String toString() {
        return "MADContextInfo [getAD_ContextInfo_ID()=" + this.getAD_ContextInfo_ID() + ", getName()=" + this.getName() + ", getValue()=" + this.getValue() + "]";
    }
}

