/*
 * Decompiled with CFR 0.152.
 */
package org.spin.model;

import java.io.File;
import java.lang.reflect.Constructor;
import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Util;
import org.spin.model.MHRProcessReportLine;
import org.spin.model.X_HR_ProcessReport;
import org.spin.model.X_RV_HR_ProcessDetail;
import org.spin.util.AbstractPayrollReportExport;
import org.spin.util.GenericPayrollExport;

public class MHRProcessReport
extends X_HR_ProcessReport {
    private static final long serialVersionUID = 7984464436153212633L;
    private static CCache<Integer, MHRProcessReport> s_cache = new CCache("HR_ProcessReport", 100);
    private List<MHRProcessReportLine> lines = null;
    private AbstractPayrollReportExport reportExport = null;

    public MHRProcessReport(Properties properties, int n, String string) {
        super(properties, n, string);
    }

    public MHRProcessReport(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    public static MHRProcessReport get(Properties properties, int n) {
        if (n == 0) {
            return null;
        }
        MHRProcessReport mHRProcessReport = s_cache.get(n);
        if (mHRProcessReport != null) {
            return mHRProcessReport;
        }
        mHRProcessReport = new MHRProcessReport(properties, n, null);
        s_cache.put(mHRProcessReport.get_ID(), mHRProcessReport);
        return mHRProcessReport;
    }

    public List<MHRProcessReportLine> getLines(boolean bl, String string) {
        if (this.lines != null && !bl) {
            return this.lines;
        }
        this.lines = new Query(this.getCtx(), "HR_ProcessReportLine", "HR_ProcessReport_ID=?", this.get_TrxName()).setParameters(this.getHR_ProcessReport_ID()).list();
        return this.lines;
    }

    public int copyFrom(MHRProcessReport mHRProcessReport, MHRProcessReport mHRProcessReport2) {
        int n = 0;
        List<MHRProcessReportLine> list = mHRProcessReport.getLines(false, null);
        for (MHRProcessReportLine mHRProcessReportLine : list) {
            MHRProcessReportLine mHRProcessReportLine2 = new MHRProcessReportLine(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues(mHRProcessReportLine, mHRProcessReportLine2, mHRProcessReportLine.getAD_Client_ID(), mHRProcessReportLine.getAD_Org_ID());
            mHRProcessReportLine2.setHR_ProcessReport_ID(this.getHR_ProcessReport_ID());
            mHRProcessReportLine2.saveEx();
            ++n;
        }
        return n;
    }

    private Class<?> getHandlerClass() {
        String string = this.getFileExportClass();
        if (Util.isEmpty(string)) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(string);
            for (Class<?> clazz2 = clazz.getSuperclass(); clazz2 != null; clazz2 = clazz2.getSuperclass()) {
                if (clazz2 != AbstractPayrollReportExport.class) continue;
                this.log.fine("Use: " + string);
                return clazz;
            }
        }
        catch (Exception exception) {
            this.log.severe(exception.getMessage());
        }
        this.log.finest("Not found: " + string);
        return null;
    }

    private void loadExportClass() throws Exception {
        if (this.reportExport != null) {
            return;
        }
        Class<?> clazz = this.getHandlerClass();
        if (clazz == null) {
            this.log.log(Level.INFO, "Using Standard Report Export");
            this.reportExport = new GenericPayrollExport(this.getCtx());
            return;
        }
        Constructor<?> constructor = clazz.getDeclaredConstructor(Properties.class);
        this.reportExport = (AbstractPayrollReportExport)constructor.newInstance(this.getCtx());
    }

    public AbstractPayrollReportExport getPayrollReportExport() throws Exception {
        this.loadExportClass();
        return this.reportExport;
    }

    public boolean exportToFile(File file, List<X_RV_HR_ProcessDetail> list) throws Exception {
        this.loadExportClass();
        if (this.reportExport != null) {
            this.reportExport.setDetail(list);
            return this.reportExport.exportToFile(file);
        }
        return false;
    }

    @Override
    public String toString() {
        return this.getHR_ProcessReport_ID() + " - " + this.getName();
    }
}

