/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBankAccount;
import org.compiere.model.MPayment;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.process.DepositFromCashAbstract;

public class DepositFromCash
extends DepositFromCashAbstract {
    private String p_TenderType = "T";
    private List<MPayment> paymentList = new ArrayList<MPayment>();

    @Override
    protected String doIt() throws Exception {
        if (!this.isSplitDeposits() && Util.isEmpty(this.getDocumentNo())) {
            throw new AdempiereException("@DocumentNo@ @IsMandatory@");
        }
        BigDecimal payAmt = Env.ZERO;
        int bankAccountFromId = 0;
        MPayment receiptReference = null;
        MPayment inPayment = null;
        MPayment outPayment = null;
        boolean first = true;
        boolean isPaymentCreated = false;
        for (int key : this.getSelectionKeys()) {
            int paymentId = this.getSelectionAsInt(key, "CP_C_Payment_ID");
            receiptReference = new MPayment(this.getCtx(), paymentId, this.get_TrxName());
            if (bankAccountFromId == 0) {
                bankAccountFromId = receiptReference.getC_BankAccount_ID();
            }
            if (this.isSplitDeposits()) {
                inPayment = this.createPayment(receiptReference.getDocumentNo(), this.getBankAccountId(), true, receiptReference.getPayAmt(), receiptReference.getTenderType());
                receiptReference.setRef_Payment_ID(inPayment.getC_Payment_ID());
                receiptReference.saveEx();
                isPaymentCreated = true;
            } else {
                if (inPayment == null) {
                    inPayment = this.createPayment(this.getDocumentNo(), this.getBankAccountId(), true, null, null);
                    isPaymentCreated = true;
                }
                receiptReference.setRef_Payment_ID(inPayment.getC_Payment_ID());
                receiptReference.saveEx();
            }
            payAmt = payAmt.add(receiptReference.getPayAmt());
            if (first) {
                first = false;
                outPayment = this.createPayment(this.getDocumentNo(), bankAccountFromId, false, null, null);
            }
            if (!isPaymentCreated || outPayment == null) continue;
            inPayment.setRef_Payment_ID(outPayment.getC_Payment_ID());
            inPayment.saveEx();
        }
        StringBuffer msg = new StringBuffer();
        if (payAmt.compareTo(Env.ZERO) > 0 && outPayment != null) {
            outPayment.setPayAmt(payAmt);
            outPayment.saveEx();
            if (!this.isSplitDeposits() && inPayment != null) {
                inPayment.setPayAmt(payAmt);
                inPayment.saveEx();
            }
            for (MPayment payment : this.paymentList) {
                payment.processIt("CO");
                payment.saveEx();
                if (msg.length() > 0) {
                    msg.append(", ");
                }
                msg.append("[" + payment.getDocumentNo() + "]");
            }
        }
        return "@Created@: (" + this.paymentList.size() + ") " + msg.toString();
    }

    private MPayment createPayment(String documentNo, int bankAccountId, boolean isReceipt, BigDecimal payAmt, String tenderType) {
        MBankAccount bankAccount = MBankAccount.get(this.getCtx(), bankAccountId);
        MPayment payment = new MPayment(this.getCtx(), 0, this.get_TrxName());
        payment.setC_BPartner_ID(this.getBPartnerId());
        payment.setC_BankAccount_ID(bankAccountId);
        payment.setIsReceipt(isReceipt);
        payment.setTenderType(tenderType != null ? tenderType : this.p_TenderType);
        payment.setDateTrx(this.getDateTrx());
        payment.setDateAcct(this.getDateTrx());
        if (!Util.isEmpty(documentNo)) {
            payment.setDocumentNo(documentNo);
        }
        payment.setC_Currency_ID(bankAccount.getC_Currency_ID());
        payment.setC_Charge_ID(this.getChargeId());
        payment.setDocStatus("DR");
        if (payAmt != null) {
            payment.setPayAmt(payAmt);
        }
        payment.saveEx();
        this.paymentList.add(payment);
        return payment;
    }
}

