/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.util.ArrayList;
import java.util.List;
import org.compiere.model.MColumn;
import org.compiere.model.MMigration;
import org.compiere.model.MMigrationStep;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Util;
import org.spin.process.ExportSurrogateKeyToMigrationAbstract;

public class ExportSurrogateKeyToMigration
extends ExportSurrogateKeyToMigrationAbstract {
    private List<String> updateList = new ArrayList<String>();
    private List<String> rollbackList = new ArrayList<String>();
    private MMigration migration = null;
    private int sequence = 10;
    private long generated = 0L;
    private String entityTypeWhereClause = "";

    @Override
    protected String doIt() throws Exception {
        List<MTable> tableList = this.getTableList(this.get_TrxName());
        tableList.stream().filter(table2 -> table2 != null).filter(table2 -> table2.getColumn(table2.getTableName() + "_ID") != null).filter(table2 -> table2.getColumn("UUID") != null).filter(table2 -> !table2.isIgnoreMigration()).forEach(table2 -> this.addTableToUpdate(table2.getTableName()));
        return "@Created@: " + this.generated;
    }

    private void addMigration() {
        StringBuffer updateBuffer = new StringBuffer();
        StringBuffer rollbackBuffer = new StringBuffer();
        if (this.updateList.size() == 0) {
            return;
        }
        this.createMigration();
        MColumn sQLColumn = MTable.get(this.getCtx(), "AD_MigrationStep").getColumn("SQLStatement");
        int length = sQLColumn.getFieldLength();
        for (int i2 = 0; i2 < this.updateList.size(); ++i2) {
            if (updateBuffer.length() >= length - 200) {
                this.addStep(updateBuffer.toString(), rollbackBuffer.toString());
                updateBuffer = new StringBuffer();
                rollbackBuffer = new StringBuffer();
            }
            if (updateBuffer.length() > 0) {
                updateBuffer.append(Env.NL);
                rollbackBuffer.append(Env.NL);
            }
            updateBuffer.append(this.updateList.get(i2));
            rollbackBuffer.append(this.rollbackList.get(i2));
        }
        if (updateBuffer.length() > 0) {
            this.addStep(updateBuffer.toString(), rollbackBuffer.toString());
        }
        this.generated += (long)this.updateList.size();
        this.updateList = new ArrayList<String>();
        this.rollbackList = new ArrayList<String>();
    }

    private void addStep(String updateStatement, String rollbackStatement) {
        MMigrationStep step = new MMigrationStep(this.migration);
        step.set_TrxName(this.get_TrxName());
        step.setStepType("SQL");
        step.setDBType("ALL");
        step.setStatusCode("A");
        step.setApply("R");
        step.setSeqNo(this.sequence);
        step.setSQLStatement(updateStatement);
        step.setRollbackStatement(rollbackStatement);
        step.saveEx();
        this.sequence += 10;
    }

    private void createMigration() {
        if (this.migration != null) {
            return;
        }
        this.migration = new MMigration(this.getCtx(), 0, null);
        this.migration.setName(MSysConfig.getValue("DICTIONARY_ID_COMMENTS"));
        boolean dict = Ini.isPropertyBool("AdempiereSys");
        this.migration.setEntityType(dict ? "D" : "U");
        String sql = "SELECT max(SeqNo)+10 FROM AD_Migration";
        int seqNo = DB.getSQLValue(null, sql);
        this.migration.setSeqNo(seqNo);
        this.migration.setStatusCode("A");
        this.migration.setApply("R");
        this.migration.saveEx();
    }

    private void addTableToUpdate(String tableName) {
        KeyNamePair[] uuidValues;
        String keyId = tableName + "_ID";
        String uuidKey = "UUID";
        for (KeyNamePair value : uuidValues = DB.getKeyNamePairs(this.get_TrxName(), "SELECT " + keyId + ", " + uuidKey + " FROM " + tableName + " WHERE AD_Client_ID = ? AND " + uuidKey + " IS NOT NULL" + this.entityTypeWhereClause, false, this.getAD_Client_ID())) {
            this.updateList.add("UPDATE " + tableName + " SET " + uuidKey + "= '" + value.getName() + "' WHERE " + keyId + " = " + value.getKey() + ";");
            this.rollbackList.add("UPDATE " + tableName + " SET " + uuidKey + " = NULL WHERE " + keyId + " = " + value.getKey() + ";");
        }
        this.addMigration();
    }

    private List<MTable> getTableList(String trxName) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        StringBuilder whereClause = new StringBuilder("IsView=?");
        parameters.add("N");
        if (this.getTableId() > 0) {
            whereClause.append(" AND ").append("AD_Table_ID").append(" = ? ");
            parameters.add(this.getTableId());
        }
        if (!Util.isEmpty(this.getEntityType())) {
            whereClause.append(" AND EXISTS(SELECT 1 FROM AD_Column c WHERE c.AD_Table_ID = AD_Table.AD_Table_ID AND c.ColumnName = ?)");
            parameters.add("EntityType");
            this.entityTypeWhereClause = " AND EntityType = '" + this.getEntityType() + "'";
        }
        return new Query(Env.getCtx(), "AD_Table", whereClause.toString(), trxName).setOnlyActiveRecords(true).setParameters(parameters).setOrderBy("TableName").list();
    }
}

