/*
 * Decompiled with CFR 0.152.
 */
package org.spin.report;

import java.sql.SQLException;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Util;
import org.spin.report.OpenItemToDateAbstract;

public class OpenItemToDate
extends OpenItemToDateAbstract {
    private long m_start = System.currentTimeMillis();

    @Override
    protected String doIt() throws SQLException {
        StringBuffer sql = new StringBuffer();
        StringBuffer whereClause = new StringBuffer();
        if (this.getOrgId() != 0) {
            whereClause.append(" AND i.AD_Org_ID = ?");
        }
        if (this.getBPGroupId() != 0) {
            whereClause.append(" AND i.C_BP_Group_ID = ?");
        }
        if (this.getBPartnerId() != 0) {
            whereClause.append(" AND i.C_BPartner_ID = ?");
        }
        if (this.getDocTypeId() != 0) {
            whereClause.append(" AND i.C_DocType_ID = ?");
        }
        if (!Util.isEmpty(this.getInvoiceCollectionType())) {
            whereClause.append(" AND i.InvoiceCollectionType = ?");
        }
        if (this.getDateInvoiced() != null) {
            whereClause.append(" AND i.DateInvoiced >= ?");
        }
        if (this.getDateInvoicedTo() != null) {
            whereClause.append(" AND i.DateInvoiced <= ?");
        }
        if (this.getDateAcct() != null) {
            whereClause.append(" AND i.DateAcct >= ?");
        }
        if (this.getDateAcctTo() != null) {
            whereClause.append(" AND i.DateAcct <= ?");
        }
        sql.append("INSERT INTO T_OpenItemToDate(AD_Org_ID, AD_Client_ID, DocumentNo, C_Invoice_ID, C_Order_ID, C_BPartner_ID, IsSOTrx, DateInvoiced, DateAcct, NetDays, DueDate, DaysDue, DiscountDate, DiscountAmt, GrandTotal, PaidAmt, OpenAmt, C_Currency_ID, C_ConversionType_ID, C_PaymentTerm_ID, IsPayScheduleValid, C_InvoicePaySchedule_ID, InvoiceCollectionType, C_Campaign_ID, C_Project_ID, C_Activity_ID, C_DocType_ID, DateTo, AD_PInstance_ID, Created, Updated, CreatedBy, UpdatedBy) ");
        sql.append("SELECT i.AD_Org_ID, i.AD_Client_ID, i.DocumentNo, i.C_Invoice_ID, i.C_Order_ID, i.C_BPartner_ID, i.IsSOTrx, i.DateInvoiced, i.DateAcct, i.NetDays, i.DueDate, i.DaysDue, i.DiscountDate, i.DiscountAmt, i.GrandTotal, i.PaidAmt, i.OpenAmt, i.C_Currency_ID, i.C_ConversionType_ID, i.C_PaymentTerm_ID, i.IsPayScheduleValid, i.C_InvoicePaySchedule_ID, i.InvoiceCollectionType, i.C_Campaign_ID, i.C_Project_ID, i.C_Activity_ID, i.C_DocType_ID, ?, ").append(this.getAD_PInstance_ID()).append(", getdate(), getdate(), ").append(this.getAD_User_ID()).append(", ").append(this.getAD_User_ID()).append(" ");
        sql.append("FROM (SELECT i.AD_Org_ID, i.AD_Client_ID,\ti.DocumentNo, i.C_Invoice_ID, i.C_Order_ID, i.C_BPartner_ID, i.IsSOTrx, i.DateInvoiced, i.DateAcct, p.NetDays, paymentTermDueDate(i.C_PaymentTerm_ID, i.DateInvoiced) AS DueDate, paymentTermDueDays(i.C_PaymentTerm_ID, i.DateInvoiced, ?) AS DaysDue, addDays(i.DateInvoiced,p.DiscountDays) AS DiscountDate, ROUND(i.GrandTotal*p.Discount/100,2) AS DiscountAmt, i.GrandTotal, invoicePaidToDate(i.C_Invoice_ID, i.C_Currency_ID, 1, ?) AS PaidAmt, invoiceOpenToDate(i.C_Invoice_ID, 0, ?) AS OpenAmt, i.C_Currency_ID, i.C_ConversionType_ID, i.C_PaymentTerm_ID, i.IsPayScheduleValid, cast(null as numeric) AS C_InvoicePaySchedule_ID, i.InvoiceCollectionType, i.C_Campaign_ID, i.C_Project_ID, i.C_Activity_ID, i.C_DocType_ID FROM RV_C_Invoice i INNER JOIN C_PaymentTerm p ON (i.C_PaymentTerm_ID = p.C_PaymentTerm_ID) WHERE invoiceOpenToDate(i.C_Invoice_ID, 0, ?) <> 0 AND i.IsPayScheduleValid<>'Y' AND i.DocStatus IN ('CO','CL') ");
        sql.append("UNION ");
        sql.append("SELECT i.AD_Org_ID, i.AD_Client_ID, i.DocumentNo, i.C_Invoice_ID, i.C_Order_ID, i.C_BPartner_ID, i.IsSOTrx, i.DateInvoiced, i.DateAcct, daysBetween(ips.DueDate,i.DateInvoiced) AS NetDays, ips.DueDate, daysBetween(?, ips.DueDate) AS DaysDue, ips.DiscountDate, ips.DiscountAmt, ips.DueAmt AS GrandTotal, invoicePaidToDate(i.C_Invoice_ID, i.C_Currency_ID, 1, ?) AS PaidAmt, invoiceOpenToDate(i.C_Invoice_ID, ips.C_InvoicePaySchedule_ID, ?) AS OpenAmt, i.C_Currency_ID, i.C_ConversionType_ID, i.C_PaymentTerm_ID, i.IsPayScheduleValid, ips.C_InvoicePaySchedule_ID, i.InvoiceCollectionType, i.C_Campaign_ID, i.C_Project_ID, i.C_Activity_ID, i.C_DocType_ID FROM RV_C_Invoice i INNER JOIN C_InvoicePaySchedule ips ON (i.C_Invoice_ID = ips.C_Invoice_ID)\tWHERE invoiceOpenToDate(i.C_Invoice_ID, ips.C_InvoicePaySchedule_ID, ? ) <> 0 AND i.IsPayScheduleValid='Y' AND i.DocStatus IN ('CO','CL') AND ips.IsValid='Y') i ");
        sql.append("WHERE i.IsSOTrx = ").append(this.isSOTrx() ? "'Y'" : "'N'");
        sql.append(whereClause);
        this.log.fine("SQL = " + sql.toString());
        CPreparedStatement pstmtInsert = DB.prepareStatement(sql.toString(), this.get_TrxName());
        int i2 = 1;
        pstmtInsert.setTimestamp(i2++, this.getDateTo());
        pstmtInsert.setTimestamp(i2++, this.getDateTo());
        pstmtInsert.setTimestamp(i2++, this.getDateTo());
        pstmtInsert.setTimestamp(i2++, this.getDateTo());
        pstmtInsert.setTimestamp(i2++, this.getDateTo());
        pstmtInsert.setTimestamp(i2++, this.getDateTo());
        pstmtInsert.setTimestamp(i2++, this.getDateTo());
        pstmtInsert.setTimestamp(i2++, this.getDateTo());
        pstmtInsert.setTimestamp(i2++, this.getDateTo());
        if (this.getOrgId() != 0) {
            pstmtInsert.setInt(i2++, this.getOrgId());
        }
        if (this.getBPGroupId() != 0) {
            pstmtInsert.setInt(i2++, this.getBPGroupId());
        }
        if (this.getBPartnerId() != 0) {
            pstmtInsert.setInt(i2++, this.getBPartnerId());
        }
        if (this.getDocTypeId() != 0) {
            pstmtInsert.setInt(i2++, this.getDocTypeId());
        }
        if (!Util.isEmpty(this.getInvoiceCollectionType())) {
            pstmtInsert.setString(i2++, this.getInvoiceCollectionType());
        }
        if (this.getDateInvoiced() != null) {
            pstmtInsert.setTimestamp(i2++, this.getDateInvoiced());
        }
        if (this.getDateInvoicedTo() != null) {
            pstmtInsert.setTimestamp(i2++, this.getDateInvoicedTo());
        }
        if (this.getDateAcct() != null) {
            pstmtInsert.setTimestamp(i2++, this.getDateAcct());
        }
        if (this.getDateAcctTo() != null) {
            pstmtInsert.setTimestamp(i2++, this.getDateAcctTo());
        }
        int noInserts = pstmtInsert.executeUpdate();
        this.log.fine(System.currentTimeMillis() - this.m_start + " ms");
        return "@Created@ = " + noInserts;
    }
}

