/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.logging.Level;
import javax.print.DocFlavor;
import javax.print.StreamPrintService;
import javax.print.StreamPrintServiceFactory;
import javax.print.attribute.HashPrintRequestAttributeSet;
import org.compiere.print.ReportEngine;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.spin.util.AbstractExportFormat;

public class ExportFormatPS
extends AbstractExportFormat {
    private static CLogger log = CLogger.getCLogger(ExportFormatPS.class);

    public ExportFormatPS(Properties ctx, ReportEngine reportEngine) {
        this.setCtx(ctx);
        this.setReportEngine(reportEngine);
    }

    @Override
    public String getExtension() {
        return "ps";
    }

    @Override
    public String getName() {
        return Msg.getMsg(Env.getCtx(), "FilePS");
    }

    @Override
    public boolean exportToFile(File file) {
        if (this.getReportEngine() == null || this.getCtx() == null) {
            return false;
        }
        return this.createPS(file);
    }

    public boolean createPS(File file) {
        try {
            return this.createPS(new FileOutputStream(file));
        }
        catch (FileNotFoundException fnfe) {
            log.log(Level.SEVERE, "(f) - " + fnfe.toString());
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(f)", e);
        }
        return false;
    }

    public boolean createPS(OutputStream os) {
        try {
            String outputMimeType = DocFlavor.BYTE_ARRAY.POSTSCRIPT.getMimeType();
            DocFlavor.SERVICE_FORMATTED docFlavor = DocFlavor.SERVICE_FORMATTED.PAGEABLE;
            StreamPrintServiceFactory[] spsfactories = StreamPrintServiceFactory.lookupStreamPrintServiceFactories(docFlavor, outputMimeType);
            if (spsfactories.length == 0) {
                log.log(Level.SEVERE, "(fos) - No StreamPrintService");
                return false;
            }
            StreamPrintService sps = spsfactories[0].getPrintService(os);
            this.getReportEngine().getView();
            sps.createPrintJob().print(this.getLayoutEngine().getPageable(false), new HashPrintRequestAttributeSet());
            os.flush();
            if (os instanceof FileOutputStream) {
                ((FileOutputStream)os).close();
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(fos)", e);
        }
        return false;
    }
}

