/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util;

import java.io.File;
import java.io.Writer;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.transform.stream.StreamResult;
import org.compiere.print.ReportEngine;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.spin.util.AbstractExportFormat;

public class ExportFormatXML
extends AbstractExportFormat {
    private static CLogger log = CLogger.getCLogger(ExportFormatXML.class);

    public ExportFormatXML(Properties ctx, ReportEngine reportEngine) {
        this.setCtx(ctx);
        this.setReportEngine(reportEngine);
    }

    @Override
    public String getExtension() {
        return "xml";
    }

    @Override
    public String getName() {
        return Msg.getMsg(Env.getCtx(), "FileXML");
    }

    @Override
    public boolean exportToFile(File file) {
        if (this.getReportEngine() == null || this.getCtx() == null) {
            return false;
        }
        return this.createXML(this.convertFile(file));
    }

    public boolean createXML(Writer writer) {
        if (writer == null) {
            return false;
        }
        try {
            this.getPrintData().createXML(new StreamResult(writer));
            writer.flush();
            writer.close();
            return true;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(w)", e);
            return false;
        }
    }
}

