/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.compiere.model.GridFieldVO;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.spin.model.MADFieldCondition;
import org.spin.util.FieldCondition;

public class FieldDefinition {
    private static FieldDefinition fieldDefinition;
    private static HashMap<GridFieldVO, FieldDefinition> fieldDefinitionMap;
    private FieldCondition fieldConditionValid = null;
    private GridFieldVO gridFielVO;
    private List<FieldCondition> fieldConditionList = new ArrayList<FieldCondition>();

    private FieldDefinition(GridFieldVO gridFielVO) {
        this.gridFielVO = gridFielVO;
        fieldDefinitionMap.put(gridFielVO, this);
        this.addFieldCondition(gridFielVO.AD_FieldDefinition_ID);
    }

    public static FieldDefinition getInstance(GridFieldVO gridFielVO) {
        fieldDefinition = fieldDefinitionMap.get(gridFielVO) == null ? new FieldDefinition(gridFielVO) : fieldDefinitionMap.get(gridFielVO);
        return fieldDefinition;
    }

    private void addFieldCondition(FieldCondition fieldCondition) {
        if (fieldCondition == null) {
            return;
        }
        this.fieldConditionList.add(fieldCondition);
    }

    public void addFieldCondition(int fieldConditionId) {
        if (fieldConditionId == 0) {
            return;
        }
        List fieldConditionLists = new Query(Env.getCtx(), "AD_FieldCondition", "AD_FieldDefinition_ID = ?", null).setParameters(fieldConditionId).list();
        for (MADFieldCondition fieldCondition : fieldConditionLists) {
            FieldCondition condition = new FieldCondition(fieldCondition, this.gridFielVO);
            this.addFieldCondition(condition);
        }
    }

    public List<FieldCondition> getConditionList() {
        return this.fieldConditionList;
    }

    public FieldCondition processCondition() {
        this.fieldConditionList.stream().forEach(k -> {
            if (k.isValid()) {
                this.fieldConditionValid = k;
                return;
            }
        });
        return this.fieldConditionValid;
    }

    public FieldCondition getConditionValid(HashMap<String, Object> columnvalue) {
        this.fieldConditionList.stream().forEach(k -> {
            if (k.isValid(columnvalue)) {
                this.fieldConditionValid = k;
                return;
            }
        });
        return this.fieldConditionValid;
    }

    static {
        fieldDefinitionMap = new HashMap();
    }
}

