/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util;

import java.util.List;
import org.compiere.model.MClient;
import org.compiere.model.MClientInfo;
import org.compiere.model.MMailText;
import org.compiere.model.MUser;
import org.compiere.model.MUserMail;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.EMail;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.util.TokenGeneratorHandler;

public class GeneratePassword {
    StringBuffer msg = new StringBuffer();
    StringBuffer msgException = new StringBuffer();

    public String doIt(String userName) {
        List<MUser> users = MUser.getUsers(Env.getCtx(), userName);
        users.stream().filter(user -> user.isActive() && user.isLoginUser()).forEach(user -> {
            try {
                this.msg.append(this.generateToken((MUser)user));
            }
            catch (Exception e) {
                this.msg.append(e.getLocalizedMessage());
            }
        });
        return this.msg.toString();
    }

    public String generateToken(MUser user) throws Exception {
        if (user == null) {
            throw new AdempiereUserError("@AD_User_ID@ @NotFound@");
        }
        if (Util.isEmpty(user.getEMail())) {
            throw new AdempiereUserError("@AD_User_ID@ - @Email@ @NotFound@");
        }
        MClient client = MClient.get(user.getCtx(), user.getAD_Client_ID());
        MClientInfo clientInfo = client.getInfo();
        TokenGeneratorHandler.getInstance().generateToken("URL", user.getAD_User_ID());
        int mailTextId = clientInfo.getRestorePassword_MailText_ID();
        if (mailTextId <= 0) {
            throw new AdempiereUserError("@RestorePassword_MailText_ID@ @NotFound@");
        }
        MMailText text = new MMailText(Env.getCtx(), mailTextId, null);
        text.setPO(TokenGeneratorHandler.getInstance().getToken("URL"));
        text.setUser(user);
        EMail email = client.createEMail(user.getEMail(), null, null);
        String msg = null;
        if (!email.isValid()) {
            msg = "@RequestActionEMailError@ Invalid EMail: " + user;
            throw new AdempiereUserError("@RequestActionEMailError@ Invalid EMail: " + user);
        }
        String message = text.getMailText(true);
        email.setMessageHTML(text.getMailHeader(), message);
        msg = email.send();
        MUserMail um = new MUserMail(text, user.getAD_User_ID(), email);
        um.saveEx();
        if (!msg.equals("OK")) {
            throw new AdempiereUserError(user.getName() + " @RequestActionEMailError@ " + msg);
        }
        return msg;
    }
}

