/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util;

import java.security.SecureRandom;
import java.sql.Timestamp;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.spin.model.MADToken;
import org.spin.util.ITokenGenerator;

public class TokenGenerator
implements ITokenGenerator {
    protected static SecureRandom random = new SecureRandom();
    private String token;
    private MADToken passReset;
    private Timestamp expireDate;

    @Override
    public String generateToken(String tokenType, int userId) {
        long longToken = Math.abs(random.nextLong());
        String random = Long.toString(longToken, 16);
        this.token = random + userId;
        this.expireDate = new Timestamp(System.currentTimeMillis() + 300000L);
        this.passReset = new MADToken(Env.getCtx(), 0, null);
        this.passReset.setTokenType(tokenType);
        this.passReset.setExpireDate(this.expireDate);
        this.passReset.setTokenValue(this.token);
        this.passReset.setAD_User_ID(userId);
        this.passReset.saveEx();
        return this.token;
    }

    @Override
    public boolean validateToken(String token, int userId) {
        MADToken passReset = (MADToken)new Query(Env.getCtx(), "AD_Token", "TokenValue = ? AND AD_User_ID = ?", null).setParameters(token, userId).first();
        Timestamp current = new Timestamp(System.currentTimeMillis());
        return passReset != null && passReset.getExpireDate().compareTo(current) > 0;
    }

    @Override
    public MADToken getToken() {
        return this.passReset;
    }

    @Override
    public String getTokenValue() {
        return this.token;
    }
}

