/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.JEditorPane;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBasePrintHyperlink;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.util.JEditorPaneMarkupProcessor;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import net.sf.jasperreports.engine.util.JRTextAttribute;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JEditorPaneHtmlMarkupProcessor
extends JEditorPaneMarkupProcessor {
    private static final Log log = LogFactory.getLog(JEditorPaneHtmlMarkupProcessor.class);
    public static final String DEFAULT_BULLET_CHARACTER = "\u2022";
    public static final String DEFAULT_BULLET_SEPARATOR = ".";
    private static JEditorPaneHtmlMarkupProcessor instance;

    public static JEditorPaneHtmlMarkupProcessor getInstance() {
        if (instance == null) {
            instance = new JEditorPaneHtmlMarkupProcessor();
        }
        return instance;
    }

    @Override
    public String convert(String srcText) {
        JEditorPane editorPane = new JEditorPane("text/html", srcText);
        editorPane.setEditable(false);
        ArrayList<Element> elements = new ArrayList<Element>();
        Document document = editorPane.getDocument();
        Element root = document.getDefaultRootElement();
        if (root != null) {
            this.addElements(elements, root);
        }
        int startOffset = 0;
        int endOffset = 0;
        int crtOffset = 0;
        String chunk = null;
        JRBasePrintHyperlink hyperlink = null;
        Element element = null;
        Element parent = null;
        boolean bodyOccurred = false;
        int[] orderedListIndex = new int[elements.size()];
        String whitespace = "    ";
        String[] whitespaces = new String[elements.size()];
        for (int i = 0; i < elements.size(); ++i) {
            whitespaces[i] = "";
        }
        StringBuilder text = new StringBuilder();
        ArrayList<JRStyledText.Run> styleRuns = new ArrayList<JRStyledText.Run>();
        for (int i = 0; i < elements.size(); ++i) {
            HTMLDocument.RunElement runElement;
            AttributeSet attrSet;
            Object object;
            if (bodyOccurred && chunk != null) {
                text.append(chunk);
                Map<AttributedCharacterIterator.Attribute, Object> styleAttributes = this.getAttributes(element.getAttributes());
                if (hyperlink != null) {
                    styleAttributes.put(JRTextAttribute.HYPERLINK, hyperlink);
                    hyperlink = null;
                }
                if (!styleAttributes.isEmpty()) {
                    styleRuns.add(new JRStyledText.Run(styleAttributes, startOffset + crtOffset, endOffset + crtOffset));
                }
            }
            chunk = null;
            element = (Element)elements.get(i);
            parent = element.getParentElement();
            startOffset = element.getStartOffset();
            endOffset = element.getEndOffset();
            AttributeSet attrs = element.getAttributes();
            Object elementName = attrs.getAttribute("$ename");
            Object object2 = object = elementName != null ? null : attrs.getAttribute(StyleConstants.NameAttribute);
            if (!(object instanceof HTML.Tag)) continue;
            HTML.Tag htmlTag = (HTML.Tag)object;
            if (htmlTag == HTML.Tag.BODY) {
                bodyOccurred = true;
                crtOffset = -startOffset;
                continue;
            }
            if (htmlTag == HTML.Tag.BR) {
                chunk = "\n";
                continue;
            }
            if (htmlTag == HTML.Tag.OL) {
                orderedListIndex[i] = 0;
                String parentName = parent.getName().toLowerCase();
                whitespaces[i] = whitespaces[elements.indexOf(parent)] + whitespace;
                if (parentName.equals("li")) {
                    chunk = "";
                    continue;
                }
                chunk = "\n";
                ++crtOffset;
                continue;
            }
            if (htmlTag == HTML.Tag.UL) {
                whitespaces[i] = whitespaces[elements.indexOf(parent)] + whitespace;
                String parentName = parent.getName().toLowerCase();
                if (parentName.equals("li")) {
                    chunk = "";
                    continue;
                }
                chunk = "\n";
                ++crtOffset;
                continue;
            }
            if (htmlTag == HTML.Tag.LI) {
                whitespaces[i] = whitespaces[elements.indexOf(parent)];
                if (element.getElement(0) != null && (element.getElement(0).getName().toLowerCase().equals("ol") || element.getElement(0).getName().toLowerCase().equals("ul"))) {
                    chunk = "";
                } else if (parent.getName().equals("ol")) {
                    int index = elements.indexOf(parent);
                    Object type = parent.getAttributes().getAttribute(HTML.Attribute.TYPE);
                    Object startObject = parent.getAttributes().getAttribute(HTML.Attribute.START);
                    int start = startObject == null ? 0 : Math.max(0, Integer.valueOf(startObject.toString()) - 1);
                    String suffix = "";
                    int n = index;
                    orderedListIndex[n] = orderedListIndex[n] + 1;
                    if (type != null) {
                        switch (((String)type).charAt(0)) {
                            case 'A': {
                                suffix = JEditorPaneHtmlMarkupProcessor.getOLBulletChars(orderedListIndex[index] + start, true);
                                break;
                            }
                            case 'a': {
                                suffix = JEditorPaneHtmlMarkupProcessor.getOLBulletChars(orderedListIndex[index] + start, false);
                                break;
                            }
                            case 'I': {
                                suffix = JRStringUtil.getRomanNumeral(orderedListIndex[index] + start, true);
                                break;
                            }
                            case 'i': {
                                suffix = JRStringUtil.getRomanNumeral(orderedListIndex[index] + start, false);
                                break;
                            }
                            default: {
                                suffix = String.valueOf(orderedListIndex[index] + start);
                                break;
                            }
                        }
                    } else {
                        suffix = suffix + (orderedListIndex[index] + start);
                    }
                    chunk = whitespaces[index] + suffix + DEFAULT_BULLET_SEPARATOR + "  ";
                } else {
                    chunk = whitespaces[elements.indexOf(parent)] + DEFAULT_BULLET_CHARACTER + "  ";
                }
                crtOffset += chunk.length();
                continue;
            }
            if (!(element instanceof AbstractDocument.LeafElement)) continue;
            if (element instanceof HTMLDocument.RunElement && (attrSet = (AttributeSet)(runElement = (HTMLDocument.RunElement)element).getAttribute(HTML.Tag.A)) != null) {
                hyperlink = new JRBasePrintHyperlink();
                hyperlink.setHyperlinkType(HyperlinkTypeEnum.REFERENCE);
                hyperlink.setHyperlinkReference((String)attrSet.getAttribute(HTML.Attribute.HREF));
                hyperlink.setLinkTarget((String)attrSet.getAttribute(HTML.Attribute.TARGET));
            }
            try {
                chunk = document.getText(startOffset, endOffset - startOffset);
                continue;
            }
            catch (BadLocationException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Error converting markup.", e);
            }
        }
        if (chunk != null) {
            if (!"\n".equals(chunk)) {
                text.append(chunk);
                Map<AttributedCharacterIterator.Attribute, Object> styleAttributes = this.getAttributes(element.getAttributes());
                if (hyperlink != null) {
                    styleAttributes.put(JRTextAttribute.HYPERLINK, hyperlink);
                    hyperlink = null;
                }
                if (!styleAttributes.isEmpty()) {
                    styleRuns.add(new JRStyledText.Run(styleAttributes, startOffset + crtOffset, endOffset + crtOffset));
                }
            } else {
                int length = text.length();
                ListIterator<JRStyledText.Run> it = styleRuns.listIterator();
                while (it.hasNext()) {
                    JRStyledText.Run run = (JRStyledText.Run)it.next();
                    if (run.endIndex != length + 1) continue;
                    if (run.startIndex < run.endIndex - 1) {
                        it.set(new JRStyledText.Run(run.attributes, run.startIndex, run.endIndex - 1));
                        continue;
                    }
                    it.remove();
                }
            }
        }
        JRStyledText styledText = new JRStyledText(null, text.toString());
        for (JRStyledText.Run run : styleRuns) {
            styledText.addRun(run);
        }
        styledText.setGlobalAttributes(new HashMap<AttributedCharacterIterator.Attribute, Object>());
        return JRStyledTextParser.getInstance().write(styledText);
    }

    protected void addElements(List<Element> elements, Element element) {
        elements.add(element);
        for (int i = 0; i < element.getElementCount(); ++i) {
            Element child = element.getElement(i);
            this.addElements(elements, child);
        }
    }

    @Override
    protected Map<AttributedCharacterIterator.Attribute, Object> getAttributes(AttributeSet attrSet) {
        HashMap<AttributedCharacterIterator.Attribute, Object> attrMap = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        if (attrSet.isDefined(StyleConstants.FontFamily)) {
            attrMap.put(TextAttribute.FAMILY, StyleConstants.getFontFamily(attrSet));
        }
        if (attrSet.isDefined(StyleConstants.Bold)) {
            attrMap.put(TextAttribute.WEIGHT, StyleConstants.isBold(attrSet) ? TextAttribute.WEIGHT_BOLD : TextAttribute.WEIGHT_REGULAR);
        }
        if (attrSet.isDefined(StyleConstants.Italic)) {
            attrMap.put(TextAttribute.POSTURE, StyleConstants.isItalic(attrSet) ? TextAttribute.POSTURE_OBLIQUE : TextAttribute.POSTURE_REGULAR);
        }
        if (attrSet.isDefined(StyleConstants.Underline)) {
            attrMap.put(TextAttribute.UNDERLINE, StyleConstants.isUnderline(attrSet) ? TextAttribute.UNDERLINE_ON : null);
        }
        if (attrSet.isDefined(StyleConstants.StrikeThrough)) {
            attrMap.put(TextAttribute.STRIKETHROUGH, StyleConstants.isStrikeThrough(attrSet) ? TextAttribute.STRIKETHROUGH_ON : null);
        }
        if (attrSet.isDefined(StyleConstants.FontSize)) {
            attrMap.put(TextAttribute.SIZE, new Float(StyleConstants.getFontSize(attrSet)));
        }
        if (attrSet.isDefined(StyleConstants.Foreground)) {
            attrMap.put(TextAttribute.FOREGROUND, StyleConstants.getForeground(attrSet));
        }
        if (attrSet.isDefined(StyleConstants.Background)) {
            attrMap.put(TextAttribute.BACKGROUND, StyleConstants.getBackground(attrSet));
        }
        if (attrSet.isDefined(StyleConstants.Superscript) && !StyleConstants.isSubscript(attrSet)) {
            attrMap.put(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER);
        }
        if (attrSet.isDefined(StyleConstants.Subscript) && StyleConstants.isSubscript(attrSet)) {
            attrMap.put(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB);
        }
        return attrMap;
    }

    protected static String getOLBulletChars(int index, boolean isUpperCase) {
        if (index < 0 || index > 18277) {
            throw new JRRuntimeException("util.markup.processor.number.outside.bounds", new Object[]{index});
        }
        return JRStringUtil.getLetterNumeral(index, isUpperCase);
    }
}

