/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class JRXmlUtils {
    private static final Log log = LogFactory.getLog(JRXmlUtils.class);
    public static final String EXCEPTION_MESSAGE_KEY_DOCUMENT_BUILDER_FACTORY_CREATION_FAILURE = "util.xml.document.builder.factory.creation.failure";
    public static final String EXCEPTION_MESSAGE_KEY_DOCUMENT_PARSING_FAILURE = "util.xml.document.parsing.failure";
    public static final String PROPERTY_ALLOW_DOCTYPE = "net.sf.jasperreports.xml.allow.doctype";
    public static final String FEATURE_DISALLOW_DOCTYPE = "http://apache.org/xml/features/disallow-doctype-decl";

    public static Document parse(InputSource is) throws JRException {
        return JRXmlUtils.parse(is, false);
    }

    public static Document parse(InputSource is, boolean isNamespaceAware) throws JRException {
        try {
            return JRXmlUtils.createDocumentBuilder(isNamespaceAware).parse(is);
        }
        catch (SAXException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_DOCUMENT_PARSING_FAILURE, null, e);
        }
        catch (IOException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_DOCUMENT_PARSING_FAILURE, null, e);
        }
    }

    public static Document parse(String uri) throws JRException {
        return JRXmlUtils.parse(uri, false);
    }

    public static Document parse(String uri, boolean isNamespaceAware) throws JRException {
        return JRXmlUtils.parse(new InputSource(uri), isNamespaceAware);
    }

    public static Document parse(File file) throws JRException {
        return JRXmlUtils.parse(file, false);
    }

    public static Document parse(File file, boolean isNamespaceAware) throws JRException {
        try {
            return JRXmlUtils.createDocumentBuilder(isNamespaceAware).parse(file);
        }
        catch (SAXException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_DOCUMENT_PARSING_FAILURE, null, e);
        }
        catch (IOException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_DOCUMENT_PARSING_FAILURE, null, e);
        }
    }

    public static Document parse(InputStream is) throws JRException {
        return JRXmlUtils.parse(is, false);
    }

    public static Document parse(InputStream is, boolean isNamespaceAware) throws JRException {
        return JRXmlUtils.parse(new InputSource(is), isNamespaceAware);
    }

    public static Document parse(URL url) throws JRException {
        return JRXmlUtils.parse(url, false);
    }

    public static Document parse(URL url, boolean isNamespaceAware) throws JRException {
        InputStream is = null;
        try {
            is = url.openStream();
            Document document = JRXmlUtils.createDocumentBuilder(isNamespaceAware).parse(is);
            return document;
        }
        catch (SAXException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_DOCUMENT_PARSING_FAILURE, null, e);
        }
        catch (IOException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_DOCUMENT_PARSING_FAILURE, null, e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    log.warn("Error closing stream of URL " + url, e);
                }
            }
        }
    }

    public static DocumentBuilder createDocumentBuilder() throws JRException {
        return JRXmlUtils.createDocumentBuilder(false);
    }

    public static DocumentBuilder createDocumentBuilder(boolean isNamespaceAware) throws JRException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setIgnoringComments(true);
        dbf.setNamespaceAware(isNamespaceAware);
        try {
            if (!JRXmlUtils.allowDoctype()) {
                dbf.setFeature(FEATURE_DISALLOW_DOCTYPE, true);
            }
            return dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_DOCUMENT_BUILDER_FACTORY_CREATION_FAILURE, null, e);
        }
    }

    protected static boolean allowDoctype() {
        return JRPropertiesUtil.getInstance(DefaultJasperReportsContext.getInstance()).getBooleanProperty(PROPERTY_ALLOW_DOCTYPE, false);
    }

    public static Document createDocument(Node sourceNode) throws JRException {
        return JRXmlUtils.createDocument(sourceNode, false);
    }

    public static Document createDocument(Node sourceNode, boolean isNamespaceAware) throws JRException {
        Document doc = JRXmlUtils.createDocumentBuilder(isNamespaceAware).newDocument();
        Node source = sourceNode.getNodeType() == 9 ? ((Document)sourceNode).getDocumentElement() : sourceNode;
        Node node = doc.importNode(source, true);
        doc.appendChild(node);
        return doc;
    }

    private JRXmlUtils() {
    }
}

